/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.collector;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOptionContributor;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RunConfigurationCollector {
    public static final String CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH = PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME + File.separator + "execution";
    private static RunConfigurationCollector _instance;
    private Map<String, IRunConfigurationContributor> runConfigurationContributors = new HashMap<String, IRunConfigurationContributor>();

    private RunConfigurationCollector() {
    }

    public static RunConfigurationCollector getInstance() {
        if (_instance == null) {
            _instance = new RunConfigurationCollector();
        }
        return _instance;
    }

    public void addBuiltinRunConfigurationContributor(IRunConfigurationContributor runConfigurationContributor) {
        this.runConfigurationContributors.put(runConfigurationContributor.getId(), runConfigurationContributor);
    }

    private List<IRunConfigurationContributor> getListRunContributors() {
        ArrayList<IRunConfigurationContributor> contributors = new ArrayList<IRunConfigurationContributor>();
        for (Map.Entry<String, IRunConfigurationContributor> entry : this.runConfigurationContributors.entrySet()) {
            contributors.add(entry.getValue());
        }
        return contributors;
    }

    public IRunConfigurationContributor[] getAllBuiltinRunConfigurationContributors() {
        List<IRunConfigurationContributor> lstContributors = this.getListRunContributors();
        Collections.sort(lstContributors, new Comparator<IRunConfigurationContributor>(){

            @Override
            public int compare(IRunConfigurationContributor runConfigContributor_1, IRunConfigurationContributor runConfigContributor_2) {
                return runConfigContributor_1.getPreferredOrder() - runConfigContributor_2.getPreferredOrder();
            }
        });
        return lstContributors.toArray(new IRunConfigurationContributor[lstContributors.size()]);
    }

    public List<ConsoleOptionContributor> getConsoleOptionContributorList() {
        return new ArrayList<ConsoleOptionContributor>(this.getListRunContributors());
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        ArrayList additionalArgumentList = new ArrayList();
        for (IRunConfigurationContributor runConfigContributor : this.getListRunContributors()) {
            additionalArgumentList.addAll(runConfigContributor.getConsoleOptionList());
        }
        return additionalArgumentList;
    }

    public CustomRunConfigurationContributor[] getAllCustomRunConfigurationContributors() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return new CustomRunConfigurationContributor[0];
        }
        File customProfileSettingFolder = new File(currentProject.getFolderLocation() + File.separator + CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH);
        if (!customProfileSettingFolder.exists() || !customProfileSettingFolder.isDirectory()) {
            return new CustomRunConfigurationContributor[0];
        }
        ArrayList<CustomRunConfigurationContributor> customRunConfigContributorList = new ArrayList<CustomRunConfigurationContributor>();
        File[] fileArray = customProfileSettingFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File customProfile = fileArray[n2];
            if (customProfile.isDirectory() && !customProfile.isHidden()) {
                customRunConfigContributorList.add(new CustomRunConfigurationContributor(customProfile.getName()));
            }
            ++n2;
        }
        return customRunConfigContributorList.toArray(new CustomRunConfigurationContributor[customRunConfigContributorList.size()]);
    }

    public IRunConfiguration getRunConfiguration(String id, String projectDir) throws ExecutionException, URISyntaxException, TestCloudException {
        try {
            if (this.runConfigurationContributors.containsKey(id)) {
                return this.runConfigurationContributors.get(id).getRunConfiguration(projectDir);
            }
            CustomRunConfigurationContributor[] customRunConfigurationContributorArray = this.getAllCustomRunConfigurationContributors();
            int n = customRunConfigurationContributorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CustomRunConfigurationContributor customRunConfigurationContributor = customRunConfigurationContributorArray[n2];
                if (customRunConfigurationContributor.getId().equals(id)) {
                    return customRunConfigurationContributor.getRunConfiguration(projectDir);
                }
                ++n2;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException((Throwable)e);
        }
        return null;
    }

    public IRunConfiguration getRunConfiguration(String id, String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException, URISyntaxException, TestCloudException {
        if (this.runConfigurationContributors.containsKey(id)) {
            return this.runConfigurationContributors.get(id).getRunConfiguration(projectDir, runConfigurationDescription);
        }
        CustomRunConfigurationContributor[] customRunConfigurationContributorArray = this.getAllCustomRunConfigurationContributors();
        int n = customRunConfigurationContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRunConfigurationContributor customRunConfigurationContributor = customRunConfigurationContributorArray[n2];
            if (customRunConfigurationContributor.getId().equals(id)) {
                return customRunConfigurationContributor.getRunConfiguration(projectDir, runConfigurationDescription);
            }
            ++n2;
        }
        return null;
    }

    public IRunConfigurationContributor getRunContributor(String id) {
        if (this.runConfigurationContributors.containsKey(id)) {
            return this.runConfigurationContributors.get(id);
        }
        CustomRunConfigurationContributor[] customRunConfigurationContributorArray = this.getAllCustomRunConfigurationContributors();
        int n = customRunConfigurationContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRunConfigurationContributor customRunConfigurationContributor = customRunConfigurationContributorArray[n2];
            if (customRunConfigurationContributor.getId().equals(id)) {
                return customRunConfigurationContributor;
            }
            ++n2;
        }
        return null;
    }

    public String[] getAllCustomRunConfigurationIds() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject == null) {
            return new String[0];
        }
        File customProfileSettingFolder = new File(currentProject.getFolderLocation() + File.separator + CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH);
        if (!customProfileSettingFolder.exists() || !customProfileSettingFolder.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> customRunConfigIdList = new ArrayList<String>();
        File[] fileArray = customProfileSettingFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File customProfile = fileArray[n2];
            if (customProfile.isDirectory() && !customProfile.isHidden()) {
                customRunConfigIdList.add(customProfile.getName());
            }
            ++n2;
        }
        return customRunConfigIdList.toArray(new String[customRunConfigIdList.size()]);
    }
}

