/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.collector;

import com.kms.katalon.core.testobject.BrokenTestObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;

public class SelfHealingExecutionReport {
    private boolean isEnabled;
    private boolean isTriggered;
    private Set<BrokenTestObject> brokenTestObjects;

    public SelfHealingExecutionReport(boolean isEnabled, boolean isTriggered, Set<BrokenTestObject> brokenTestObjects) {
        this.isEnabled = isEnabled;
        this.isTriggered = isTriggered;
        this.brokenTestObjects = brokenTestObjects;
    }

    public String getHealingInfo() {
        if (!this.hasHealedAnyObject()) {
            return null;
        }
        ArrayList healingRecords = new ArrayList();
        this.brokenTestObjects.forEach(brokenTestObject -> {
            String healingRecord = MessageFormat.format("{0}:{1}", brokenTestObject.getBrokenLocatorMethod(), brokenTestObject.getRecoveryMethod());
            healingRecords.add(healingRecord);
        });
        String healingInfo = healingRecords.stream().collect(Collectors.joining(","));
        return healingInfo;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isTriggered() {
        return this.isTriggered;
    }

    public void setTriggered(boolean isTriggered) {
        this.isTriggered = isTriggered;
    }

    public Set<BrokenTestObject> getBrokenTestObjects() {
        return this.brokenTestObjects;
    }

    public void setBrokenTestObjects(Set<BrokenTestObject> brokenTestObjects) {
        this.brokenTestObjects = brokenTestObjects;
    }

    public boolean hasHealedAnyObject() {
        return this.isTriggered && this.brokenTestObjects != null && !this.brokenTestObjects.isEmpty();
    }
}

