/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestSuiteRunConfigurationBuilder {
    private RunConfigurationDescription runConfigDescription;
    private String browserType;
    private String projectDir;
    private IRunConfigurationContributor contributor;
    private ExecutionProfileEntity executionProfile;
    private TestSuiteEntity testSuiteEntity;
    private String testSuiteCollectionId;
    private DefaultRerunSetting rerunSettings;
    private int failedThreshold;
    private Map<String, Object> globalVariables;
    private Map<String, Object> protectedGlobalVariables;
    private String executionUUID;
    private String executionSessionId;
    private Map<String, String> additionalInfo;
    private boolean enableProfiling;

    public TestSuiteRunConfigurationBuilder withRunConfigDescription(RunConfigurationDescription runConfigDescription) {
        this.runConfigDescription = runConfigDescription;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withBrowserType(String browserType) {
        this.browserType = browserType;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withProjectDir(String projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withContributor(IRunConfigurationContributor contributor) {
        this.contributor = contributor;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withExecutionProfile(ExecutionProfileEntity executionProfile) {
        this.executionProfile = executionProfile;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withTestSuiteEntity(TestSuiteEntity testSuiteEntity) {
        this.testSuiteEntity = testSuiteEntity;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withTestSuiteCollectionId(String testSuiteCollectionId) {
        this.testSuiteCollectionId = testSuiteCollectionId;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withRerunSettings(DefaultRerunSetting rerunSettings) {
        this.rerunSettings = rerunSettings;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withFailedThreshold(int failedThreshold) {
        this.failedThreshold = failedThreshold;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withGlobalVariables(Map<String, Object> globalVariables) {
        this.globalVariables = globalVariables;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withProtectedGlobalVariables(Map<String, Object> protectedGlobalVariables) {
        this.protectedGlobalVariables = protectedGlobalVariables;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withExecutionUUID(String executionUUID) {
        this.executionUUID = executionUUID;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withExecutionSessionId(String executionSessionId) {
        this.executionSessionId = executionSessionId;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public TestSuiteRunConfigurationBuilder withEnableProfiling(boolean enableProfiling) {
        this.enableProfiling = enableProfiling;
        return this;
    }

    public IRunConfiguration build() throws Exception {
        AbstractRunConfiguration runConfig = (AbstractRunConfiguration)this.contributor.getRunConfiguration(this.projectDir, this.runConfigDescription);
        if (runConfig == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_BROWSER_X, this.browserType));
        }
        if (this.executionProfile != null) {
            runConfig.setExecutionProfile(this.executionProfile);
        }
        TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(this.testSuiteEntity);
        if (!StringUtils.isBlank((CharSequence)this.testSuiteCollectionId)) {
            executedEntity.setTestSuiteCollectionId(this.testSuiteCollectionId);
            executedEntity.setInCollection(true);
        }
        DefaultRerunSetting mergedRerunSetting = this.rerunSettings == null ? executedEntity.getRerunSetting() : (DefaultRerunSetting)this.rerunSettings.mergeWith(executedEntity.getRerunSetting());
        executedEntity.setRerunSetting(mergedRerunSetting);
        executedEntity.setFailedThreshold(this.failedThreshold);
        executedEntity.prepareTestCases();
        runConfig.setOverridingGlobalVariables(this.globalVariables);
        runConfig.setOverridingProtectedGlobalVariables(this.protectedGlobalVariables);
        runConfig.setExecutionUUID(this.executionUUID);
        runConfig.setExecutionSessionId(this.executionSessionId);
        runConfig.setAdditionalInfo(this.additionalInfo);
        runConfig.setEnableProfiling(this.enableProfiling);
        runConfig.build((FileEntity)this.testSuiteEntity, executedEntity);
        return runConfig;
    }
}

