/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.configuration.impl;

import com.google.gson.Gson;
import com.kms.katalon.configuration.core.interfaces.IExecutionSetting;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.internal.MobilePlatformExecutionSettings;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.setting.ExecutionSettingStore;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionSetting
implements IExecutionSetting {
    private IExecutedEntity executedEntity;
    private String folderPath;
    private int timeout = 10;
    private File scriptFile;
    private String rawScript;
    private Map<String, Object> generalProperties;
    private static Logger logger = LoggerFactory.getLogger(DefaultExecutionSetting.class);

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Map<String, Object> getGeneralProperties() {
        return this.getDefaultGeneralProperties();
    }

    public Map<String, Object> getDefaultGeneralProperties() {
        this.generalProperties = new HashMap<String, Object>();
        this.generalProperties.put("timeout", this.timeout);
        this.generalProperties.put("report", this.getReportProperties());
        this.generalProperties.put("defaultFailureHandling", this.getDefaultFailureHandlingSetting());
        this.generalProperties.put("proxy", this.getJsonProxyInformationWithEncryptedPassword());
        this.generalProperties.put("terminateDriverAfterTestCase", ExecutionUtil.isQuitDriversAfterExecutingTestCase());
        this.generalProperties.put("terminateDriverAfterTestSuite", ExecutionUtil.isQuitDriversAfterExecutingTestSuite());
        this.generalProperties.put("autoApplyNeighborXpaths", ExecutionUtil.getAutoApplyNeighborXpaths());
        if (this.executedEntity != null) {
            this.generalProperties.put("testDataInfo", this.executedEntity.getCollectedDataInfo());
        }
        return this.generalProperties;
    }

    private Map<String, Object> getReportProperties() {
        HashMap<String, Object> reportProps = new HashMap<String, Object>();
        try {
            ExecutionSettingStore reportSettings = new ExecutionSettingStore(this.getCurrentProject());
            reportProps.put("reportFolder", this.getFolderPath());
            reportProps.put("takeScreenshotSettings", reportSettings.getTakeScreenSettings());
            reportProps.put("videoRecorderSettings", reportSettings.getVideoRecorderSettings());
            reportProps.put("screenCaptureOption", reportSettings.getScreenCaptureOption());
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
        return reportProps;
    }

    protected ProjectEntity getCurrentProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    public String getLogFileName() {
        return "execution";
    }

    public IExecutedEntity getExecutedEntity() {
        return this.executedEntity;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getSettingFileName() {
        return "execution.properties";
    }

    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    public void setExecutedEntity(IExecutedEntity executedEntity) {
        this.executedEntity = executedEntity;
    }

    public String getSettingFilePath() {
        return new File(this.folderPath, this.getSettingFileName()).getAbsolutePath();
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getRawScript() {
        return this.rawScript;
    }

    public void setRawScript(String rawScript) {
        this.rawScript = rawScript;
    }

    public String getName() {
        return FilenameUtils.getBaseName((String)this.getFolderPath());
    }

    public String getDefaultFailureHandlingSetting() {
        return new TestCaseSettingStore(this.getCurrentProject().getFolderLocation()).getDefaultFailureHandling().name();
    }

    private String getJsonProxyInformationWithEncryptedPassword() {
        ProxyInformation proxyInfo = ProxyPreferences.getSystemProxyInformation();
        String password = proxyInfo.getPassword();
        if (!StringUtils.isEmpty((String)password)) {
            try {
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)password);
                proxyInfo.setPassword(CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo));
            }
            catch (IOException | GeneralSecurityException exception) {}
        }
        return new Gson().toJson((Object)proxyInfo);
    }

    public static Map<String, Object> buildExecutionSettingsForMobileRecorder() {
        Object reportProperties;
        DefaultExecutionSetting generalExecutionSetting = new DefaultExecutionSetting();
        int timeout = generalExecutionSetting.getTimeout();
        try {
            MobilePlatformExecutionSettings settings;
            MobileSettingStore store = MobileSettingStore.getStore();
            if (store != null && (settings = store.getExecutionSettings()) != null) {
                timeout = settings.getElementTimeoutInSeconds();
            }
        }
        catch (IOException e) {
            logger.warn("Failed to load mobile settings (IO error), using default timeout: {} seconds", (Object)timeout, (Object)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error loading mobile settings, using default timeout: {} seconds", (Object)timeout, (Object)e);
        }
        generalExecutionSetting.setTimeout(timeout);
        Map<String, Object> generalProperties = generalExecutionSetting.getGeneralProperties();
        if (generalProperties != null && (reportProperties = generalProperties.get("report")) instanceof Map) {
            Map reportPropertiesMap = (Map)reportProperties;
            reportPropertiesMap.put("screenCaptureOption", false);
        }
        return generalProperties;
    }
}

