/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.generator;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.generator.TestCaseBindingStringBuilderV2;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;

public class TestCaseBindingScriptGenerator {
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.execution.generator.TestCaseBindingScriptTemplate";
    private static final String GENERATED_TEST_CASE_BINDING_SCRIPT_METHOD_NAME = "generateTestCaseBindingScriptFile";
    private static final String TEMP_TEST_CASE_FILE_NAME = "TempTestCaseBinding";
    private TestCaseEntity testCase;
    private IRunConfiguration runConfig;
    private TestCaseBindingExecutedEntity executedEntity;
    private StringBuilder syntaxErrorCollector;

    public TestCaseBindingScriptGenerator(TestCaseEntity testCase, IRunConfiguration runConfig, TestCaseBindingExecutedEntity executedEntity) {
        this.testCase = testCase;
        this.runConfig = runConfig;
        this.executedEntity = executedEntity;
    }

    public File generateScriptFile() throws Exception {
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)this.testCase.getProject());
        File file = new File(libFolder.getRawLocation().toString(), TEMP_TEST_CASE_FILE_NAME + System.currentTimeMillis() + ".groovy");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        GroovyObject object = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).newInstance();
        object.invokeMethod(GENERATED_TEST_CASE_BINDING_SCRIPT_METHOD_NAME, (Object)new Object[]{file, this.testCase, this.createTestCaseBindingFile(), this.runConfig});
        libFolder.refreshLocal(1, null);
        return file;
    }

    public String generateScriptAsString() throws Exception {
        GroovyObject object = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).newInstance();
        Object[] objectArray = new Object[4];
        objectArray[1] = this.testCase;
        objectArray[2] = this.createTestCaseBindingFile();
        objectArray[3] = this.runConfig;
        return (String)object.invokeMethod(GENERATED_TEST_CASE_BINDING_SCRIPT_METHOD_NAME, (Object)objectArray);
    }

    private File createTestCaseBindingFile() throws Exception {
        this.syntaxErrorCollector = new StringBuilder();
        File testCaseBindingFile = new File(ReportController.getInstance().generateTemporaryExecutionFolder((FileEntity)this.testCase), "testCaseBinding");
        if (testCaseBindingFile.exists()) {
            testCaseBindingFile.delete();
        }
        testCaseBindingFile.createNewFile();
        FileUtils.writeLines((File)testCaseBindingFile, (String)"UTF-8", this.getTestCaseBindingString(), (boolean)true);
        if (this.syntaxErrorCollector.toString().isEmpty()) {
            return testCaseBindingFile;
        }
        throw new IllegalArgumentException(this.syntaxErrorCollector.toString());
    }

    private List<String> getTestCaseBindingString() throws Exception {
        ArrayList<String> testCaseBindingStrings = new ArrayList<String>();
        int iterationIdx = 0;
        while (iterationIdx < this.executedEntity.getTotalTestCases()) {
            TestCaseBindingStringBuilderV2 builder = new TestCaseBindingStringBuilderV2(iterationIdx, this.executedEntity);
            for (VariableLink variableLink : this.testCase.getVariableLinks()) {
                builder.append(variableLink, this.executedEntity.getTestDataMap());
            }
            if (!builder.hasErrors()) {
                testCaseBindingStrings.add(builder.build());
            } else {
                this.syntaxErrorCollector.append(builder.getErrorMessage()).append(SyntaxUtil.LINE_SEPARATOR);
            }
            ++iterationIdx;
        }
        return testCaseBindingStrings;
    }
}

