/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.common.About;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.mobile.util.MobileRunConfigurationUtil;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.RecordOption;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.collector.ExecutionInfo;
import com.kms.katalon.execution.collector.ExecutionInfoCollector;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.execution.collector.SelfHealingExecutionReportCollector;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.finders.AppiumDirectoryFinder;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ConsoleProcess;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.LaunchProcessor;
import com.kms.katalon.execution.launcher.result.ILauncherResult;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.setting.ReportSettingStore;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.execution.variable.ExecutionVariableManager;
import com.kms.katalon.network.core.model.config.AllNetworkPreferences;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import com.kms.katalon.tracking.service.CicdInfoService;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Deprecated
public class ConsoleLauncher
extends ReportableLauncher
implements IConsoleLauncher {
    private ITestOpsController testOpsController = this.getTestOpsControllerInstance();
    private IStudioAssistPreferences studioAssistPrefs;
    private INetworkPreferences networkPrefs;
    private ISessionManager sessionManager;
    private IDiscoveryService discoveryService;
    private static final String FILE_ENCODING_ARG = "-Dfile.encoding=";
    private static final String ENABLE_PROFILING_VM_ARG = "-Dkatalon.enableProfiling=true";
    private static final String DEFAULT_FILE_ENCODING_ARG = "-Dfile.encoding=UTF-8";
    private ExecutionVariableManager executionVariableManager = new ExecutionVariableManager();

    public ConsoleLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        super(manager, runConfig);
    }

    @Override
    public ReportableLauncher clone(IRunConfiguration runConfig) {
        return new ConsoleLauncher(this.getManager(), runConfig);
    }

    @Override
    protected ILaunchProcess launch() throws ExecutionException {
        try {
            Process systemProcess = this.executeProcess();
            if (systemProcess == null) {
                throw new ExecutionException(ExecutionMessageConstants.CONSOLE_CANNOT_START_EXECUTION);
            }
            return new ConsoleProcess(systemProcess, this.isUseGenerateConsoleLog(), this.getReportFolder());
        }
        catch (IOException ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    protected Process executeProcess() throws IOException, ExecutionException {
        try {
            HashMap<String, String> environmentVariables = new HashMap<String, String>();
            try {
                environmentVariables.putAll(this.runConfig.getAdditionalEnvironmentVariables());
            }
            catch (ExecutionException | IOException e) {
                throw new ExecutionException(e);
            }
            Map<String, Object> protectedGlobalVariables = this.getProtectedGlobalVariables();
            try {
                String protectedGlobalVariablesString = this.convertMapToString(protectedGlobalVariables, true);
                if (StringUtils.isNotBlank((String)protectedGlobalVariablesString)) {
                    environmentVariables.put("ProtectedGlobalVariables", protectedGlobalVariablesString);
                }
            }
            catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
                throw new ExecutionException(e);
            }
            Map<String, Object> overridingGlobalVariables = this.getOverridingGlobalVariables();
            try {
                String overridingGlobalVariablesString = this.convertMapToString(overridingGlobalVariables, true);
                if (StringUtils.isNotBlank((String)overridingGlobalVariablesString)) {
                    environmentVariables.put("OverridingGlobalVariables", overridingGlobalVariablesString);
                }
            }
            catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
                throw new ExecutionException(e);
            }
            Map<String, Object> overridingProtectedGlobalVariables = this.getOverridingProtectedGlobalVariables();
            try {
                String overridingProtectedGlobalVariablesString = this.convertMapToString(overridingProtectedGlobalVariables, true);
                if (StringUtils.isNotBlank((String)overridingProtectedGlobalVariablesString)) {
                    environmentVariables.put("OverridingProtectedGlobalVariables", overridingProtectedGlobalVariablesString);
                }
            }
            catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
                throw new ExecutionException(e);
            }
            try {
                IStudioAssistPreferences studioAssistPrefs = this.getStudioAssistPrefsInstance();
                StudioAssistConfig aiServiceConfig = studioAssistPrefs.getConfig();
                environmentVariables.put("AIServiceConfig", this.executionVariableManager.encodeVariable(aiServiceConfig));
                IDiscoveryService discoveryServiceInstance = this.getDiscoveryServiceInstance();
                String platformServerUrl = discoveryServiceInstance.getServerUrl(ServerType.PLATFORM);
                if (!StringUtils.isBlank((String)platformServerUrl)) {
                    environmentVariables.put("serverInfo", this.executionVariableManager.encodeVariable(Map.of(ServerType.PLATFORM, platformServerUrl)));
                }
                environmentVariables.put("katalonVersion", this.executionVariableManager.encodeVariable(About.releaseVersion()));
                ISessionManager sessionManager = this.getSessionManager();
                environmentVariables.put("account", this.executionVariableManager.encodeVariable(sessionManager.getAccount()));
                environmentVariables.put("organization", this.executionVariableManager.encodeVariable(sessionManager.getOrganization()));
                environmentVariables.put("user", this.executionVariableManager.encodeVariable(sessionManager.getUser()));
                environmentVariables.put("katOneToken", this.executionVariableManager.encodeVariable(sessionManager.getKatOneToken()));
            }
            catch (Exception error) {
                throw new ExecutionException((Throwable)error);
            }
            try {
                INetworkPreferences networkPrefs = this.getNetworkPrefsInstance();
                AllNetworkPreferences allNetworkPrefs = networkPrefs.getNetworkPrefs();
                environmentVariables.put("NetworkPreferences", this.executionVariableManager.encodeVariable(allNetworkPrefs));
            }
            catch (Exception error) {
                throw new ExecutionException((Throwable)error);
            }
            return new LaunchProcessor(ClassPathResolver.getClassPaths(ProjectController.getInstance().getCurrentProject()), environmentVariables, this.getVMArgs()).execute(this.getRunConfig().getExecutionSetting().getScriptFile());
        }
        catch (ControllerException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private String[] getVMArgs() {
        String[] args = this.runConfig.getVmArgs();
        Optional<String> fileEncodingArg = Stream.of(args).filter(vmArg -> vmArg.startsWith(FILE_ENCODING_ARG)).findFirst();
        ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
        if (fileEncodingArg.isEmpty()) {
            argsList.add(DEFAULT_FILE_ENCODING_ARG);
        }
        if (this.runConfig.shouldEnableProfiling()) {
            argsList.add(0, ENABLE_PROFILING_VM_ARG);
        }
        return argsList.toArray(new String[0]);
    }

    @Override
    public synchronized void addLogRecords(List<XmlLogRecord> records) {
        super.addLogRecords(records);
        this.clearRecords();
    }

    @Override
    public String getStatusMessage(int consoleWidth) {
        return this.getDefaultStatusMessage(consoleWidth);
    }

    @Override
    protected void postExecutionComplete() {
        super.postExecutionComplete();
        if (this.getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            File reportFolder = this.getReportFolder();
            SelfHealingExecutionReport selfHealingReport = SelfHealingExecutionReportCollector.getInstance().collect(this.runConfig, reportFolder);
            ExecutionInfo executionInfo = ExecutionInfoCollector.getInstance().collect(this.runConfig, this.getTestSuiteLogRecord(), this.getLogRecords());
            TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)this.getExecutedEntity();
            Trackings.trackExecuteTestSuiteInConsoleMode((TestSuiteTrackingInfo)this.buildTestSuiteTrackingInfo(tsExecutedEntity, selfHealingReport, executionInfo, this.getTestCloudRunConfiguration(), this.getTestCloudRecorderTestCaseCount(tsExecutedEntity.getExecutedItems()), this.getAIAPITestCaseCount(tsExecutedEntity.getExecutedItems()), this.getTestSuiteLogRecord()));
        }
    }

    private int getTestCloudRecorderTestCaseCount(List<IExecutedEntity> executedItems) {
        int count = 0;
        for (IExecutedEntity executed : executedItems) {
            TestCaseEntity entity;
            TestCaseExecutedEntity testCaseExecuted;
            FileEntity fileEntity;
            if (!(executed instanceof TestCaseExecutedEntity) || !((fileEntity = (testCaseExecuted = (TestCaseExecutedEntity)executed).getEntity()) instanceof TestCaseEntity) || !RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)(entity = (TestCaseEntity)fileEntity).getRecordOption())) continue;
            ++count;
        }
        return count;
    }

    private int getAIAPITestCaseCount(List<IExecutedEntity> executedItems) {
        int count = 0;
        for (IExecutedEntity executed : executedItems) {
            TestCaseEntity entity;
            TestCaseExecutedEntity testCaseExecuted;
            FileEntity fileEntity;
            if (!(executed instanceof TestCaseExecutedEntity) || !((fileEntity = (testCaseExecuted = (TestCaseExecutedEntity)executed).getEntity()) instanceof TestCaseEntity) || !(entity = (TestCaseEntity)fileEntity).isAPITestGenerationTestCase()) continue;
            ++count;
        }
        return count;
    }

    private Boolean isTestCloudTunnelEnabled(IRunConfiguration runConfiguration) {
        Boolean isUsingTestCloudTunnel = null;
        if (runConfiguration.getAdditionalInfo().containsKey("isUsingTestCloudTunnel")) {
            isUsingTestCloudTunnel = Boolean.valueOf((String)runConfiguration.getAdditionalInfo().get("isUsingTestCloudTunnel"));
        }
        return isUsingTestCloudTunnel;
    }

    protected String getExecutionResult() {
        String resultExecution = null;
        resultExecution = this.getResult().getNumFailures() > 0 ? TestStatus.TestStatusValue.FAILED.toString() : (this.getResult().getNumErrors() > 0 ? TestStatus.TestStatusValue.ERROR.toString() : TestStatus.TestStatusValue.PASSED.toString());
        return resultExecution;
    }

    @Override
    protected void onStartExecution() {
        super.onStartExecution();
    }

    private TestSuiteTrackingInfo buildTestSuiteTrackingInfo(TestSuiteExecutedEntity tsExecutedEntity, SelfHealingExecutionReport selfHealingExecutionReport, ExecutionInfo executionInfo, String testCloudRunConfiguration, int numTestCloudRecorderTestCase, int numberOfAIAPITestCase, TestSuiteLogRecord testSuiteLogRecord) {
        Organization organization;
        boolean isInTestSuiteCollection = tsExecutedEntity.isInCollection();
        String result = this.getExecutionResult();
        boolean usedMaxFailedTests = FailedTestThreshold.getInstance().isThresholdAvailable();
        boolean isDynamicTestSuite = tsExecutedEntity.getEntity() != null ? tsExecutedEntity.getEntity() instanceof FilteringTestSuiteEntity : false;
        int numberOfEmailsSent = MailUtil.getNumberOfEmailsSentForTestSuite(this.getAreEmailsSent(), (TestSuiteExecutedEntity)this.getExecutedEntity(), this.getTestSuiteLogRecord());
        TestSuiteTrackingInfo trackingInfo = new TestSuiteTrackingInfo();
        trackingInfo.setAnonymous(false);
        trackingInfo.setDriverType(this.runConfig.getReportDriverName());
        trackingInfo.setResult(result);
        trackingInfo.setDuration(this.getEndTime().getTime() - this.getStartTime().getTime());
        trackingInfo.setRetryStrategy(this.getRetryStrategy());
        trackingInfo.setNumberOfRetry(this.getNumberOfRetry());
        trackingInfo.setEnableSelfHealing(selfHealingExecutionReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingExecutionReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingExecutionReport.getHealingInfo());
        trackingInfo.setTotalTestCases(this.getResult().getTotalTestCases());
        trackingInfo.setPassedTestCases(this.getResult().getNumPasses());
        trackingInfo.setFailedTestCases(this.getResult().getNumFailures());
        trackingInfo.setErrorTestCases(this.getResult().getNumErrors());
        trackingInfo.setSkippedTestCases(this.getResult().getNumSkips());
        trackingInfo.setIncompleteTestCases(this.getResult().getNumIncomplete());
        trackingInfo.setOrigin(testSuiteLogRecord.getOrigin());
        trackingInfo.setFlowType("old");
        ApplicationContext context = ApplicationContext.getInstance();
        if (Objects.nonNull(context) && Objects.nonNull(organization = context.getOrganization())) {
            trackingInfo.setOrgId(organization.getId());
        }
        trackingInfo.setInCollection(isInTestSuiteCollection);
        trackingInfo.setEnableScreenshot(executionInfo.isEnableScreenshot());
        trackingInfo.setEnableHideHostname(ExecutionUtil.isEnabledHideHostname().booleanValue());
        trackingInfo.setEnableVideo(executionInfo.isEnableScreenshot());
        trackingInfo.setVideoRecordingLevel(executionInfo.getVideoRecordingLevel());
        trackingInfo.setNumTestSteps(this.getNumTestSteps());
        trackingInfo.setAdditionalProps(this.getIntegratedContributionsTrackingData());
        trackingInfo.setKeywordsUsage(executionInfo.getKeywordsUsage());
        trackingInfo.setExecutedTestCaseKeywordTypes(executionInfo.getExecutedTestCaseKeywordTypes());
        trackingInfo.setExecutedKeywordNames(executionInfo.getExecutedKeywordNames());
        trackingInfo.setUsedMaxFailedTestParam(usedMaxFailedTests);
        trackingInfo.setUsingApplitools(executionInfo.isUsingApplitools());
        trackingInfo.setUseDataBinding(tsExecutedEntity.isUseDdtAtTCLevel());
        trackingInfo.setSuiteTestCaseDataBinding(ExecutionUtil.hasSuiteTestCaseDataBinding(tsExecutedEntity));
        trackingInfo.setDynamicTestSuite(isDynamicTestSuite);
        trackingInfo.setIsTestCloudTunnelEnabled((Object)this.isTestCloudTunnelEnabled(this.runConfig));
        trackingInfo.setNumberOfEmailsSent(numberOfEmailsSent);
        trackingInfo.setTestCloudRunConfiguration(testCloudRunConfiguration);
        trackingInfo.setTestSuiteCollectionId(tsExecutedEntity.getTestSuiteCollectionId());
        trackingInfo.setTestcloudRecorderTestCaseCount(numTestCloudRecorderTestCase);
        trackingInfo.setNumberOfAIAPITestCase(numberOfAIAPITestCase);
        trackingInfo.setCicdIntegration(CicdInfoService.getCicdName());
        trackingInfo.setReportGenerationTypes(this.getReportGenerationTypes());
        String remoteDomainUrl = this.runConfig.getRemoteDomain();
        if (StringUtils.isNotBlank((String)remoteDomainUrl)) {
            trackingInfo.setRemoteDomain(remoteDomainUrl);
        }
        this.addAppiumInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        this.addIntegrationSettingInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        ExecutionDefaultSettingStore executionStore = ExecutionDefaultSettingStore.getStore();
        if (executionStore != null) {
            trackingInfo.setSmartWaitEnabled(executionStore.isSmartWaitEnabled());
        }
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        trackingInfo.setAIEmailReport(MailUtil.isAnalyzeFailedReasonByAI(currentProject));
        try {
            trackingInfo.setAIHtmlReport(ReportSettingStore.getStore().useAnalyzeFailedReasonByAI());
        }
        catch (IOException iOException) {}
        try {
            HashMap testCaseInfo = new HashMap();
            TestStatus[] testStatuses = Optional.ofNullable(this.getResult()).map(ILauncherResult::getStatuses).orElse(new TestStatus[0]);
            List<IExecutedEntity> executedItems = tsExecutedEntity.getExecutedItems();
            if (executedItems != null) {
                int i = 0;
                while (i < executedItems.size()) {
                    IExecutedEntity iExecutedEntity = executedItems.get(i);
                    if (iExecutedEntity instanceof TestCaseBindingExecutedEntity) {
                        TestCaseBindingExecutedEntity testCaseBindingExecuted = (TestCaseBindingExecutedEntity)iExecutedEntity;
                        TestCaseEntity testCase = (TestCaseEntity)testCaseBindingExecuted.getEntity();
                        if (testCase == null) {
                            LoggerSingleton.logWarn((String)"Skipping test case tracking: null test case entity found in execution");
                        } else {
                            HashMap<String, String> singleTestCaseInfo = new HashMap<String, String>();
                            singleTestCaseInfo.put("test_case_id", testCase.getTestCaseGuid());
                            singleTestCaseInfo.put("source", testCase.getOrigin());
                            singleTestCaseInfo.put("status", testStatuses.length > i ? (testStatuses[i].getStatusValue() != null ? testStatuses[i].getStatusValue().name() : null) : null);
                            testCaseInfo.put(testCase.getTestCaseGuid(), singleTestCaseInfo);
                        }
                    }
                    ++i;
                }
            }
            trackingInfo.setTestCaseInfo(testCaseInfo);
        }
        catch (Exception e) {
            LoggerSingleton.logWarn((String)("Exception while collecting test case info for tracking: " + e.getMessage()));
        }
        return trackingInfo;
    }

    private void addAppiumInfoForTracking(TestEntityTrackingInfo trackInfo) {
        String runConfigClazzName = this.runConfig.getClass().getSimpleName();
        boolean isMobileRunConfig = runConfigClazzName.equals("AndroidRunConfiguration") || runConfigClazzName.equals("IosRunConfiguration");
        boolean isMobileCustomRunConfig = MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)this.runConfig.getName(), (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
        if (isMobileCustomRunConfig || isMobileRunConfig) {
            String appiumDir = AppiumDirectoryFinder.findAppiumDirForConsoleLaucher();
            String appiumVersion = AppiumVersionUtil.readVersionFromFile((String)appiumDir);
            trackInfo.setAppiumVersion(appiumVersion);
        }
    }

    private void addIntegrationSettingInfoForTracking(TestEntityTrackingInfo trackInfo) {
        String analyticsProjectId = "";
        String analyticsAccountId = "";
        AnalyticsIntegrationSetting integratedSetting = this.testOpsController.getRequestOptions().getIntegratedSetting();
        if (integratedSetting != null) {
            Project project = integratedSetting.getProject();
            analyticsProjectId = project != null ? project.getId().toString() : "";
            analyticsAccountId = project != null ? project.getAccountId().toString() : "";
        }
        trackInfo.setTestOpsProjectId(analyticsProjectId);
        trackInfo.setTestOpsAccountId(analyticsAccountId);
        trackInfo.setTestCloudProjectId(analyticsProjectId);
        trackInfo.setTestCloudAccountId(analyticsAccountId);
    }

    private ITestOpsController getTestOpsControllerInstance() {
        if (this.testOpsController == null) {
            this.testOpsController = (ITestOpsController)this.getServiceContext().get(ITestOpsController.class);
        }
        return this.testOpsController;
    }

    private IStudioAssistPreferences getStudioAssistPrefsInstance() {
        if (this.studioAssistPrefs == null) {
            this.studioAssistPrefs = (IStudioAssistPreferences)this.getServiceContext().get(IStudioAssistPreferences.class);
        }
        return this.studioAssistPrefs;
    }

    private ISessionManager getSessionManager() {
        if (this.sessionManager == null) {
            this.sessionManager = (ISessionManager)this.getServiceContext().get(ISessionManager.class);
        }
        return this.sessionManager;
    }

    private IDiscoveryService getDiscoveryServiceInstance() {
        if (this.discoveryService == null) {
            this.discoveryService = (IDiscoveryService)this.getServiceContext().get(IDiscoveryService.class);
        }
        return this.discoveryService;
    }

    private INetworkPreferences getNetworkPrefsInstance() {
        if (this.networkPrefs == null) {
            this.networkPrefs = (INetworkPreferences)this.getServiceContext().get(INetworkPreferences.class);
        }
        return this.networkPrefs;
    }

    private IEclipseContext getServiceContext() {
        return EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(ConsoleLauncher.class).getBundleContext());
    }
}

