/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.listener.LogListener;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.LaunchProcessor;
import com.kms.katalon.execution.launcher.process.RecordingProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingScriptLauncher
extends ConsoleLauncher {
    private Logger logger = LoggerFactory.getLogger(RecordingScriptLauncher.class);
    private Runnable processFinishedRunnable;
    private LogListener logListener;

    public RecordingScriptLauncher(LauncherManager manager, IRunConfiguration runConfig, Runnable processFinishedRunnable) {
        super(manager, runConfig);
        this.processFinishedRunnable = processFinishedRunnable;
    }

    public RecordingScriptLauncher(LauncherManager manager, IRunConfiguration runConfig, Runnable processFinishedRunnable, LogListener logListener) {
        super(manager, runConfig);
        this.processFinishedRunnable = processFinishedRunnable;
        this.logListener = logListener;
    }

    @Override
    protected ILaunchProcess launch() throws ExecutionException {
        try {
            Process systemProcess = this.executeProcess();
            if (systemProcess == null) {
                throw new ExecutionException(ExecutionMessageConstants.CONSOLE_CANNOT_START_EXECUTION);
            }
            Thread outThread = this.createOutputReaderThread(systemProcess);
            Thread errThread = this.createErrorReaderThread(systemProcess);
            Thread monitorThread = this.createProcessMonitorThread(systemProcess, outThread, errThread);
            monitorThread.start();
            return this.onCreateLaunchProcess(systemProcess);
        }
        catch (IOException ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    private Thread createOutputReaderThread(Process systemProcess) {
        return new Thread(() -> this.readStream(systemProcess.getInputStream(), false));
    }

    private Thread createErrorReaderThread(Process systemProcess) {
        return new Thread(() -> this.readStream(systemProcess.getErrorStream(), true));
    }

    private void readStream(InputStream inputStream, boolean isErrorStream) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.notifyLogListener(line, isErrorStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void notifyLogListener(String line, boolean isErrorStream) {
        if (this.logListener != null) {
            if (isErrorStream) {
                this.logListener.onErr(line);
            } else {
                this.logListener.onOut(line);
            }
        }
    }

    private Thread createProcessMonitorThread(Process systemProcess, Thread outThread, Thread errThread) {
        return new Thread(() -> {
            this.startReaderThreads(outThread, errThread);
            this.waitForProcess(systemProcess);
            this.joinReaderThreads(outThread, errThread);
            this.processFinishedRunnable.run();
        });
    }

    private void startReaderThreads(Thread outThread, Thread errThread) {
        if (outThread != null) {
            outThread.start();
        }
        if (errThread != null) {
            errThread.start();
        }
    }

    private void waitForProcess(Process systemProcess) {
        try {
            systemProcess.waitFor();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void joinReaderThreads(Thread outThread, Thread errThread) {
        this.joinThread(outThread);
        this.joinThread(errThread);
    }

    private void joinThread(Thread thread) {
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.error(e.getMessage());
            }
        }
    }

    protected ILaunchProcess onCreateLaunchProcess(Process systemProcess) {
        return new RecordingProcess(systemProcess);
    }

    @Override
    protected Process executeProcess() throws IOException, ExecutionException {
        try {
            return new LaunchProcessor(ClassPathResolver.getClassPaths(ProjectController.getInstance().getCurrentProject()), this.runConfig.getAdditionalEnvironmentVariables(), this.runConfig.getVmArgs()).execute(this.getRunConfig().getExecutionSetting().getScriptFile());
        }
        catch (ControllerException e) {
            throw new ExecutionException((Throwable)e);
        }
    }
}

