/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.SubLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.launcher.process.NonStreamHandledProcess;
import java.io.IOException;

public class SubConsoleLauncher
extends ConsoleLauncher
implements SubLauncher {
    private RunConfigurationDescription runConfigurationDescription;

    public SubConsoleLauncher(LauncherManager manager, IRunConfiguration runConfig, RunConfigurationDescription runConfigurationDescription) {
        super(manager, runConfig);
        this.runConfigurationDescription = runConfigurationDescription;
    }

    @Override
    protected ILaunchProcess launch() throws ExecutionException {
        try {
            Process systemProcess = this.executeProcess();
            return new NonStreamHandledProcess(systemProcess, this.isUseGenerateConsoleLog(), this.getReportFolder());
        }
        catch (IOException ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    @Override
    public RunConfigurationDescription getRunConfigurationDescription() {
        return this.runConfigurationDescription;
    }

    @Override
    public String getName() {
        TestSuiteExecutedEntity testSuiteEntity = (TestSuiteExecutedEntity)this.getExecutedEntity();
        String name = testSuiteEntity.getSourceId() + " - " + this.getRunConfig().getName() + " - " + this.getId();
        int previousRerunTimes = testSuiteEntity.getRerunSetting().getPreviousRerunTimes();
        if (previousRerunTimes > 0) {
            name = name + String.format(" - Re-run %d", previousRerunTimes);
        }
        return name;
    }

    @Override
    public ReportableLauncher clone(IRunConfiguration runConfig) {
        return new SubConsoleLauncher(this.getManager(), runConfig, this.getRunConfigurationDescription());
    }
}

