/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.mobile.util.MobileRunConfigurationUtil;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testcase.RecordOption;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.ExecutionInfo;
import com.kms.katalon.execution.collector.ExecutionInfoCollector;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.execution.collector.SelfHealingExecutionReportCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.TestSuiteRunConfigurationBuilder;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.DefaultReportSetting;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.finders.AppiumDirectoryFinder;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.LauncherProviderFactory;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.SubConsoleLauncher;
import com.kms.katalon.execution.launcher.TestSuiteCollectionLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteCollectionTrackingInfo;
import com.kms.katalon.tracking.service.CicdInfoService;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Deprecated
public class TestSuiteCollectionConsoleLauncher
extends TestSuiteCollectionLauncher
implements IConsoleLauncher {
    @Inject
    private ITestOpsController testOpsController;
    private static final int CONSOLE_WIDTH = 80;
    @Inject
    private IFeatureController featureController;

    public TestSuiteCollectionConsoleLauncher(TestSuiteCollectionExecutedEntity executedEntity, LauncherManager parentManager, List<ReportableLauncher> subLaunchers, ReportCollectionEntity reportCollection, String executionUUID) {
        super(executedEntity, parentManager, subLaunchers, executedEntity.getEntity().getExecutionMode(), reportCollection, executionUUID);
        if ("Remote".equals(executedEntity.getEntity().getBrowserType())) {
            this.trackTscRemoteDomain(subLaunchers);
        }
    }

    public static TestSuiteCollectionConsoleLauncher newInstance(TestSuiteCollectionEntity testSuiteCollection, LauncherManager parentManager, Reportable reportable, Rerunable rerunable, Map<String, Object> globalVariables, Map<String, Object> protectedGlobalVariables, String executionUUID, Map<String, String> additionalInfo, boolean enableProfiling) throws ExecutionException, ControllerException {
        TestSuiteCollectionExecutedEntity executedEntity = new TestSuiteCollectionExecutedEntity(testSuiteCollection);
        executedEntity.setReportable(reportable);
        if (rerunable != null) {
            executedEntity.setRerunable(rerunable.mergeWith(executedEntity.getRunnable()));
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String executionSessionId = dateFormat.format(new Date());
            ReportCollectionEntity reportCollection = ReportController.getInstance().newReportCollection(testSuiteCollection.getProject(), testSuiteCollection, executionSessionId, executedEntity.getId());
            TestSuiteCollectionConsoleLauncher testSuiteCollectionConsoleLauncher = new TestSuiteCollectionConsoleLauncher(executedEntity, parentManager, TestSuiteCollectionConsoleLauncher.buildSubLaunchers(testSuiteCollection, executedEntity, parentManager, reportCollection, globalVariables, protectedGlobalVariables, executionUUID, executionSessionId, additionalInfo, true, enableProfiling), reportCollection, executionUUID);
            BundleContext bundleContext = FrameworkUtil.getBundle(TestSuiteCollectionConsoleLauncher.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            ContextInjectionFactory.inject((Object)testSuiteCollectionConsoleLauncher, (IEclipseContext)context);
            ReportController.getInstance().updateReportCollection(reportCollection);
            return testSuiteCollectionConsoleLauncher;
        }
        catch (DALException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public static TestSuiteCollectionLauncher newIDEInstance(TestSuiteCollectionEntity testSuiteCollection, LauncherManager parentManager, DefaultReportSetting reportable, DefaultRerunSetting rerunable, Map<String, Object> globalVariables, Map<String, Object> protectedGlobalVariables, String executionUUID, Map<String, String> additionalInfo, boolean enableProfiling) throws ExecutionException, ControllerException {
        TestSuiteCollectionExecutedEntity executedEntity = new TestSuiteCollectionExecutedEntity(testSuiteCollection);
        executedEntity.setReportable(reportable);
        executedEntity.setRerunable(rerunable);
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String executionSessionId = dateFormat.format(new Date());
            ReportCollectionEntity reportCollection = ReportController.getInstance().newReportCollection(testSuiteCollection.getProject(), testSuiteCollection, executionSessionId, executedEntity.getId());
            List<ReportableLauncher> subLaunchers = TestSuiteCollectionConsoleLauncher.buildSubLaunchers(testSuiteCollection, executedEntity, parentManager, reportCollection, globalVariables, protectedGlobalVariables, executionUUID, executionSessionId, additionalInfo, false, enableProfiling);
            TestSuiteCollectionLauncher testSuiteCollectionLauncher = LauncherProviderFactory.getInstance().getIdeLauncherProvider().getTestSuiteCollectionIDELauncher(executedEntity, parentManager, subLaunchers, executedEntity.getEntity().getExecutionMode(), reportCollection);
            ReportController.getInstance().updateReportCollection(reportCollection);
            return testSuiteCollectionLauncher;
        }
        catch (DALException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Deprecated
    private static boolean printCheckingLicenseMessageForEachTestSuite(StringBuilder builder, TestSuiteRunConfiguration tsRunConfig, String browserType) {
        boolean valid;
        String runConfigId = tsRunConfig.getConfiguration().getRunConfigurationId();
        Object runConfigName = runConfigId;
        if (StringUtils.isNotBlank((String)browserType)) {
            runConfigName = runConfigId + " (overridden with " + browserType + ")";
            runConfigId = browserType;
        }
        if (!(valid = ConsoleLicenseService.getInstance().isValidRunConfig(runConfigId))) {
            builder.append("\n");
            builder.append(tsRunConfig.getTestSuiteEntity().getIdForDisplay() + " - " + (String)runConfigName);
        }
        return valid;
    }

    private static List<ReportableLauncher> buildSubLaunchers(TestSuiteCollectionEntity testSuiteCollection, TestSuiteCollectionExecutedEntity executedEntity, LauncherManager launcherManager, ReportCollectionEntity reportCollection, Map<String, Object> globalVariables, Map<String, Object> protectedGlobalVariables, String executionUUID, String executionSessionId, Map<String, String> additionalInfo, boolean isConsole, boolean enableProfiling) throws ExecutionException, ControllerException {
        ArrayList<ReportableLauncher> tsLaunchers = new ArrayList<ReportableLauncher>();
        ProjectEntity proj = ProjectController.getInstance().getCurrentProject();
        String profileName = testSuiteCollection.getProfileName();
        GlobalVariableController gvController = GlobalVariableController.getInstance();
        ExecutionProfileEntity execProfile = !StringUtils.isBlank((String)profileName) ? gvController.getExecutionProfile(profileName, proj) : gvController.getDefaultExecutionProfile(proj);
        Set<String> recipients = executedEntity.getEmailConfig(proj).getRecipients();
        globalVariables.putAll(EmailVariableBinding.getVariablesForTestSuiteCollectionEmailSettings(testSuiteCollection));
        MailUtil.overrideEmailSettings(executedEntity.getEmailConfig(proj), execProfile, globalVariables);
        StringBuilder builder = new StringBuilder();
        boolean isTerminate = true;
        for (TestSuiteRunConfiguration tsRunConfig : testSuiteCollection.getTestSuiteRunConfigurations()) {
            if (!tsRunConfig.isRunEnabled() || isConsole && !TestSuiteCollectionConsoleLauncher.printCheckingLicenseMessageForEachTestSuite(builder, tsRunConfig, testSuiteCollection.getBrowserType())) continue;
            isTerminate = false;
            globalVariables.putAll(EmailVariableBinding.getVariablesForTestSuiteEmailSettings(tsRunConfig.getTestSuiteEntity()));
            ReportableLauncher subLauncher = TestSuiteCollectionConsoleLauncher.buildLauncher(tsRunConfig, launcherManager, reportCollection, globalVariables, protectedGlobalVariables, executionUUID, isConsole, executionSessionId, additionalInfo, testSuiteCollection.getBrowserType(), testSuiteCollection.getProfileName(), (DefaultRerunSetting)executedEntity.getRunnable(), enableProfiling);
            TestSuiteExecutedEntity tsExecutedEntity = (TestSuiteExecutedEntity)subLauncher.getRunConfig().getExecutionSetting().getExecutedEntity();
            tsExecutedEntity.setInCollection(true);
            tsExecutedEntity.setTestSuiteCollectionId(ExecutionUtil.getTestSuiteCollectionId(testSuiteCollection.getId()));
            tsExecutedEntity.setReportLocation(executedEntity.getReportLocationForChildren(subLauncher.getId()));
            EmailConfig tsEmailConfig = tsExecutedEntity.getEmailConfig(proj);
            tsEmailConfig.addRecipients(recipients);
            MailUtil.overrideEmailSettings(tsEmailConfig, (ExecutionProfileEntity)subLauncher.getRunConfig().getExecutionProfile(), globalVariables);
            if (tsExecutedEntity.getTotalTestCases() == 0) {
                throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.LAU_MESSAGE_EMPTY_TEST_SUITE, tsExecutedEntity.getEntity().getName()));
            }
            executedEntity.addTestSuiteExecutedEntity(tsExecutedEntity);
            tsLaunchers.add(subLauncher);
        }
        TestSuiteCollectionConsoleLauncher.printCheckingLicenseInformation(executedEntity.getEntity().getName(), builder);
        if (isTerminate) {
            throw new ExecutionException(ConsoleLicenseService.getInstance().getReasonTerminateTestSuiteCollection());
        }
        TestSuiteCollectionConsoleLauncher.notifyRetrySetting(executedEntity);
        return tsLaunchers;
    }

    @Deprecated
    private static void printCheckingLicenseInformation(String testSuiteCollectionName, StringBuilder testSuitesBuilder) {
        if (StringUtils.isEmpty((String)testSuitesBuilder.toString())) {
            return;
        }
        String executionInfo = "CHECKING LICENSE INFORMATION";
        String dashForLabel = StringUtils.repeat((String)"-", (int)((80 - executionInfo.length()) / 2));
        StringBuilder builder = new StringBuilder().append("\n").append(dashForLabel).append(executionInfo).append(dashForLabel).append("\n");
        builder.append(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TEST_SUITE_COLLECTION, testSuiteCollectionName));
        builder.append("\n");
        builder.append(ConsoleLicenseService.getInstance().getMsgAfterCheckingTSCLicense());
        builder.append((CharSequence)testSuitesBuilder);
        builder.append("\n").append(StringUtils.repeat((String)"-", (int)80)).append("\n");
        LogUtil.logInfo((String)builder.toString());
    }

    @Deprecated
    private static void notifyRetrySetting(TestSuiteCollectionExecutedEntity executedEntity) {
        String retryLabel = ExecutionMessageConstants.MSG_INFO_RETRY_EXECUTION_INFO_LABEL;
        String dashForLabel = StringUtils.repeat((String)"-", (int)((80 - retryLabel.length()) / 2));
        StringBuilder builder = new StringBuilder().append("\n").append(dashForLabel).append(retryLabel).append(dashForLabel).append("\n");
        builder.append(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TEST_SUITE_COLLECTION, executedEntity.getEntity().getName()));
        for (IExecutedEntity entity : executedEntity.getExecutedItems()) {
            if (!(entity instanceof TestSuiteExecutedEntity)) continue;
            TestSuiteExecutedEntity testSuiteExecutedEntity = (TestSuiteExecutedEntity)entity;
            builder.append("\n").append(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TS_RETRY, testSuiteExecutedEntity.getEntity().getName(), testSuiteExecutedEntity.getRetryStrategy().toString(), testSuiteExecutedEntity.getRemainingRerunTimes()));
        }
        builder.append("\n").append(StringUtils.repeat((String)"-", (int)80)).append("\n");
        LogUtil.logInfo((String)builder.toString());
    }

    private static ReportableLauncher buildLauncher(TestSuiteRunConfiguration tsRunConfig, LauncherManager launcherManager, ReportCollectionEntity reportCollection, Map<String, Object> globalVariables, Map<String, Object> protectedGlobalVariables, String executionUUID, boolean isConsole, String executionSessionId, Map<String, String> additionalInfo, String browserTypeOption, String profileNameOption, DefaultRerunSetting rerunSetting, boolean shouldEnableProfiling) throws ExecutionException {
        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        try {
            RunConfigurationDescription configDescription = tsRunConfig.getConfiguration();
            String browserType = StringUtils.isNotBlank((String)browserTypeOption) ? browserTypeOption : configDescription.getRunConfigurationId();
            String profileName = StringUtils.isBlank((String)profileNameOption) ? configDescription.getProfileName() : profileNameOption;
            ExecutionProfileEntity executionProfile = GlobalVariableController.getInstance().getExecutionProfile(profileName, ProjectController.getInstance().getCurrentProject());
            if (executionProfile == null) {
                throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.CONSOLE_MSG_PROFILE_NOT_FOUND, profileName));
            }
            IRunConfigurationContributor runConfigContributor = RunConfigurationCollector.getInstance().getRunContributor(browserType);
            TestSuiteRunConfigurationBuilder runConfigBuilder = new TestSuiteRunConfigurationBuilder().withRunConfigDescription(configDescription).withBrowserType(browserType).withProjectDir(projectDir).withContributor(runConfigContributor).withExecutionProfile(executionProfile).withTestSuiteEntity(tsRunConfig.getTestSuiteEntity()).withRerunSettings(new DefaultRerunSetting(rerunSetting)).withFailedThreshold(launcherManager.getFailedThreshold()).withGlobalVariables(globalVariables).withProtectedGlobalVariables(protectedGlobalVariables).withExecutionUUID(executionUUID).withExecutionSessionId(executionSessionId).withAdditionalInfo(additionalInfo).withEnableProfiling(shouldEnableProfiling);
            AbstractRunConfiguration runConfig = (AbstractRunConfiguration)runConfigBuilder.build();
            ReportableLauncher launcher = null;
            launcher = isConsole ? new SubConsoleLauncher(launcherManager, (IRunConfiguration)runConfig, configDescription) : LauncherProviderFactory.getInstance().getIdeLauncherProvider().getSubIDELauncher(launcherManager, runConfig, configDescription);
            launcher.configureToLazilyRebuildRunConfigDriverConnector(runConfigContributor, projectDir, configDescription);
            reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)launcher.getReportEntity().getIdForDisplay(), (RunConfigurationDescription)configDescription));
            return launcher;
        }
        catch (Exception e) {
            LogUtil.logError((String)e.getMessage());
            throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.LAU_MESSAGE_UNABLE_TO_EXECUTE_TEST_SUITE, tsRunConfig.getTestSuiteEntity().getIdForDisplay()));
        }
    }

    @Override
    public String getStatusMessage(int consoleWidth) {
        return this.getDefaultStatusMessage(consoleWidth) + "\n" + StringUtils.repeat((String)"-", (int)consoleWidth) + "\n" + this.subLauncherManager.getChildrenLauncherStatus(consoleWidth);
    }

    @Override
    protected void postExecution() {
        super.postExecution();
        File reportFolder = this.getReportFolder();
        boolean canUseSelfHealing = this.featureController.canUse(ProductFeature.SELF_HEALING);
        BundleSettingStore store = new BundleSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation(), "com.kms.katalon.execution.webui.setting", false);
        try {
            boolean isSelfHealingEnabled = canUseSelfHealing && store.getBoolean("execution.default.webUi.selfHealingEnabled", canUseSelfHealing);
            SelfHealingExecutionReport selfHealingReport = SelfHealingExecutionReportCollector.getInstance().collect(isSelfHealingEnabled, reportFolder);
            ExecutionInfo executionInfo = ExecutionInfoCollector.getInstance().collect();
            TestSuiteCollectionEntity tscEntity = this.getExecutedEntity().getEntity();
            TestSuiteCollectionEntity.ExecutionMode executionMode = tscEntity.getExecutionMode();
            String tscId = ExecutionUtil.getTestSuiteCollectionId(tscEntity.getId());
            if (executionMode == TestSuiteCollectionEntity.ExecutionMode.PARALLEL) {
                int maxConcurrentInstances = tscEntity.getMaxConcurrentInstances();
                Trackings.trackExecuteParallelTestSuiteCollectionInConsoleMode((TestSuiteCollectionTrackingInfo)this.buildTSCTrackingInfo(selfHealingReport, executionInfo, maxConcurrentInstances, tscId, this.countNumTestCaseRecordedByTestCloud(tscEntity), this.countNumAIAPITestCase(tscEntity)));
            } else {
                Trackings.trackExecuteSequentialTestSuiteCollectionInConsoleMode((TestSuiteCollectionTrackingInfo)this.buildTSCTrackingInfo(selfHealingReport, executionInfo, 0, tscId, this.countNumTestCaseRecordedByTestCloud(tscEntity), this.countNumAIAPITestCase(tscEntity)));
            }
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private int countNumTestCaseRecordedByTestCloud(TestSuiteCollectionEntity tscEntity) {
        int result = 0;
        for (TestSuiteRunConfiguration tsRunConfig : tscEntity.getTestSuiteRunConfigurations()) {
            TestSuiteEntity tsEntity = tsRunConfig.getTestSuiteEntity();
            for (TestSuiteTestCaseLink link : tsEntity.getTestSuiteTestCaseLinks()) {
                try {
                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
                    if (!RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)testCase.getRecordOption())) continue;
                    ++result;
                }
                catch (ControllerException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
        return result;
    }

    private int countNumAIAPITestCase(TestSuiteCollectionEntity tscEntity) {
        int result = 0;
        for (TestSuiteRunConfiguration tsRunConfig : tscEntity.getTestSuiteRunConfigurations()) {
            TestSuiteEntity tsEntity = tsRunConfig.getTestSuiteEntity();
            for (TestSuiteTestCaseLink link : tsEntity.getTestSuiteTestCaseLinks()) {
                try {
                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(link.getTestCaseId());
                    if (!testCase.isAPITestGenerationTestCase()) continue;
                    ++result;
                }
                catch (ControllerException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
        }
        return result;
    }

    protected String getExecutionResult() {
        String resultExcution = null;
        resultExcution = this.getResult().getNumFailures() > 0 ? TestStatus.TestStatusValue.FAILED.toString() : (this.getResult().getNumErrors() > 0 ? TestStatus.TestStatusValue.ERROR.toString() : TestStatus.TestStatusValue.PASSED.toString());
        return resultExcution;
    }

    private TestSuiteCollectionTrackingInfo buildTSCTrackingInfo(SelfHealingExecutionReport selfHealingReport, ExecutionInfo executionInfo, int maxConcurrentInstances, String tscId, int testCloudRecorderTestCaseCount, int numberOfAIAPITestCase) {
        Date startTime = this.getStartTime() != null ? this.getStartTime() : new Date();
        Date endTime = this.getEndTime() != null ? this.getEndTime() : new Date();
        String executionResult = this.getExecutionResult();
        boolean usedMaxFailedTest = FailedTestThreshold.getInstance().isThresholdAvailable();
        TestSuiteCollectionExecutedEntity tscExecutedEntity = this.getExecutedEntity();
        int numberOfEmailsSent = MailUtil.getNumberOfEmailsSentForTestSuiteCollection(this.getAreEmailsSent(), tscExecutedEntity.getEmailConfig(tscExecutedEntity.getEntity().getProject()));
        TestSuiteCollectionTrackingInfo trackingInfo = new TestSuiteCollectionTrackingInfo();
        trackingInfo.setAnonymous(false);
        trackingInfo.setResult(executionResult);
        trackingInfo.setDuration(endTime.getTime() - startTime.getTime());
        trackingInfo.setEnableSelfHealing(selfHealingReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingReport.getHealingInfo());
        trackingInfo.setTotalTestCases(this.getResult().getTotalTestCases());
        trackingInfo.setTotalRunTestSuite(tscExecutedEntity.getExecutedItems().size());
        trackingInfo.setPassedTestCases(this.getResult().getNumPasses());
        trackingInfo.setFailedTestCases(this.getResult().getNumFailures());
        trackingInfo.setErrorTestCases(this.getResult().getNumErrors());
        trackingInfo.setSkippedTestCases(this.getResult().getNumSkips());
        trackingInfo.setIncompleteTestCases(this.getResult().getNumIncomplete());
        ApplicationContext context = ApplicationContext.getInstance();
        Organization organization = context.getOrganization();
        if (Objects.nonNull(organization)) {
            trackingInfo.setOrgId(organization.getId());
        }
        trackingInfo.setEnableScreenshot(executionInfo.isEnableScreenshot());
        trackingInfo.setEnableVideo(executionInfo.isEnableVideoRecording());
        trackingInfo.setEnableHideHostname(ExecutionUtil.isEnabledHideHostname().booleanValue());
        trackingInfo.setVideoRecordingLevel(executionInfo.getVideoRecordingLevel());
        trackingInfo.setNumberOfEmailsSent(numberOfEmailsSent);
        trackingInfo.setMaxConcurrentInstances(maxConcurrentInstances);
        trackingInfo.setAdditionalProps(this.getIntegratedContributionsTrackingData());
        trackingInfo.setUsedMaxFailedTestParam(usedMaxFailedTest);
        trackingInfo.setTestSuiteCollectionId(tscId);
        trackingInfo.setTestcloudRecorderTestCaseCount(testCloudRecorderTestCaseCount);
        trackingInfo.setNumberOfAIAPITestCase(numberOfAIAPITestCase);
        trackingInfo.setCicdIntegration(CicdInfoService.getCicdName());
        trackingInfo.setReportGenerationTypes(this.getReportGenerationTypes());
        this.addAppiumInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        this.addIntegrationSettingInfoForTracking((TestEntityTrackingInfo)trackingInfo);
        if (StringUtils.isNotBlank((String)this.getTscRemoteDomain())) {
            trackingInfo.setRemoteDomain(this.getTscRemoteDomain());
        }
        return trackingInfo;
    }

    private void addAppiumInfoForTracking(TestEntityTrackingInfo trackInfo) {
        Predicate<TestSuiteRunConfiguration> containMobileOrCustomMobileRunConfig = testSuiteRunConfig -> {
            String groupName = testSuiteRunConfig.getConfiguration().getGroupName();
            if (groupName.equals("Mobile") || groupName.equals("Custom")) {
                String runConfigId = testSuiteRunConfig.getConfiguration().getRunConfigurationId();
                boolean isMobileRunConfigId = MobileRunConfigurationUtil.isAndroidPlatform((String)runConfigId) || MobileRunConfigurationUtil.isiOSPlatform((String)runConfigId);
                boolean isCustomMobileRunConfigId = MobileRunConfigurationUtil.usingCustomRunConfigurationId((String)runConfigId, (String)ProjectController.getInstance().getCurrentProject().getFolderLocation());
                return (isCustomMobileRunConfigId || isMobileRunConfigId) && testSuiteRunConfig.isRunEnabled();
            }
            return false;
        };
        boolean isContainMobileRunConfig = this.getExecutedEntity().getEntity().getTestSuiteRunConfigurations().stream().anyMatch(containMobileOrCustomMobileRunConfig);
        if (isContainMobileRunConfig) {
            String appiumVersion = AppiumVersionUtil.readVersionFromFile((String)AppiumDirectoryFinder.findAppiumDirForConsoleLaucher());
            trackInfo.setAppiumVersion(appiumVersion);
        }
    }

    private void addIntegrationSettingInfoForTracking(TestEntityTrackingInfo trackInfo) {
        String analyticsProjectId = "";
        String analyticsAccountId = "";
        AnalyticsIntegrationSetting integratedSetting = this.testOpsController.getRequestOptions().getIntegratedSetting();
        if (integratedSetting != null) {
            Project project = integratedSetting.getProject();
            analyticsProjectId = project != null ? project.getId().toString() : "";
            analyticsAccountId = project != null ? project.getAccountId().toString() : "";
        }
        trackInfo.setTestOpsProjectId(analyticsProjectId);
        trackInfo.setTestOpsAccountId(analyticsAccountId);
        trackInfo.setTestCloudProjectId(analyticsProjectId);
        trackInfo.setTestCloudAccountId(analyticsAccountId);
    }
}

