/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.process;

import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class ProcessStdoutFileExporter
extends Thread
implements AutoCloseable {
    private static final int DEFAULT_MAX_LOG_FILES = 2000;
    private static final int DEFAULT_BATCH_SIZE = 3000;
    private static final int DEFAULT_QUEUE_SIZE = 7000;
    private static final int DEFAULT_MAX_LOG_FILE_SIZE = 0xA00000;
    private static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    private File reportFolder;
    private boolean keepRunning = true;
    private boolean isDisposed = false;
    private Logger logger;
    private FileHandler fileHandler;
    private BlockingQueue<String> outputQueue;
    private List<String> batchLogs;
    private int batchLogRecordSize;

    public ProcessStdoutFileExporter(File reportFolder) throws SecurityException, IOException {
        this.reportFolder = reportFolder;
        int logRecordQueueSize = this.getConfigSystemProperty("logRecordQueueSize", 7000);
        this.outputQueue = new ArrayBlockingQueue<String>(logRecordQueueSize);
        this.batchLogRecordSize = this.getConfigSystemProperty("batchLogRecordSize", 3000);
        this.batchLogs = new ArrayList<String>(this.batchLogRecordSize);
        this.setupLogger();
    }

    private void setupLogger() throws SecurityException, IOException {
        String loggerName = "ConsoleLogger-" + System.currentTimeMillis();
        this.logger = Logger.getLogger(loggerName);
        this.logger.setLevel(Level.ALL);
        this.logger.setUseParentHandlers(false);
        int maxLogFileSize = this.getConfigSystemProperty("maxLogFileSize", 0xA00000);
        int maxLogFile = this.getConfigSystemProperty("maxLogFile", 2000);
        this.fileHandler = new FileHandler(Path.of(this.reportFolder.getAbsolutePath(), "console%g.log").toString(), maxLogFileSize, maxLogFile, true);
        this.fileHandler.setEncoding(DEFAULT_CHARSET);
        this.fileHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage();
            }
        });
        this.logger.addHandler(this.fileHandler);
    }

    public void recordStdoutLog(String line) {
        boolean added;
        if (StringUtils.isNotBlank((String)line) && !(added = this.outputQueue.offer(line))) {
            LogUtil.logInfo((String)"The buffer of log file is full. The stdout line is dropped and won't be in the log file");
        }
    }

    public void recordStderrLog(String line) {
        boolean added;
        if (StringUtils.isNotBlank((String)line) && !(added = this.outputQueue.offer(line))) {
            LogUtil.logInfo((String)"The buffer of log file is full. The stderr line is dropped and won't be in the log file");
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                this.forwardQueueToLogger();
                ProcessStdoutFileExporter.sleep(500L);
            }
            catch (Exception e) {
                LogUtil.logError((String)("Failed to write log to file while running stdout process, error: " + e.getMessage()));
            }
        }
        this.flush();
    }

    private void forwardQueueToLogger() {
        this.batchLogs.clear();
        while (!this.outputQueue.isEmpty()) {
            int drainedCount = this.outputQueue.drainTo(this.batchLogs, this.batchLogRecordSize);
            if (drainedCount <= 0) continue;
            try {
                this.processBatchLogs(this.batchLogs);
            }
            catch (Exception e) {
                LogUtil.logError((String)("Failed write batch logs to file, error: " + e.getMessage()));
            }
        }
    }

    private void flush() {
        try {
            this.forwardQueueToLogger();
        }
        catch (Exception e) {
            LogUtil.logError((String)("Failed to write log to file while flushing, error: " + e.getMessage()));
        }
        try {
            if (this.fileHandler != null) {
                this.fileHandler.flush();
                this.fileHandler.close();
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)("Failed to flush file in, error: " + e.getMessage()));
        }
    }

    private void processBatchLogs(List<String> batchLogs) {
        if (batchLogs.isEmpty()) {
            return;
        }
        try {
            for (String log : batchLogs) {
                this.logger.info(log);
            }
        }
        catch (Exception e) {
            LogUtil.logError((String)("Failed to write log to file, error: " + e.getMessage()));
        }
    }

    @Override
    public void close() throws Exception {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.keepRunning = false;
        try {
            this.join(1000L);
        }
        catch (InterruptedException e) {
            LogUtil.logError((String)("Failed to close thread, error: " + e.getMessage()));
        }
    }

    private int getConfigSystemProperty(String propertyName, int defaultValue) {
        if (Objects.nonNull(System.getProperty(propertyName))) {
            LogUtil.logInfo((String)("Override default " + propertyName));
            return Integer.parseInt(System.getProperty(propertyName));
        }
        return defaultValue;
    }
}

