/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.session;

import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionServiceRunnable;
import com.kms.katalon.execution.session.RemoteMobileExecutionSession;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionSessionSocketServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionSessionSocketServer.class);
    private static final String LOCAL_HOST_MAC = "localhost";
    private static ExecutionSessionSocketServer instance;
    private ServerSocket serverSocket = new ServerSocket(0);
    private List<ExecutionSession> executionSessions;
    private int localPort = this.serverSocket.getLocalPort();
    private String hostAddress = this.serverSocket.getInetAddress().getHostAddress();
    private boolean canRun = false;
    private Thread executionSessionWatcher;

    public static ExecutionSessionSocketServer getInstance() {
        if (instance == null) {
            try {
                instance = new ExecutionSessionSocketServer();
            }
            catch (IOException e) {
                logger.error("Failed to start Execution Session Socket Server", (Throwable)e);
            }
        }
        return instance;
    }

    private ExecutionSessionSocketServer() throws IOException {
        if (this.hostAddress.equals("0.0.0.0")) {
            this.hostAddress = "127.0.0.1";
        }
        if (Platform.getOS().equals("macosx")) {
            this.hostAddress = LOCAL_HOST_MAC;
        }
        this.executionSessions = new ArrayList<ExecutionSession>();
        this.newExecutionSessionWatcher();
    }

    public int getServerPort() {
        return this.localPort;
    }

    public String getServerHost() {
        return this.hostAddress;
    }

    public Thread getExecutionSessionWatcher() {
        return this.executionSessionWatcher;
    }

    public void setCanRun(boolean canRun) {
        this.canRun = canRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecutionSession(ExecutionSession executionSession) {
        List<ExecutionSession> list = this.executionSessions;
        synchronized (list) {
            this.executionSessions.add(executionSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecutionSession(ExecutionSession executionSession) {
        List<ExecutionSession> list = this.executionSessions;
        synchronized (list) {
            this.executionSessions.remove(executionSession);
        }
    }

    public List<ExecutionSession> getAllAvailableExecutionSessionByDriverTypeName(String driverTypeName) {
        ArrayList<ExecutionSession> executionSessions = new ArrayList<ExecutionSession>();
        for (ExecutionSession executionSession : this.getAllExecutionSessions()) {
            if (!driverTypeName.equals(executionSession.getDriverTypeName()) || !executionSession.isAvailable() || executionSession instanceof RemoteMobileExecutionSession) continue;
            executionSessions.add(executionSession);
        }
        return executionSessions;
    }

    public ExecutionSession getExecutionSessionBySessionAndRemoteURL(String sessionId, String remoteServerUrl) {
        for (ExecutionSession executionSession : this.getAllExecutionSessions()) {
            if (!executionSession.getSessionId().equals(sessionId) || !executionSession.getRemoteUrl().equals(remoteServerUrl)) continue;
            return executionSession;
        }
        return null;
    }

    public ExecutionSession getExecutionSessionByLogFolderPath(String logFolderPath) {
        for (ExecutionSession executionSession : this.getAllExecutionSessions()) {
            if (!logFolderPath.equals(executionSession.getLogFolderPath())) continue;
            return executionSession;
        }
        return null;
    }

    public List<ExecutionSession> getAllAvailableExecutionSessions() {
        ArrayList<ExecutionSession> executionSessions = new ArrayList<ExecutionSession>();
        for (ExecutionSession executionSession : this.getAllExecutionSessions()) {
            if (!executionSession.isAvailable()) continue;
            executionSessions.add(executionSession);
        }
        return executionSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutionSession> getAllExecutionSessions() {
        List<ExecutionSession> list = this.executionSessions;
        synchronized (list) {
            return new ArrayList<ExecutionSession>(this.executionSessions);
        }
    }

    public void newExecutionSessionWatcher() {
        this.executionSessionWatcher = new Thread(new ExecutionSessionWatcher());
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket clientSocket = this.serverSocket.accept();
                    ExecutionSessionServiceRunnable clientThread = new ExecutionSessionServiceRunnable(clientSocket, this);
                    new Thread(clientThread).start();
                }
            }
            catch (IOException e) {
                logger.error("Failed to accept new execution session connection", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected class ExecutionSessionWatcher
    implements Runnable {
        private static final int DEFAULT_LOOP_INTERVAL = 1000;

        protected ExecutionSessionWatcher() {
        }

        @Override
        public void run() {
            while (ExecutionSessionSocketServer.this.canRun) {
                try {
                    Thread.sleep(1000L);
                    Iterator<ExecutionSession> sessionIterator = ExecutionSessionSocketServer.this.executionSessions.iterator();
                    while (sessionIterator.hasNext()) {
                        ExecutionSession executionSession = sessionIterator.next();
                        if (executionSession.isAlive()) {
                            executionSession = this.checkStatusAndUpdateTitle(executionSession);
                            continue;
                        }
                        sessionIterator.remove();
                    }
                    if (!ExecutionSessionSocketServer.this.executionSessions.isEmpty()) continue;
                    ExecutionSessionSocketServer.this.canRun = false;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private ExecutionSession checkStatusAndUpdateTitle(ExecutionSession executionSession) {
            try {
                executionSession.checkStatusAndUpdateTitle();
            }
            catch (Exception exception) {
                executionSession.isAlive = false;
            }
            return executionSession;
        }
    }
}

