/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.model.TakeScreenshotOption;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.setting.TakeScreenshotSettings;
import com.kms.katalon.core.setting.VideoRecorderOption;
import com.kms.katalon.core.setting.VideoRecorderSettings;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.FrameworkUtil;

public class ExecutionSettingStore
extends BundleSettingStore {
    public ExecutionSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(ExecutionSettingStore.class).getSymbolicName(), false);
    }

    public static ExecutionSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new ExecutionSettingStore(projectEntity);
    }

    public boolean getScreenCaptureOption() throws IOException {
        return this.getBoolean("report.takeScreenshotOption", true);
    }

    public void setScreenCaptureOption(boolean screenCaptureEnabled) throws IOException {
        this.setProperty("report.takeScreenshotOption", screenCaptureEnabled);
    }

    public void setTakeScreenSettings(TakeScreenshotSettings takeScreenshotSetting) throws IOException {
        this.setProperty("report.takeScreenshotSettings", JsonUtil.toJson((Object)takeScreenshotSetting, (boolean)false));
    }

    public TakeScreenshotSettings getTakeScreenSettings() throws IOException {
        String recorderSettingString = this.getString("report.takeScreenshotSettings", JsonUtil.toJson((Object)new TakeScreenshotSettings(), (boolean)false));
        TakeScreenshotSettings takeScreenshot = (TakeScreenshotSettings)JsonUtil.fromJson((String)recorderSettingString, TakeScreenshotSettings.class);
        if (recorderSettingString.isBlank()) {
            takeScreenshot = this.convertOldConfigurationToNewConfiguration(takeScreenshot);
        }
        return takeScreenshot;
    }

    public boolean hasVideoRecorderOption() throws IOException {
        String recorderOptionString = this.getString("report.videoRecorderOption", null);
        return recorderOptionString != null;
    }

    public VideoRecorderOption getVideoRecorderOption() throws IOException {
        String recorderSettingString = this.getString("report.videoRecorderOption", JsonUtil.toJson((Object)new VideoRecorderOption(), (boolean)false));
        return (VideoRecorderOption)JsonUtil.fromJson((String)recorderSettingString, VideoRecorderOption.class);
    }

    public void setVideoRecorderOption(VideoRecorderOption videoRecorderOption) throws IOException {
        this.setProperty("report.videoRecorderOption", JsonUtil.toJson((Object)videoRecorderOption, (boolean)false));
    }

    public boolean hasVideoRecorderSetting() throws IOException {
        String recorderSettingString = this.getString("report.videoRecorderSettings", null);
        return recorderSettingString != null;
    }

    public VideoRecorderSettings getVideoRecorderSettings() throws IOException {
        String videoRecorderSettingString = this.getString("report.videoRecorderSettings", null);
        if (StringUtils.isBlank((String)videoRecorderSettingString)) {
            VideoRecorderSettings videoRecorderSettings = new VideoRecorderSettings();
            VideoRecorderOption videoRecordOption = this.getVideoRecorderOption();
            videoRecorderSettings.setEnable(videoRecordOption.isEnable());
            boolean hasVideoRecorderOption = this.hasVideoRecorderOption();
            if (!hasVideoRecorderOption && !videoRecorderSettings.isEnable()) {
                videoRecordOption.setUseBrowserRecorder(true);
                this.setVideoRecorderOption(videoRecordOption);
            }
            videoRecorderSettings.setUseBrowserRecorder(videoRecordOption.isUseBrowserRecorder());
            videoRecorderSettings.setRecordAllTestCases(videoRecorderSettings.isUseBrowserRecorder() ? videoRecordOption.isRecordAllTestCases() : videoRecordOption.isAllowedRecordIfPassed());
            videoRecorderSettings.setVideoFormat(videoRecordOption.getVideoFormat());
            if (!videoRecorderSettings.isEnable() && videoRecorderSettings.isUseBrowserRecorder() && videoRecorderSettings.getVideoFormat() == VideoFileFormat.AVI) {
                videoRecorderSettings.setVideoFormat(VideoFileFormat.WEBM);
            }
            videoRecorderSettings.setVideoQuality(videoRecordOption.getVideoQuality());
            return videoRecorderSettings;
        }
        return (VideoRecorderSettings)JsonUtil.fromJson((String)videoRecorderSettingString, VideoRecorderSettings.class);
    }

    public void setVideoRecorderSettings(VideoRecorderSettings videoRecorderSettings) throws IOException {
        this.setProperty("report.videoRecorderSettings", JsonUtil.toJson((Object)videoRecorderSettings, (boolean)false));
    }

    public String getTraceMode() throws IOException {
        return this.getString("execution.traceMode", "off");
    }

    public void setTraceMode(String traceMode) throws IOException {
        this.setProperty("execution.traceMode", traceMode);
    }

    public boolean isExecutionViewerEnabled() throws IOException {
        return this.getBoolean("execution.executionViewerEnabled", true);
    }

    public void setExecutionViewerEnabled(boolean enabled) throws IOException {
        this.setProperty("execution.executionViewerEnabled", enabled);
    }

    private TakeScreenshotSettings convertOldConfigurationToNewConfiguration(TakeScreenshotSettings takeScreenshotSetting) throws IOException {
        if (takeScreenshotSetting.getTakeScreenshotOption() == null) {
            if (this.getScreenCaptureOption()) {
                takeScreenshotSetting.setEnable(true);
                takeScreenshotSetting.setTakeScreenshotOption(TakeScreenshotOption.FAILED_STEPS);
            }
            this.setTakeScreenSettings(takeScreenshotSetting);
        }
        return takeScreenshotSetting;
    }
}

