/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.model.MobileDisplayObjectTreeOption;
import com.kms.katalon.core.model.internal.MobilePlatformExecutionSettings;
import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class MobileSettingStore
extends BundleSettingStore {
    private static final String MOBILE_SETTINGS_FILE_NAME = "com.kms.katalon.execution.mobile";
    public static final String CONF_PROPERTY_DEFAULT_OPTION_DISPLAYING_TREE = "defaultGetPageSourceMethod";
    private static final String CONF_PROPERTY_DEFAULT_OPTION_LOCATOR = "defaultLocatorStrategy";
    private static final String CONF_PROPERTY_SELF_HEALING_ENABLED = "selfHealingEnabled";
    private static final String CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_ANDROID = "prioritizedLocatorStrategiesForAndroid";
    private static final String CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_IOS = "prioritizedLocatorStrategiesForIos";
    private static final String CONF_PROPERTY_EXCLUDED_KEYWORDS = "excludedKeywords";
    private static final String CONF_PROPERTY_ELEMENT_TIMEOUT = "elementTimeout";
    private static final String CONF_PROPERTY_NEW_COMMAND_TIMEOUT_SECONDS = "newCommandTimeoutSeconds";
    private static final String CONF_PROPERTY_ACTION_DELAY_IN_MILLIS = "actionDelayInMillis";
    private static final String CONF_PROPERTY_ACTION_DELAY_AFFECTED_KEYWORDS = "actionDelayAffectedKeywords";
    public static final String[] DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS = new String[]{"tap", "tapAndHold", "tapAndHoldAtPosition", "tapAtPosition", "tapOnImage", "doubleTap", "longPress", "pressBack", "pressHome", "pressKeyCode", "sendKeys", "setEncryptedText", "setText", "clearText", "hideKeyboard", "swipe", "dragAndDrop", "scrollToText", "enhancedScrollToText", "pinchToZoomInAtPosition", "pinchToZoomOutAtPosition", "checkElement", "uncheckElement", "selectListItemByIndex", "selectListItemByLabel", "setSliderValue", "closeNotifications", "openNotifications"};
    public static final boolean DEFAULT_IS_ENABLE_SELF_HEALING = false;
    public static final int EXECUTION_DEFAULT_NEW_COMMAND_TIMEOUT_SECONDS = 1800;
    public static final int EXECUTION_DEFAULT_ELEMENT_TIMEOUT = 60;
    public static final int EXECUTION_DEFAULT_ACTION_DELAY_IN_MILLIS = 0;
    public static final MobileDisplayObjectTreeOption DEFAULT_DISPLAY_TREE_OPTION_IF_NOT_SET = MobileDisplayObjectTreeOption.Minimal;
    public static final LocatorStrategy DEFAULT_LOCATOR = LocatorStrategy.ATTRIBUTES;
    public static final List<String> EXCLUDED_SELF_HEALING_KEYWORDS = List.of("verifyElementExist", "verifyElementNotExist", "verifyElementVisible", "verifyElementNotVisible", "verifyElementAttributeValue", "verifyElementHasAttribute", "verifyElementNotHasAttribute", "verifyElementChecked", "verifyElementNotChecked", "verifyElementText", "waitForElementPresent", "waitForElementNotPresent", "waitForElementAttributeValue", "waitForElementHasAttribute", "waitForElementNotHasAttribute", "scrollToText");
    public static final String PROP_AI_SELFHEALING_ENABLED = "aiSelfHealing.enabled";
    public static final String PROP_AI_SELFHEALING_INPUT_SOURCES = "aiSelfHealing.inputSources";
    public static final boolean DEFAULT_AI_SELFHEALING_ENABLED = true;
    public static final List<SelfHealingInputSource> DEFAULT_AI_SELFHEALING_INPUTS = Arrays.asList(SelfHealingInputSource.PAGE_SOURCE, SelfHealingInputSource.ELEMENT_SCREENSHOT, SelfHealingInputSource.FULL_PAGE_SCREENSHOT);

    public int getElementTimeout() throws IOException {
        return this.getInt(CONF_PROPERTY_ELEMENT_TIMEOUT, 60);
    }

    public void setElementTimeout(int elementTimeout) throws IOException {
        this.setProperty(CONF_PROPERTY_ELEMENT_TIMEOUT, elementTimeout);
    }

    public int safelyGetElementTimeout() {
        try {
            return this.getElementTimeout();
        }
        catch (Exception exception) {
            return 60;
        }
    }

    public int getNewCommandTimeoutSeconds() throws IOException {
        return this.getInt(CONF_PROPERTY_NEW_COMMAND_TIMEOUT_SECONDS, 1800);
    }

    public void setNewCommandTimeoutSeconds(int value) throws IOException {
        this.setProperty(CONF_PROPERTY_NEW_COMMAND_TIMEOUT_SECONDS, value);
    }

    public int getActionDelayInMillis() throws IOException {
        return this.getInt(CONF_PROPERTY_ACTION_DELAY_IN_MILLIS, 0);
    }

    public void setActionDelayInMillis(int value) throws IOException {
        this.setProperty(CONF_PROPERTY_ACTION_DELAY_IN_MILLIS, value);
    }

    public void setActionDelayAffectedKeywords(List<String> keywords) throws IOException {
        String stringKeywords = keywords.stream().collect(Collectors.joining(","));
        this.setProperty(CONF_PROPERTY_ACTION_DELAY_AFFECTED_KEYWORDS, stringKeywords);
    }

    public List<String> getActionDelayAffectedKeywords() throws IOException {
        String stringKeywords = this.getString(CONF_PROPERTY_ACTION_DELAY_AFFECTED_KEYWORDS, null);
        if (stringKeywords == null) {
            return Arrays.asList(DEFAULT_ACTION_DELAY_AFFECTED_KEYWORDS);
        }
        return Arrays.stream(stringKeywords.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static MobileSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new MobileSettingStore(projectEntity.getFolderLocation());
    }

    public MobileSettingStore(String projectDir) {
        super(projectDir, MOBILE_SETTINGS_FILE_NAME, false);
    }

    public MobileDisplayObjectTreeOption getDefaultMobileDisplayObjectTreeOption() {
        try {
            return MobileDisplayObjectTreeOption.valueOf((String)this.getString(CONF_PROPERTY_DEFAULT_OPTION_DISPLAYING_TREE, DEFAULT_DISPLAY_TREE_OPTION_IF_NOT_SET.name()));
        }
        catch (IOException | IllegalArgumentException | NullPointerException exception) {
            return DEFAULT_DISPLAY_TREE_OPTION_IF_NOT_SET;
        }
    }

    public void saveDefaultOptionDisplayTree(String value) {
        try {
            this.setProperty(CONF_PROPERTY_DEFAULT_OPTION_DISPLAYING_TREE, value);
        }
        catch (IOException | IllegalArgumentException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    public LocatorStrategy getDefaultLocatorStrategy() {
        try {
            return LocatorStrategy.valueOfStrategy((String)this.getString(CONF_PROPERTY_DEFAULT_OPTION_LOCATOR, DEFAULT_LOCATOR.name()));
        }
        catch (IOException | IllegalArgumentException | NullPointerException exception) {
            return DEFAULT_LOCATOR;
        }
    }

    public void setDefaultLocatorStrategy(String value) {
        try {
            this.setProperty(CONF_PROPERTY_DEFAULT_OPTION_LOCATOR, value);
        }
        catch (IOException | IllegalArgumentException e) {
            LogUtil.logError((Throwable)e);
        }
    }

    public boolean getSelfHealingEnabled(boolean defaultValue) {
        try {
            return this.getBoolean(CONF_PROPERTY_SELF_HEALING_ENABLED, defaultValue);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setSelfHealingEnabled(boolean enabled) throws IOException {
        this.setProperty(CONF_PROPERTY_SELF_HEALING_ENABLED, enabled);
    }

    public void setDefaultPrioritizedLocatorStrategies(MobilePlatform platformName) throws IOException {
        if (MobilePlatform.ANDROID.equals((Object)platformName)) {
            this.setProperty(CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_ANDROID, "");
        } else if (MobilePlatform.IOS.equals((Object)platformName)) {
            this.setProperty(CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_IOS, "");
        }
    }

    public void setPrioritizedLocatorStrategies(MobilePlatform platformName, List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategies) throws IOException {
        ArrayList<Pair<String, Boolean>> convertedList = new ArrayList<Pair<String, Boolean>>();
        for (Pair<LocatorStrategy, Boolean> element : prioritizedLocatorStrategies) {
            Pair convertedElement = new Pair((Object)((LocatorStrategy)element.getLeft()).toString(), (Object)((Boolean)element.getRight()));
            convertedList.add((Pair<String, Boolean>)convertedElement);
        }
        String flattenPrioritizedLocatorStrategies = this.flattenStringBooleanList(convertedList);
        if (MobilePlatform.ANDROID.equals((Object)platformName)) {
            this.setProperty(CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_ANDROID, flattenPrioritizedLocatorStrategies);
        } else if (MobilePlatform.IOS.equals((Object)platformName)) {
            this.setProperty(CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_IOS, flattenPrioritizedLocatorStrategies);
        }
    }

    public List<Pair<LocatorStrategy, Boolean>> getPrioritizedLocatorStrategies(MobilePlatform platform) throws IOException {
        ArrayList prioritizedLocatorStrategies = new ArrayList();
        String plattenPrioritizedLocatorStrategies = "";
        if (MobilePlatform.ANDROID.equals((Object)platform)) {
            plattenPrioritizedLocatorStrategies = this.getString(CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_ANDROID, "");
        } else if (MobilePlatform.IOS.equals((Object)platform)) {
            plattenPrioritizedLocatorStrategies = this.getString(CONF_PROPERTY_PRIORITEZED_LOCATOR_STRATEGIES_FOR_IOS, "");
        }
        if (StringUtils.isNotEmpty((String)plattenPrioritizedLocatorStrategies)) {
            List<Pair<String, Boolean>> rawPrioritizedLocatorStrategies = this.parseStringBooleanString(plattenPrioritizedLocatorStrategies);
            if (rawPrioritizedLocatorStrategies.size() > 0) {
                rawPrioritizedLocatorStrategies.forEach(rawLocatorStrategy -> prioritizedLocatorStrategies.add(Pair.of((Object)LocatorStrategy.valueOf((String)((String)rawLocatorStrategy.getLeft())), (Object)((Boolean)rawLocatorStrategy.getRight()))));
            }
        } else {
            List locatoStrategies = LocatorStrategy.getLocatorStrategies((MobilePlatform)platform);
            locatoStrategies.forEach(locatorStrategy -> {
                boolean isSelected = true;
                if (LocatorStrategy.CLASS_NAME.equals(locatorStrategy) || LocatorStrategy.IMAGE.equals(locatorStrategy) || LocatorStrategy.CUSTOM.equals(locatorStrategy)) {
                    isSelected = false;
                }
                prioritizedLocatorStrategies.add(Pair.of((Object)locatorStrategy, (Object)isSelected));
            });
        }
        return prioritizedLocatorStrategies.stream().filter(p -> {
            LocatorStrategy locatorStrategy = (LocatorStrategy)p.getLeft();
            return !LocatorStrategy.IMAGE.equals((Object)locatorStrategy);
        }).collect(Collectors.toList());
    }

    public void setDefaultExcludedKeywords() throws IOException {
        this.setProperty(CONF_PROPERTY_EXCLUDED_KEYWORDS, "");
    }

    public void setExcludedKeywords(List<String> excludeKeywords) throws IOException {
        String rawExcludeKeywords = excludeKeywords.stream().collect(Collectors.joining(","));
        this.setProperty(CONF_PROPERTY_EXCLUDED_KEYWORDS, rawExcludeKeywords);
    }

    public List<String> getExcludedKeywords() throws IOException {
        String rawExcludeKeywords = this.getString(CONF_PROPERTY_EXCLUDED_KEYWORDS, "");
        if (StringUtils.isEmpty((String)rawExcludeKeywords)) {
            return EXCLUDED_SELF_HEALING_KEYWORDS;
        }
        return Arrays.stream(rawExcludeKeywords.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public MobilePlatformExecutionSettings getExecutionSettings() throws IOException {
        return new MobilePlatformExecutionSettings.Builder().elementTimeoutInSeconds(this.getElementTimeout()).actionDelayInMillis(this.getActionDelayInMillis()).actionDelayAffectedKeywords(this.getActionDelayAffectedKeywords()).newCommandTimeoutInSeconds(this.getNewCommandTimeoutSeconds()).prioritizedLocatorStrategiesForAndroid(this.getPrioritizedLocatorStrategies(MobilePlatform.ANDROID)).prioritizedLocatorStrategiesForIos(this.getPrioritizedLocatorStrategies(MobilePlatform.IOS)).enableSelfHealing(this.getSelfHealingEnabled(false)).excludedKeywords(this.getExcludedKeywords()).setAiSelfHealingEnabled(this.getAISelfHealingEnabled().booleanValue()).setAiSelfHealingInputSources(this.getAISelfHealingInputSources()).build();
    }

    public Boolean getAISelfHealingEnabled() throws IOException {
        return this.getBoolean(PROP_AI_SELFHEALING_ENABLED, true);
    }

    public void setAISelfHealingEnabled(Boolean aiSelfHealingEnabled) throws IOException {
        this.setProperty(PROP_AI_SELFHEALING_ENABLED, aiSelfHealingEnabled);
    }

    public void resetAISelfHealingEnabled() throws IOException {
        this.setProperty(PROP_AI_SELFHEALING_ENABLED, true);
    }

    public List<SelfHealingInputSource> getAISelfHealingInputSources() throws IOException {
        return (List)JsonUtil.fromJson((String)this.getString(PROP_AI_SELFHEALING_INPUT_SOURCES, JsonUtil.toJson(DEFAULT_AI_SELFHEALING_INPUTS)), (Type)new TypeToken<List<SelfHealingInputSource>>(){}.getType());
    }

    public void setAISelfHealingInputSources(List<SelfHealingInputSource> inputSources) throws IOException {
        this.setProperty(PROP_AI_SELFHEALING_INPUT_SOURCES, JsonUtil.toJson(inputSources));
    }

    public void resetAISelfHealingInputSources() throws IOException {
        this.setProperty(PROP_AI_SELFHEALING_INPUT_SOURCES, JsonUtil.toJson(DEFAULT_AI_SELFHEALING_INPUTS));
    }

    private String flattenStringBooleanList(List<Pair<String, Boolean>> list) {
        if (list == null || list.isEmpty()) {
            return StringConstants.EMPTY;
        }
        return list.stream().map(i -> (String)i.getLeft() + "," + String.valueOf(i.getRight())).collect(Collectors.joining(";"));
    }

    private List<Pair<String, Boolean>> parseStringBooleanString(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(str.split(";")).map(i -> i.split(",")).map(i -> new Pair((Object)i[0], (Object)Boolean.valueOf(i[1]))).collect(Collectors.toList());
    }
}

