/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.google.gson.reflect.TypeToken;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.internal.WebUIPlatformExecutionSettings;
import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.kms.katalon.core.setting.BundleSettingStore;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.services.FeatureController;
import com.kms.katalon.util.collections.Pair;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.osgi.framework.FrameworkUtil;

public class WebUiExecutionSettingStore
extends BundleSettingStore {
    public static final boolean EXECUTION_DEFAULT_IGNORE_PAGELOAD_TIMEOUT_EXCEPTION = false;
    public static final boolean EXECUTION_DEFAULT_ENABLE_PAGE_LOAD_TIMEOUT = false;
    public static final int EXECUTION_DEFAULT_ACTION_DELAY = 0;
    public static final int EXECUTION_DEFAULT_PAGE_LOAD_TIMEOUT = 30;
    public static final int EXECUTION_DEFAULT_WAIT_FOR_IE_HANGING = 600;
    public static final int EXECUTION_DEFAULT_ELEMENT_TIMEOUT = 10;
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES = "id,true;name,true;alt,true;checked,true;form,true;href,true;placeholder,true;selected,true;src,true;title,true;type,true;text,true;linked_text,true";
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS = "xpath:attributes,true;xpath:idRelative,true;dom:name,true;xpath:link,true;xpath:neighbor,true;xpath:href,true;xpath:img,true;xpath:position,true;xpath:customAttributes,true";
    public static final String DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD = "XPATH";
    public static final String EXECUTION_DEFAULT_USE_ACTION_DELAY_TIME_UNIT = TimeUnit.SECONDS.toString();
    public static final String DEFAULT_METHODS_PRIORITY_ORDER = MessageFormat.format("{0},true;{1},true;{2},true;{3},true;{4},true", SelectorMethod.XPATH, SelectorMethod.SMART_LOCATOR, SelectorMethod.BASIC, SelectorMethod.CSS, SelectorMethod.IMAGE);
    public static final List<String> DEFAULT_EXCLUDE_KEYWORDS = List.of("verifyOptionNotPresentByLabel", "verifyOptionNotPresentByValue", "verifyOptionNotSelectedByIndex", "verifyOptionNotSelectedByLabel", "verifyOptionNotSelectedByValue", "verifyOptionPresentByLabel", "verifyOptionPresentByValue", "verifyOptionSelectedByIndex", "verifyOptionSelectedByLabel", "verifyOptionSelectedByValue", "verifyOptionsPresent", "verifyTextNotPresent", "verifyTextPresent", "verifyElementAttributeValue", "verifyElementChecked", "verifyElementClickable", "verifyElementHasAttribute", "verifyElementNotChecked", "verifyElementNotClickable", "verifyElementNotHasAttribute", "verifyElementNotPresent", "verifyElementNotVisibleInViewport", "verifyElementNotVisible", "verifyElementPresent", "verifyElementText", "verifyElementVisibleInViewport", "verifyElementVisible", "waitForElementAttributeValue", "waitForElementClickable", "waitForElementHasAttribute", "waitForElementNotClickable", "waitForElementNotHasAttribute", "waitForElementNotPresent", "waitForElementNotVisible", "waitForElementPresent", "waitForElementVisible");
    public static final List<String> DEFAULT_EXCLUDE_KEYWORDS_DONOT_SHOW_ON_UI = List.of();
    public static final boolean DEFAULT_IS_ENABLE_SELF_HEALING = false;
    public static final boolean DEFAULT_IS_ENABLE_TIME_CAPSULE = false;
    public static final boolean DEFAULT_FLUTTER_APP_TESTING_ENABLED = false;
    public static final boolean DEFAULT_CANVAS_TEXT_EXTRACTION_ENABLED = false;
    public static final boolean DEFAULT_CLOSED_SHADOW_DOM_ENABLED = false;
    public static final String DEFAULT_RECORDER_EXCLUSION_PATTERN = "";
    public static final boolean DEFAULT_AI_SELFHEALING_ENABLED = true;
    public static final List<SelfHealingInputSource> DEFAULT_AI_SELFHEALING_INPUTS = Arrays.asList(SelfHealingInputSource.PAGE_SOURCE, SelfHealingInputSource.ELEMENT_SCREENSHOT, SelfHealingInputSource.FULL_PAGE_SCREENSHOT);

    public static WebUiExecutionSettingStore getStore() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        if (projectEntity == null) {
            return null;
        }
        return new WebUiExecutionSettingStore(projectEntity);
    }

    public WebUiExecutionSettingStore(ProjectEntity projectEntity) {
        super(projectEntity.getFolderLocation(), FrameworkUtil.getBundle(WebUiExecutionSettingStore.class).getSymbolicName(), false);
    }

    public WebUiExecutionSettingStore(String projectEntityDirection, boolean isExternal) {
        super(projectEntityDirection, FrameworkUtil.getBundle(WebUiExecutionSettingStore.class).getSymbolicName(), isExternal);
    }

    public boolean getEnablePageLoadTimeout() throws IOException {
        return this.getBoolean("execution.default.webUi.enablePageLoadTimeout", false);
    }

    public void setEnablePageLoadTimeout(boolean pageLoadTimeoutEnabled) throws IOException {
        this.setProperty("execution.default.webUi.enablePageLoadTimeout", pageLoadTimeoutEnabled);
    }

    public boolean getIgnorePageLoadTimeout() throws IOException {
        return this.getBoolean("execution.default.webUi.ignorePageLoadTimeOutException", false);
    }

    public void setIgnorePageLoadTimeout(boolean pageLoadTimeoutIgnored) throws IOException {
        this.setProperty("execution.default.webUi.ignorePageLoadTimeOutException", pageLoadTimeoutIgnored);
    }

    public int getPageLoadTimeout() throws IOException {
        return this.getInt("execution.default.webUi.pageLoadTimeout", 30);
    }

    public void setPageLoadTimeout(int pageLoadTimeout) throws IOException {
        this.setProperty("execution.default.webUi.pageLoadTimeout", pageLoadTimeout);
    }

    public int getActionDelay() throws IOException {
        return this.getInt("execution.default.webUi.actionDelay", 0);
    }

    public void setActionDelay(int actionDelay) throws IOException {
        this.setProperty("execution.default.webUi.actionDelay", actionDelay);
    }

    public int getIEHangTimeout() throws IOException {
        return this.getInt("execution.default.waitForIEHanging", 600);
    }

    public void setIEHangTimeout(int timeout) throws IOException {
        this.setProperty("execution.default.waitForIEHanging", timeout);
    }

    public int getElementTimeout() throws IOException {
        return this.getInt("execution.default.webUi.elementTimeout", ExecutionDefaultSettingStore.getStore().getElementTimeout());
    }

    public int safelyGetElementTimeout() {
        try {
            return this.getElementTimeout();
        }
        catch (Exception exception) {
            return 10;
        }
    }

    public void setElementTimeout(int elementTimeout) throws IOException {
        this.setProperty("execution.default.webUi.elementTimeout", elementTimeout);
    }

    public void setDefaultIEHangTimeout() throws IOException {
        this.setProperty("execution.default.waitForIEHanging", 600);
    }

    public void setDefaultCapturedTestObjectAttributeLocators() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectProperties", DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES);
    }

    public void setCapturedTestObjectAttributeLocators(List<Pair<String, Boolean>> locators) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectProperties", this.flattenStringBooleanList(locators));
    }

    public List<Pair<String, Boolean>> getCapturedTestObjectAttributeLocators() throws IOException {
        return this.parseStringBooleanString(this.getString("execution.default.selectingCapturedObjectProperties", DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES));
    }

    public List<Pair<String, Boolean>> getDefaultCapturedTestObjectAttributeLocators() throws IOException {
        return this.parseStringBooleanString(this.getString(DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES, DEFAULT_SELECTING_CAPTURED_OBJECT_PROPERTIES));
    }

    public List<Pair<String, Boolean>> getCapturedTestObjectXpathLocators() throws IOException {
        return this.loadStringBooleanString("execution.default.selectingCapturedObjectXpaths", DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public List<Pair<String, Boolean>> getDefaultCapturedObjectXpathLocators() throws IOException {
        return this.loadStringBooleanString(DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS, DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public void setDefaultCapturedTestObjectXpathLocators() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectXpaths", DEFAULT_SELECTING_CAPTURED_OBJECT_XPATHS);
    }

    public void setCapturedTestObjectXpathLocators(List<Pair<String, Boolean>> locators) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectXpaths", this.flattenStringBooleanList(locators));
    }

    public void setDefaultCapturedTestObjectSelectorMethods() throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD);
    }

    public void setCapturedTestObjectSelectorMethod(SelectorMethod selectorMethod) throws IOException {
        this.setProperty("execution.default.selectingCapturedObjectSelectorMethod", selectorMethod.toString());
    }

    public void setBufferedSelectorMethod(SelectorMethod selectorMethod) throws IOException {
        this.setProperty("execution.default.bufferedSelectorMethod", selectorMethod.toString());
    }

    public void setSelectorMethodIsSmartLocator(boolean isUsingSmartLocator) throws IOException {
        this.setProperty("execution.default.isUsingSmartLocator", isUsingSmartLocator);
    }

    public SelectorMethod getCapturedTestObjectSelectorMethod() throws IOException {
        SelectorMethod chosenMethod;
        SelectorMethod bufferedMethod = this.getBufferedSelectorMethod();
        if (bufferedMethod != (chosenMethod = this.parseSelectorMethodString(this.getString("execution.default.selectingCapturedObjectSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD)))) {
            this.setBufferedSelectorMethod(chosenMethod);
            this.setSelectorMethodIsSmartLocator(false);
            return chosenMethod;
        }
        if (this.getSelectorMethodIsSmartLocator()) {
            return SelectorMethod.SMART_LOCATOR;
        }
        return chosenMethod;
    }

    public boolean getSelectorMethodIsSmartLocator() throws IOException {
        return this.getBoolean("execution.default.isUsingSmartLocator", false);
    }

    public SelectorMethod getBufferedSelectorMethod() throws IOException {
        return this.parseSelectorMethodString(this.getString("execution.default.bufferedSelectorMethod", DEFAULT_SELECTING_CAPTURED_OBJECT_SELECTOR_METHOD));
    }

    public WebUIPlatformExecutionSettings getExecutionSettings() throws IOException {
        return new WebUIPlatformExecutionSettings.Builder().elementTimeoutInSeconds(this.getElementTimeout()).enableSelfHealing(this.getSelfHealingEnabled(FeatureController.getInstance().canUse(ProductFeature.SELF_HEALING))).setExcludeKeywords(this.getExcludeKeywordList()).setMethodsPriorityOrder(this.getMethodsPriorityOrder()).setAiSelfHealingEnabled(this.getAISelfHealingEnabled().booleanValue()).setAiSelfHealingInputSources(this.getAISelfHealingInputSources()).build();
    }

    private String flattenStringBooleanList(List<Pair<String, Boolean>> list) {
        if (list == null || list.isEmpty()) {
            return StringConstants.EMPTY;
        }
        return list.stream().map(i -> (String)i.getLeft() + "," + String.valueOf(i.getRight())).collect(Collectors.joining(";"));
    }

    private List<Pair<String, Boolean>> parseStringBooleanString(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        return Stream.of(str.split(";")).map(i -> i.split(",")).map(i -> new Pair((Object)i[0], (Object)Boolean.valueOf(i[1]))).collect(Collectors.toList());
    }

    private SelectorMethod parseSelectorMethodString(String str) {
        try {
            if (str == null || str.isEmpty()) {
                return SelectorMethod.BASIC;
            }
            return SelectorMethod.valueOf((String)str);
        }
        catch (Exception exception) {
            return SelectorMethod.BASIC;
        }
    }

    private List<Pair<String, Boolean>> loadStringBooleanString(String key, String defaultValue) throws IOException {
        List<Pair<String, Boolean>> allItems = this.parseStringBooleanString(this.getString(key, defaultValue));
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            List<Pair<String, Boolean>> defaultItems = this.parseStringBooleanString(defaultValue);
            defaultItems.forEach(itemI -> {
                if (!allItems.contains(itemI)) {
                    allItems.add((Pair<String, Boolean>)itemI);
                }
            });
        }
        return allItems;
    }

    public void setUseDelayActionTimeUnit(TimeUnit timeUnit) throws IOException {
        this.setProperty("execution.default.useDelayActionInSecond", timeUnit.toString());
    }

    public TimeUnit getUseDelayActionTimeUnit() {
        try {
            return TimeUnit.valueOf(this.getString("execution.default.useDelayActionInSecond", EXECUTION_DEFAULT_USE_ACTION_DELAY_TIME_UNIT));
        }
        catch (IOException iOException) {
            return TimeUnit.valueOf(EXECUTION_DEFAULT_USE_ACTION_DELAY_TIME_UNIT);
        }
    }

    public void setExcludeKeywordList(List<String> excludeKeywords) throws IOException {
        String jsonExcludeKeywords = JsonUtil.toJson(excludeKeywords, (boolean)false);
        this.setProperty("execution.default.webUi.excludeKeywords", jsonExcludeKeywords);
        this.setProperty("execution.default.webUi.selfHealingExcludedKeywords", jsonExcludeKeywords);
        this.setWebuiProperty("execution.default.webUi.excludeKeywords", jsonExcludeKeywords);
    }

    public List<String> getExcludeKeywordList() throws IOException {
        List<String> excludeKeywordsFromSettingStoreList = this.getExcludeKeywordFromSettingStoreList();
        List<String> excludeKeywordDonNotShowOnUIList = this.getExcludeKeywordDoNotShowOnUIList();
        ArrayList<String> excludeKeywords = new ArrayList<String>();
        excludeKeywords.addAll(excludeKeywordsFromSettingStoreList);
        excludeKeywords.addAll(excludeKeywordDonNotShowOnUIList);
        return excludeKeywords.stream().distinct().collect(Collectors.toList());
    }

    public List<String> getExcludeKeywordFromSettingStoreList() throws IOException {
        Type excludeKeywordsMapType = new TypeToken<List<String>>(){}.getType();
        String jsonExcludeKeywords = this.getString("execution.default.webUi.selfHealingExcludedKeywords", null);
        if (jsonExcludeKeywords == null) {
            List<String> defaultExcludeKeywords = this.getDefaultExcludeKeywordList();
            List<String> mergedExcludeKeywords = new ArrayList<String>(defaultExcludeKeywords);
            jsonExcludeKeywords = this.getString("execution.default.webUi.excludeKeywords", null);
            if (jsonExcludeKeywords != null) {
                List excludeKeywords = (List)JsonUtil.fromJson((String)jsonExcludeKeywords, (Type)excludeKeywordsMapType);
                if (excludeKeywords == null) {
                    excludeKeywords = Collections.emptyList();
                }
                mergedExcludeKeywords.addAll(excludeKeywords);
            } else {
                jsonExcludeKeywords = this.getWebuiString("execution.default.webUi.excludeKeywords", DEFAULT_RECORDER_EXCLUSION_PATTERN);
                List webUiExcludeKeywords = (List)JsonUtil.fromJson((String)jsonExcludeKeywords, (Type)excludeKeywordsMapType);
                if (webUiExcludeKeywords != null && !webUiExcludeKeywords.isEmpty()) {
                    mergedExcludeKeywords.addAll(webUiExcludeKeywords);
                }
            }
            mergedExcludeKeywords = mergedExcludeKeywords.stream().distinct().collect(Collectors.toList());
            this.setProperty("execution.default.webUi.selfHealingExcludedKeywords", JsonUtil.toJson(mergedExcludeKeywords, (boolean)false));
            this.setProperty("execution.default.webUi.excludeKeywords", JsonUtil.toJson(mergedExcludeKeywords, (boolean)false));
            this.setWebuiProperty("execution.default.webUi.excludeKeywords", JsonUtil.toJson(mergedExcludeKeywords, (boolean)false));
            return mergedExcludeKeywords;
        }
        if (StringUtils.isBlank((CharSequence)jsonExcludeKeywords)) {
            return new ArrayList<String>();
        }
        return (List)JsonUtil.fromJson((String)jsonExcludeKeywords, (Type)excludeKeywordsMapType);
    }

    public List<String> getExcludeKeywordDoNotShowOnUIList() {
        return DEFAULT_EXCLUDE_KEYWORDS_DONOT_SHOW_ON_UI;
    }

    public List<String> getDefaultExcludeKeywordList() {
        return DEFAULT_EXCLUDE_KEYWORDS;
    }

    public void setDefaultExcludeKeywordList() throws IOException {
        String jsonExcludeKeywords = JsonUtil.toJson(DEFAULT_EXCLUDE_KEYWORDS, (boolean)false);
        this.setProperty("execution.default.webUi.excludeKeywords", jsonExcludeKeywords);
        this.setProperty("execution.default.webUi.selfHealingExcludedKeywords", jsonExcludeKeywords);
        this.setWebuiProperty("execution.default.webUi.excludeKeywords", jsonExcludeKeywords);
    }

    public void setMethodsPritorityOrder(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) throws IOException {
        ArrayList<Pair<String, Boolean>> convertedList = new ArrayList<Pair<String, Boolean>>();
        for (Pair<SelectorMethod, Boolean> element : methodsPriorityOrder) {
            Pair convertedElement = new Pair((Object)((SelectorMethod)element.getLeft()).toString(), (Object)((Boolean)element.getRight()));
            convertedList.add((Pair<String, Boolean>)convertedElement);
        }
        this.setProperty("execution.default.webUi.methodsPriorityOrderNew", this.flattenStringBooleanList(convertedList));
    }

    public List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrder() throws IOException {
        List<Pair<String, Boolean>> rawMethodsPriorityOrder = this.parseStringBooleanString(this.getString("execution.default.webUi.methodsPriorityOrderNew", DEFAULT_METHODS_PRIORITY_ORDER));
        ArrayList<Pair<SelectorMethod, Boolean>> methodsPriorityOrder = new ArrayList<Pair<SelectorMethod, Boolean>>();
        rawMethodsPriorityOrder.forEach(rawMethod -> {
            Pair method = Pair.of((Object)SelectorMethod.valueOf((String)((String)rawMethod.getLeft())), (Object)((Boolean)rawMethod.getRight()));
            methodsPriorityOrder.add(method);
        });
        return methodsPriorityOrder;
    }

    public void setDefaultMethodsPriorityOrder() throws IOException {
        this.setProperty("execution.default.webUi.methodsPriorityOrderNew", DEFAULT_METHODS_PRIORITY_ORDER);
    }

    public boolean getSelfHealingEnabled(boolean defaultValue) {
        try {
            return this.getBoolean("execution.default.webUi.selfHealingEnabled", defaultValue);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setEnableSelfHealing(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.selfHealingEnabled", isEnable);
    }

    public boolean getTimeCapsuleEnabled() {
        try {
            return this.getBoolean("execution.default.webUi.timeCapsuleEnabled", false);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setEnableTimeCapsule(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.timeCapsuleEnabled", isEnable);
    }

    public boolean isEnableFlutterAppTesting() throws IOException {
        return this.getBoolean("execution.default.webUi.flutterAppTesting", false);
    }

    public void setEnableFlutterAppTesting(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.flutterAppTesting", isEnable);
    }

    public boolean isEnableCanvasTextExtraction() throws IOException {
        return this.getBoolean("execution.default.webUi.canvasTextExtraction", false);
    }

    public void setEnableCanvasTextExtraction(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.canvasTextExtraction", isEnable);
    }

    public boolean isEnableClosedShadowDOMTesting() throws IOException {
        return this.getBoolean("execution.default.webUi.closedShadowDOMTesting", false);
    }

    public void setEnableClosedShadowDOMTesting(boolean isEnable) throws IOException {
        this.setProperty("execution.default.webUi.closedShadowDOMTesting", isEnable);
    }

    public void setDefaultRecorderExclusionPattern() throws IOException {
        this.setProperty("execution.default.recorderPlus.setting", DEFAULT_RECORDER_EXCLUSION_PATTERN);
    }

    public String getRecorderExclusionPattern() throws IOException {
        return this.getString("execution.default.recorderPlus.setting", DEFAULT_RECORDER_EXCLUSION_PATTERN);
    }

    public void setRecorderExclusionPattern(String recorderExclusionPattern) throws IOException {
        this.setProperty("execution.default.recorderPlus.setting", recorderExclusionPattern);
    }

    public Boolean getAISelfHealingEnabled() throws IOException {
        return this.getBoolean("execution.default.webUi.aiSelfHealing.enabled", true);
    }

    public void setAISelfHealingEnabled(Boolean aiSelfHealingEnabled) throws IOException {
        this.setProperty("execution.default.webUi.aiSelfHealing.enabled", aiSelfHealingEnabled);
    }

    public void resetAISelfHealingEnabled() throws IOException {
        this.setProperty("execution.default.webUi.aiSelfHealing.enabled", true);
    }

    public List<SelfHealingInputSource> getAISelfHealingInputSources() throws IOException {
        return (List)JsonUtil.fromJson((String)this.getString("execution.default.webUi.aiSelfHealing.inputSources", JsonUtil.toJson(DEFAULT_AI_SELFHEALING_INPUTS)), (Type)new TypeToken<List<SelfHealingInputSource>>(){}.getType());
    }

    public void setAISelfHealingInputSources(List<SelfHealingInputSource> inputSources) throws IOException {
        this.setProperty("execution.default.webUi.aiSelfHealing.inputSources", JsonUtil.toJson(inputSources));
    }

    public void resetAISelfHealingInputSources() throws IOException {
        this.setProperty("execution.default.webUi.aiSelfHealing.inputSources", JsonUtil.toJson(DEFAULT_AI_SELFHEALING_INPUTS));
    }
}

