/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.util;

import com.kms.katalon.logging.LogUtil;
import java.util.Objects;

public class ProcessUtils {
    private ProcessUtils() {
    }

    public static void forceKillProcessTree(Process process) {
        if (Objects.isNull(process)) {
            LogUtil.logInfo((String)"Process not found");
            return;
        }
        long pid = process.pid();
        ProcessHandle.of(pid).ifPresentOrElse(processHandle -> {
            if (!processHandle.isAlive()) {
                LogUtil.logInfo((String)("Process " + pid + " already terminated"));
            } else {
                ProcessUtils.killProcessAndChildren(processHandle);
            }
        }, () -> LogUtil.logInfo((String)("Process " + pid + " not found")));
    }

    private static void killProcessAndChildren(ProcessHandle process) {
        process.children().forEach(childProcess -> ProcessUtils.killProcessAndChildren(childProcess));
        if (process.isAlive()) {
            try {
                process.destroyForcibly();
            }
            catch (Exception e) {
                LogUtil.logError((String)("Failed to force kill process PID: " + String.valueOf(process.pid())));
                LogUtil.logError((Throwable)e);
            }
        }
    }
}

