/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.e4;

import com.kms.katalon.ai.core.controller.IStudioAssistReferenceContextController;
import com.kms.katalon.ai.core.model.chat.UserChatMessageName;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.exception.StudioAssistConfigUnavailableException;
import com.kms.katalon.ai.core.model.exception.StudioAssistDisabledException;
import com.kms.katalon.ai.core.model.exception.StudioAssistException;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistServiceUnreachableException;
import com.kms.katalon.ai.core.model.exception.StudioAssistUnavailableException;
import com.kms.katalon.ai.core.model.llm.UserMessage;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.ai.services.TextSelectionService;
import com.kms.katalon.composer.ai.studioassist.dialog.AIDisabledNotificationDialog;
import com.kms.katalon.composer.ai.studioassist.dialog.StudioAssistFeedbackDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.core.setting.IStudioAssistAiAutoTagSetting;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Creatable
public abstract class ExecutePromptHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IStudioAssistController controller;
    @Inject
    private IStudioAssistReferenceContextController referenceContextController;
    @Inject
    private TextSelectionService textSelectionService;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication application;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private int numberOfCodeExplanationsUsed;

    @PostConstruct
    public void registerListeners() {
        this.eventBroker.subscribe("ON_EXECUTE_PROMPT", new EventHandler(){

            public void handleEvent(Event event) {
                Map data = (Map)event.getProperty("org.eclipse.e4.data");
                ExecutePromptHandler.this.numberOfCodeExplanationsUsed = (Integer)data.get("number");
            }
        });
    }

    @CanExecute
    public boolean canExecute() {
        return this.controller.isEnabled();
    }

    @Execute
    public void execute() {
        boolean canExecute = false;
        try {
            canExecute = this.controller.canExecute();
        }
        catch (Exception e) {
            this.handleStudioAssistError(e);
        }
        PromptType promptType = this.getPromptType();
        if (!canExecute || promptType != PromptType.CODE_GENERATE && promptType != PromptType.CODE_EXPLAIN) {
            return;
        }
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            String taskDescription = ExecutePromptHandler.this.getPromptType() == PromptType.CODE_GENERATE ? ComposerStudioAssistConstants.GENERATE_CODE_JOB_PROGRESS_MSG : ComposerStudioAssistConstants.EXPLAIN_CODE_JOB_PROGRESS_MSG;
                            monitor.beginTask(taskDescription, 4);
                            ArrayList messages = new ArrayList();
                            UISynchronizeService.syncExec(() -> {
                                List contextPrompt = null;
                                try {
                                    contextPrompt = ExecutePromptHandler.this.referenceContextController.getContext(null, null, ExecutePromptHandler.this.getPromptType(), null);
                                }
                                catch (StudioAssistBaseException e) {
                                    LoggerSingleton.logWarn((Throwable)e, (String)"Something went wrong while getting context for generating/explaining code.");
                                }
                                if (contextPrompt != null && contextPrompt.size() > 0) {
                                    contextPrompt.stream().forEach(each -> {
                                        boolean bl = messages.add(UserMessage.of((String)each.getContent(), (String)UserChatMessageName.REFERENCE_CONTEXT.getContent()));
                                    });
                                }
                                String currentFilePrompt = ExecutePromptHandler.this.textSelectionService.getFocusingFileContent(window);
                                currentFilePrompt = String.format("Below is the reference context, which is the entire content of a file in Groovy language version 3:\n```groovy\n%s\n```\n", currentFilePrompt);
                                messages.add(UserMessage.of((String)currentFilePrompt, (String)UserChatMessageName.REFERENCE_CONTEXT.getContent()));
                                String userPrompt = ExecutePromptHandler.this.textSelectionService.getSelectedTexts(window);
                                messages.add(UserMessage.of((String)userPrompt, (String)UserChatMessageName.USER_INPUT.getContent()));
                            });
                            monitor.worked(1);
                            try {
                                TestCaseEntity testCaseEntity;
                                IStudioAssistAiAutoTagSetting aiAutoTaggingSetting;
                                String result = ExecutePromptHandler.this.controller.executePrompt(ExecutePromptHandler.this.getPromptType(), messages);
                                if (ExecutePromptHandler.this.getPromptType() == PromptType.CODE_GENERATE && (aiAutoTaggingSetting = ExecutePromptHandler.this.controller.getStudioAssistAiAutoTagSetting()).isCodeGeneration() && (testCaseEntity = ExecutePromptHandler.this.getActiveTestCase()) != null) {
                                    boolean isGenerateCodeDefaultTag = aiAutoTaggingSetting.isCodeGenerationDefaultTag();
                                    String tag = isGenerateCodeDefaultTag ? "GenAI" : aiAutoTaggingSetting.getGenerateCodeCustomTag();
                                    testCaseEntity.updateTagForTestCase(tag);
                                }
                                monitor.worked(2);
                                Thread.sleep(800L);
                                UISynchronizeService.asyncExec(() -> ExecutePromptHandler.this.textSelectionService.insertCodeIntoEditor("\n" + result, window));
                                monitor.worked(1);
                                Thread.sleep(200L);
                            }
                            catch (StudioAssistException e) {
                                ExecutePromptHandler.this.handleStudioAssistError((Exception)((Object)e));
                            }
                        }
                        catch (Exception exception) {
                            throw new InvocationTargetException(exception, exception.getMessage());
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            this.handleStudioAssistError(e);
        }
        this.onExecutePromptCalled();
    }

    private TestCaseEntity getActiveTestCase() {
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        if (composerStack == null) {
            return null;
        }
        MPart selectedPart = (MPart)composerStack.getSelectedElement();
        if (selectedPart == null || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)selectedPart.getObject();
        TestCaseEntity testCaseEntity = testCaseCompositePart.getTestCase();
        return testCaseEntity;
    }

    protected abstract PromptType getPromptType();

    private void handleStudioAssistError(Exception exception) {
        if (!(exception instanceof StudioAssistBaseException)) {
            String errorMessage = exception.getMessage();
            this.showErrorDialog(errorMessage);
            return;
        }
        if (exception instanceof StudioAssistLoadingConfigException) {
            this.showErrorDialog(ComposerStudioAssistConstants.ERROR_CANNOT_LOAD_CONFIG);
        } else if (exception instanceof StudioAssistConfigUnavailableException) {
            this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.ai.AiConfigurationPage");
        } else if (exception instanceof StudioAssistUnavailableException) {
            UISynchronizeService.syncExec(() -> this.productFeatureDialog.showNotAvailableFeature(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT));
        } else if (exception instanceof StudioAssistDisabledException) {
            this.showDisabledAINotificationDialog();
        } else if (exception instanceof StudioAssistServiceUnreachableException) {
            this.showErrorDialog(ComposerStudioAssistConstants.ERROR_SERVICE_UNREACHABLE);
        } else {
            String errorMessage = exception.getMessage();
            if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"401")) {
                this.showErrorDialog(errorMessage + ComposerStudioAssistConstants.ERROR_MESSAGE_FOR_401_CODE, ComposerStudioAssistConstants.ERROR + " 401 - Forbidden");
            } else if (StringUtils.contains((CharSequence)errorMessage, (CharSequence)"NetworkErrorException")) {
                this.showErrorDialog(ComposerStudioAssistConstants.ERROR_INTERNET_CONNECTION, ComposerStudioAssistConstants.CONNECTION_ISSUE);
            } else {
                this.showErrorDialog(errorMessage);
            }
        }
    }

    private void onExecutePromptCalled() {
        if (this.numberOfCodeExplanationsUsed == 10) {
            UISynchronizeService.asyncExec(() -> this.showFeedbackDialog());
        }
    }

    private void showErrorDialog(String message) {
        this.showErrorDialog(message, ComposerStudioAssistConstants.ERROR);
    }

    private void showDisabledAINotificationDialog() {
        UISynchronizeService.asyncExec(() -> new AIDisabledNotificationDialog().open());
    }

    private void showErrorDialog(String message, String title) {
        UISynchronizeService.asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message));
    }

    private void showFeedbackDialog() {
        String url = WebViewController.getInstance().getPage("ShareYourFeedback.html");
        Display display = Display.getDefault();
        Shell aShell = new Shell(display, 1264);
        aShell.setLocation(display.getBounds().width, display.getBounds().height);
        StudioAssistFeedbackDialog dialog = new StudioAssistFeedbackDialog(aShell, url);
        dialog.open();
    }
}

