/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.provider;

import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.util.NameUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;

public class TestCaseAIGenerationLabelProvider
extends EntityLabelProvider {
    private Set<ITreeEntity> longNameSet = new HashSet<ITreeEntity>();

    protected StyleRange[] getStyleRanges(ViewerCell cell, ITreeEntity element) {
        try {
            if (element instanceof TestCaseTreeEntity) {
                String text = element.getText();
                String parentPath = element.getObjecParentPathDir();
                ArrayList<StyleRange> range = new ArrayList<StyleRange>();
                if (!NameUtil.isValidName((String)text, (boolean)true) || StringUtils.length((CharSequence)(parentPath + text)) >= 255) {
                    StyleRange highlightStyledRange = new StyleRange(0, text.length() + 1, Display.getCurrent().getSystemColor(3), null);
                    range.add(highlightStyledRange);
                }
                return range.toArray(new StyleRange[range.size()]);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return super.getStyleRanges(cell, element);
    }

    protected String getText(ITreeEntity element) {
        return super.getText(element);
    }

    public Set<ITreeEntity> getLongNameSet() {
        return this.longNameSet;
    }

    public void resetData() {
        this.longNameSet = new HashSet<ITreeEntity>();
    }

    public void update(ViewerCell cell) {
        ITreeEntity element = (ITreeEntity)cell.getElement();
        String text = this.getText(element);
        String parentPath = element.getObjecParentPathDir();
        if (!NameUtil.isValidName((String)text, (boolean)true) || StringUtils.length((CharSequence)(parentPath + text)) >= 255) {
            this.longNameSet.add(element);
        } else {
            this.longNameSet.remove(element);
        }
        super.update(cell);
    }
}

