/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.dialog;

import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AgentProfileAddingDialog
extends CustomTitleAreaDialog {
    private static final int BORDER_RADIUS = 8;
    private static final int MAX_NAME_LENGTH = 60;
    private static final int MAX_DESCRIPTION_LENGTH = 255;
    private static final Pattern ALLOWED_NAME = Pattern.compile("^[A-Za-z0-9_-]+$");
    private final List<String> existingProfileNames;
    private TextField txtName;
    private Text txtDescription;
    private Label lblNameError;
    private Composite nameErrorContainer;
    private Label lblDescriptionError;
    private Composite descriptionErrorContainer;
    private String profileName;
    private String description;

    public AgentProfileAddingDialog(Shell parentShell, Collection<String> existingProfileNames) {
        super(parentShell);
        this.existingProfileNames = existingProfileNames != null ? existingProfileNames.stream().filter(Objects::nonNull).toList() : new ArrayList<String>();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Agent Profile");
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).gridVerticalSpacing(this.convertVerticalDLUsToPixels(4)).gridHorizontalSpacing(this.convertHorizontalDLUsToPixels(4)).minWidth(500).build();
        this.createContentArea(container);
        this.getShell().getDisplay().asyncExec(() -> {
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(false);
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setText("Create");
        }
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle("Create Agent Profile");
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text("Name").fillHorizontal().build();
        this.txtName = (TextField)ComponentBuilder.textField((Composite)container, (int)65536).fillHorizontal().width(500).borderRadius(8).placeholder("Enter Agent Profile name").onChange(event -> {
            boolean bl = this.validateAllFields();
        }).build();
        this.nameErrorContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.lblNameError = null;
        ComponentBuilder.label((Composite)container).text("Description (optional)").fillHorizontal().build();
        this.txtDescription = (Text)ComponentBuilder.textArea((Composite)container, (int)578).fillHorizontal().width(500).rows(5).onChange(event -> {
            boolean bl = this.validateAllFields();
        }).build();
        this.txtDescription.setMessage("Enter Agent Profile description");
        this.descriptionErrorContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.lblDescriptionError = null;
        return container;
    }

    public String getProfileName() {
        if (this.profileName != null) {
            return this.profileName;
        }
        return this.txtName != null && !this.txtName.isDisposed() ? this.txtName.getText() : null;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.txtDescription != null && !this.txtDescription.isDisposed() ? this.txtDescription.getText() : null;
    }

    protected void okPressed() {
        String rawDescription;
        if (this.validateAllFields()) {
            return;
        }
        String rawName = this.txtName != null && !this.txtName.isDisposed() ? this.txtName.getText() : null;
        String string = rawDescription = this.txtDescription != null && !this.txtDescription.isDisposed() ? this.txtDescription.getText() : null;
        if (StringUtils.isNotBlank((CharSequence)rawName)) {
            String trimmed;
            this.profileName = trimmed = rawName.trim();
        }
        this.description = StringUtils.isNotBlank((CharSequence)rawDescription) ? rawDescription.trim() : null;
        super.okPressed();
    }

    private boolean validateAllFields() {
        String nameError = this.validateName();
        String descriptionError = this.validateDescription();
        boolean hasError = nameError != null || descriptionError != null;
        boolean changed = this.updateErrorDisplay(nameError, this.nameErrorContainer, () -> this.lblNameError, label -> {
            Label label2 = this.lblNameError = label;
        });
        if ((changed |= this.updateErrorDisplay(descriptionError, this.descriptionErrorContainer, () -> this.lblDescriptionError, label -> {
            Label label2 = this.lblDescriptionError = label;
        })) && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().pack();
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!hasError);
        }
        return hasError;
    }

    private String validateName() {
        String rawName = this.txtName.getText();
        if (StringUtils.isBlank((CharSequence)rawName)) {
            return "Name is required.";
        }
        String name = rawName.trim();
        if (name.isEmpty()) {
            return "Name is required.";
        }
        if (name.length() > 60) {
            return MessageFormat.format("Maximum {0} characters allowed", 60);
        }
        if (!ALLOWED_NAME.matcher(name).matches()) {
            return "Name must not contain special characters (except \u201c-\u201d and \u201c_\u201d).";
        }
        boolean exists = this.existingProfileNames.stream().filter(Objects::nonNull).anyMatch(existing -> existing.trim().equalsIgnoreCase(name));
        if (exists) {
            return "Name already exists. Please choose a different one.";
        }
        return null;
    }

    private String validateDescription() {
        if (this.txtDescription == null || this.txtDescription.isDisposed()) {
            return null;
        }
        String rawDescription = this.txtDescription.getText();
        String description = StringUtils.trimToNull((String)rawDescription);
        if (description == null) {
            return null;
        }
        if (description.length() > 255) {
            return MessageFormat.format("Maximum {0} characters allowed", 255);
        }
        return null;
    }

    private boolean updateErrorDisplay(String errorMessage, Composite errorContainer, Supplier<Label> labelGetter, Consumer<Label> labelSetter) {
        boolean errorChanged = false;
        Label errorLabel = labelGetter.get();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            if (errorLabel == null || errorLabel.isDisposed()) {
                Label newLabel = (Label)ComponentBuilder.label((Composite)errorContainer).text(errorMessage).fillHorizontal().color(ColorUtil.ERROR_TEXT_COLOR_LIGHTTHEME).build();
                labelSetter.accept(newLabel);
                errorChanged = true;
            } else {
                errorLabel.setText(errorMessage);
            }
            errorContainer.layout();
            if (errorContainer.getParent() != null) {
                errorContainer.getParent().layout();
            }
        } else if (errorLabel != null && !errorLabel.isDisposed()) {
            errorLabel.dispose();
            labelSetter.accept(null);
            errorContainer.layout();
            if (errorContainer.getParent() != null) {
                errorContainer.getParent().layout();
            }
            errorChanged = true;
        }
        return errorChanged;
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }
}

