/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.dialog;

import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.chat.AgentProfile;
import com.kms.katalon.ai.core.services.IAgentManager;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import jakarta.inject.Inject;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpServerAddingDialog
extends CustomTitleAreaDialog {
    private Combo comboTransportType;
    private TextField txtServerUrl;
    private TextField txtName;
    private TextField txtTitle;
    private Label lblNameError;
    private Composite nameErrorContainer;
    private Label lblUrlError;
    private Composite urlErrorContainer;
    private Label lblTitleError;
    private Composite titleErrorContainer;
    private McpServerDefinition server;
    private final AgentProfile agentProfile;
    private boolean isUrlValid = false;
    private boolean isNameValid = false;
    private boolean isTitleValid = true;
    @Inject
    private IAgentManager agentManager;
    private final Logger logger = LoggerFactory.getLogger(McpServerAddingDialog.class);
    private static final String[] TRANSPORT_TYPES = (String[])Arrays.stream(TransportType.values()).map(TransportType::getDisplayName).toArray(String[]::new);
    private static final int BORDER_RADIUS = 8;

    public McpServerAddingDialog(Shell parentShell, AgentProfile agentProfile) {
        super(parentShell);
        this.agentProfile = agentProfile;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_TITLE);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).gridVerticalSpacing(this.convertVerticalDLUsToPixels(4)).gridHorizontalSpacing(this.convertHorizontalDLUsToPixels(4)).minWidth(ComponentUtil.applyZoom((int)500)).build();
        this.createContentArea(container);
        this.getShell().getDisplay().asyncExec(() -> {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
        });
        return container;
    }

    protected Composite createContentArea(Composite parent) {
        this.setDialogTitle(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_TITLE);
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_LABEL_TRANSPORT_TYPE).fillHorizontal().build();
        Composite comboContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)0).fillHorizontal().gridLayout(1, false).margin(1).build();
        this.comboTransportType = (Combo)ComponentBuilder.comboBox((Composite)comboContainer, (int)12).fillHorizontal().build();
        this.comboTransportType.setItems(TRANSPORT_TYPES);
        this.comboTransportType.select(0);
        ComponentBuilder.label((Composite)container).text("").height(2).build();
        ComponentBuilder.label((Composite)container).text(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_LABEL_URL).fillHorizontal().build();
        this.txtServerUrl = (TextField)ComponentBuilder.textField((Composite)container, (int)65536).fillHorizontal().height(24).borderRadius(8).width(500).placeholder(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_PLACEHOLDER_URL).onChange(event -> this.validateUrlField()).build();
        this.urlErrorContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.lblUrlError = null;
        ComponentBuilder.label((Composite)container).text("").height(2).build();
        ComponentBuilder.label((Composite)container).text(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_LABEL_NAME).fillHorizontal().build();
        this.txtName = (TextField)ComponentBuilder.textField((Composite)container, (int)65536).fillHorizontal().width(500).borderRadius(8).placeholder(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_PLACEHOLDER_NAME).onChange(event -> this.validateNameField()).build();
        this.nameErrorContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.lblNameError = null;
        ComponentBuilder.label((Composite)container).text("").height(2).build();
        ComponentBuilder.label((Composite)container).text(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_LABEL_TITLE).fillHorizontal().build();
        this.txtTitle = (TextField)ComponentBuilder.textField((Composite)container, (int)65536).fillHorizontal().height(24).borderRadius(8).width(500).placeholder(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_PLACEHOLDER_TITLE).onChange(event -> this.validateTitleField()).build();
        this.titleErrorContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.lblTitleError = null;
        ComponentBuilder.label((Composite)container).text("").height(2).build();
        return container;
    }

    private void validateUrlField() {
        String urlError = this.validateUrl();
        this.isUrlValid = urlError == null;
        boolean urlErrorChanged = this.updateErrorDisplay(urlError, this.lblUrlError, this.urlErrorContainer, () -> this.lblUrlError, label -> {
            Label label2 = this.lblUrlError = label;
        });
        if (urlErrorChanged && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().pack();
        }
        this.updateOkButtonState();
    }

    private void validateNameField() {
        String nameError = this.validateName();
        this.isNameValid = nameError == null;
        boolean nameErrorChanged = this.updateErrorDisplay(nameError, this.lblNameError, this.nameErrorContainer, () -> this.lblNameError, label -> {
            Label label2 = this.lblNameError = label;
        });
        if (nameErrorChanged && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().pack();
        }
        this.updateOkButtonState();
    }

    private void validateTitleField() {
        String titleError = this.validateTitle();
        this.isTitleValid = titleError == null;
        boolean titleErrorChanged = this.updateErrorDisplay(titleError, this.lblTitleError, this.titleErrorContainer, () -> this.lblTitleError, label -> {
            Label label2 = this.lblTitleError = label;
        });
        if (titleErrorChanged && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().pack();
        }
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        boolean valid;
        boolean bl = valid = this.isUrlValid && this.isNameValid && this.isTitleValid;
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(valid);
        }
    }

    private String validateUrl() {
        String url = this.txtServerUrl.getText().trim();
        if (StringUtils.isEmpty((CharSequence)url)) {
            return ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_URL_EMPTY;
        }
        if (!this.isValidUrl(url)) {
            return ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_URL_INVALID;
        }
        return null;
    }

    private String validateName() {
        String name = this.txtName.getText();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_NAME_EMPTY;
        }
        if (name.length() > 64) {
            return MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_NAME_TOO_LONG, name.length());
        }
        if (!name.matches("^[A-Za-z0-9_-]+$")) {
            return ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_NAME_INVALID;
        }
        if (this.agentManager != null) {
            try {
                boolean exists = this.agentManager.getMcpSetting(this.agentProfile).getServers().stream().anyMatch(s -> name.equalsIgnoreCase(s.getName()));
                if (exists) {
                    return ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_NAME_EXISTS;
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to check for duplicate MCP server name", (Throwable)e);
            }
        }
        return null;
    }

    private String validateTitle() {
        String title = this.txtTitle.getText();
        if (title.length() > 255) {
            return MessageFormat.format(ComposerStudioAssistConstants.DIALOG_MCP_SERVER_ERROR_TITLE_TOO_LONG, title.length());
        }
        return null;
    }

    private boolean updateErrorDisplay(String errorMessage, Label currentErrorLabel, Composite errorContainer, Supplier<Label> labelGetter, Consumer<Label> labelSetter) {
        boolean errorChanged = false;
        if (errorMessage != null && !errorMessage.isEmpty()) {
            Label errorLabel = labelGetter.get();
            if (errorLabel == null || errorLabel.isDisposed()) {
                Label newLabel = (Label)ComponentBuilder.label((Composite)errorContainer).text(errorMessage).fillHorizontal().color(ColorUtil.ERROR_TEXT_COLOR_LIGHTTHEME).build();
                labelSetter.accept(newLabel);
                errorChanged = true;
            } else {
                errorLabel.setText(errorMessage);
            }
            errorContainer.layout();
            if (errorContainer.getParent() != null) {
                errorContainer.getParent().layout();
            }
        } else {
            Label errorLabel = labelGetter.get();
            if (errorLabel != null && !errorLabel.isDisposed()) {
                errorLabel.dispose();
                labelSetter.accept(null);
                errorContainer.layout();
                if (errorContainer.getParent() != null) {
                    errorContainer.getParent().layout();
                }
                errorChanged = true;
            }
        }
        return errorChanged;
    }

    private boolean isValidUrl(String url) {
        try {
            URL u = new URL(url);
            String protocol = u.getProtocol();
            return protocol.equals("http") || protocol.equals("https");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private McpServerDefinition getMcpServerDefinition() {
        if (this.comboTransportType == null || this.comboTransportType.getSelectionIndex() < 0) {
            return null;
        }
        TransportType transportType = TransportType.fromDisplayName(this.comboTransportType.getText().trim());
        if (transportType == null) {
            return null;
        }
        return switch (transportType) {
            case TransportType.HTTP -> new McpHttpServerDefinition();
            case TransportType.SSE -> new McpSseServerDefinition();
            default -> null;
        };
    }

    protected void okPressed() {
        this.server = this.getMcpServerDefinition();
        if (this.server == null) {
            this.logger.error("Failed to add MCP server definition");
            return;
        }
        String serverUrl = this.txtServerUrl.getText().trim();
        String name = this.txtName.getText().trim();
        String title = this.txtTitle.getText().trim();
        this.server.setName(name);
        this.server.setTitle(title);
        McpServerDefinition mcpServerDefinition = this.server;
        if (mcpServerDefinition instanceof McpHttpServerDefinition) {
            McpHttpServerDefinition httpServer = (McpHttpServerDefinition)mcpServerDefinition;
            httpServer.setUrl(serverUrl);
        } else {
            McpServerDefinition mcpServerDefinition2 = this.server;
            if (mcpServerDefinition2 instanceof McpSseServerDefinition) {
                McpSseServerDefinition sseServer = (McpSseServerDefinition)mcpServerDefinition2;
                sseServer.setUrl(serverUrl);
            }
        }
        this.logger.info("Adding MCP Server - URL: {}, Name: {}, Title: {}", new Object[]{serverUrl, name, title});
        super.okPressed();
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    protected boolean isResizable() {
        return false;
    }

    protected int getShellStyle() {
        return super.getShellStyle() & 0xFFFFFFEF;
    }

    public McpServerDefinition getServer() {
        return this.server;
    }

    private static enum TransportType {
        HTTP("HTTP"),
        SSE("SSE");

        private final String displayName;

        private TransportType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public static TransportType fromDisplayName(String displayName) {
            TransportType[] transportTypeArray = TransportType.values();
            int n = transportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TransportType type = transportTypeArray[n2];
                if (type.getDisplayName().equalsIgnoreCase(displayName)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

