/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.dialog;

import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.ai.core.services.IProjectAgentProfilePreferences;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.components.impl.dialogs.CustomTitleAreaDialog;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class McpToolApprovalResetDialog
extends CustomTitleAreaDialog {
    private static final int TOOL_COLUMN_WIDTH = ComponentUtil.applyZoom((int)350);
    private static final int RESET_COLUMN_WIDTH = ComponentUtil.applyZoom((int)100);
    private static final int DIALOG_WIDTH = ComponentUtil.applyZoom((int)580);
    private static final int DIALOG_HEIGHT = ComponentUtil.applyZoom((int)480);
    private static final String KEY_TOGGLE_ALL_TOOL_SELECTION = "toggleAllToolSelection";
    private static final String KEY_MARKED_FOR_RESET = "markedForReset";
    private static final String KEY_CHECKBOX_WIDGET = "approvedToolCheckbox";
    private static final String BUILTIN_TOOL_ICON_PATH = "/icons/agent/builtin_tool_icon.png";
    private final Map<String, Table> serverToolTables = new HashMap<String, Table>();
    private AgentSetting agentSetting;
    private Listener drawTableHeaderListener;
    private int noOfResetTools = 0;
    private McpSetting mcpSetting;
    private final String projectLocation;
    private final List<String> agentProfileNames;
    private String selectedProfileName;
    private CCombo profileCombo;
    private ScrolledComposite scrolledComposite;
    private Composite scrollContent;
    @Inject
    private IAgentPreferences agentPreferences;
    @Inject
    private IProjectAgentProfilePreferences projectAgentProfilePreferences;

    public McpToolApprovalResetDialog(Shell parentShell, String projectLocation, List<String> agentProfileNames, String initialProfileName) {
        super(parentShell);
        this.projectLocation = projectLocation;
        this.agentProfileNames = agentProfileNames != null ? agentProfileNames : List.of();
        this.selectedProfileName = StringUtils.trimToNull((String)initialProfileName);
    }

    @PostConstruct
    public void initialize() {
        this.loadSettingsForSelection();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_TITLE);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point preferredSize = this.getShell().computeSize(-1, -1);
        int height = Math.min(preferredSize.y, DIALOG_HEIGHT);
        return new Point(DIALOG_WIDTH, height);
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(this.convertHorizontalDLUsToPixels(7), this.convertVerticalDLUsToPixels(7)).gridVerticalSpacing(this.convertVerticalDLUsToPixels(4)).gridHorizontalSpacing(this.convertHorizontalDLUsToPixels(4)).build();
        this.createContentArea(container);
        this.getShell().getDisplay().asyncExec(() -> {
            if (this.getButton(0) != null) {
                this.getButton(0).setText(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_RESET_APPROVAL_BUTTON);
                this.getButton(0).setEnabled(true);
                this.updateResetApprovalButtonState();
            }
        });
        return container;
    }

    protected Composite createContentArea(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().fillVertical().build();
        this.createDescription(container);
        this.createProfileSelector(container);
        this.createApprovedToolsContent(container);
        return container;
    }

    private void createProfileSelector(Composite parent) {
        int idx;
        Composite selectorContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).build();
        ComponentBuilder.label((Composite)selectorContainer).text("Select agent profile").build();
        ComponentBuilder.label((Composite)selectorContainer).fillHorizontal().build();
        this.profileCombo = new CCombo(selectorContainer, 12);
        this.profileCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.profileCombo.add("Generic Agent");
        for (String name : this.agentProfileNames) {
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            this.profileCombo.add(name);
        }
        int initialIndex = 0;
        if (StringUtils.isNotBlank((CharSequence)this.selectedProfileName) && (idx = this.profileCombo.indexOf(this.selectedProfileName)) >= 0) {
            initialIndex = idx;
        }
        this.profileCombo.select(initialIndex);
        this.selectedProfileName = initialIndex == 0 ? null : this.profileCombo.getText();
        this.profileCombo.addListener(13, e -> {
            this.selectedProfileName = this.profileCombo.getSelectionIndex() <= 0 ? null : this.profileCombo.getText();
            this.loadSettingsForSelection();
            this.rebuildApprovedToolsContent();
        });
    }

    private void createDescription(Composite parent) {
        StyledText description = new StyledText(parent, 72);
        description.setText(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_DESCRIPTION);
        description.setEditable(false);
        description.setBackground(parent.getBackground());
        int start = description.getText().indexOf(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_DESCRIPTION_BOLD_TEXT);
        if (start >= 0) {
            StyleRange style = new StyleRange();
            style.start = start;
            style.length = ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_DESCRIPTION_BOLD_TEXT.length();
            style.fontStyle = 1;
            description.setStyleRange(style);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)description);
    }

    private void createApprovedToolsContent(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.scrolledComposite);
        this.scrollContent = (Composite)ComponentBuilder.gridContainer((Composite)this.scrolledComposite).build();
        this.scrolledComposite.setContent((Control)this.scrollContent);
        this.rebuildApprovedToolsContent();
    }

    private void rebuildApprovedToolsContent() {
        if (this.scrolledComposite == null || this.scrolledComposite.isDisposed()) {
            return;
        }
        if (this.scrollContent == null || this.scrollContent.isDisposed()) {
            return;
        }
        this.serverToolTables.clear();
        Control[] controlArray = this.scrollContent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (this.agentSetting == null || this.agentSetting.getMcpServerSettings() == null || this.mcpSetting == null || this.mcpSetting.getServers() == null) {
            this.scrollContent.setSize(this.scrollContent.computeSize(-1, -1));
            this.scrolledComposite.setExpandHorizontal(true);
            this.scrolledComposite.setExpandVertical(true);
            this.scrolledComposite.setMinSize(this.scrollContent.computeSize(-1, -1));
            this.scrolledComposite.layout(true, true);
            return;
        }
        this.agentSetting.getMcpServerSettings().stream().filter(serverSetting -> serverSetting.getApprovedTools() != null && !serverSetting.getApprovedTools().isEmpty()).sorted((firstServerSetting, secondServerSetting) -> {
            McpServerDefinition firstServerDefinition = this.mcpSetting.getServers().stream().filter(serverDef -> serverDef.getName().equals(firstServerSetting.getServer())).findFirst().orElse(null);
            McpServerDefinition secondServerDefinition = this.mcpSetting.getServers().stream().filter(serverDef -> serverDef.getName().equals(secondServerSetting.getServer())).findFirst().orElse(null);
            boolean isFirstServerBuiltin = firstServerDefinition != null && firstServerDefinition.isBuiltin();
            boolean isSecondServerBuiltin = secondServerDefinition != null && secondServerDefinition.isBuiltin();
            return Boolean.compare(isSecondServerBuiltin, isFirstServerBuiltin);
        }).forEach(serverSetting -> {
            McpServerDefinition matchingServerDefinition = this.mcpSetting.getServers().stream().filter(serverDef -> serverDef.getName().equals(serverSetting.getServer())).findFirst().orElse(null);
            this.createMcpServerSettingSection(this.scrollContent, (McpServerSetting)serverSetting, matchingServerDefinition);
        });
        this.scrollContent.setSize(this.scrollContent.computeSize(-1, -1));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.scrollContent.computeSize(-1, -1));
        this.scrolledComposite.layout(true, true);
        this.updateResetApprovalButtonState();
    }

    private void createMcpServerSettingSection(Composite parent, McpServerSetting serverSetting, McpServerDefinition serverDefinition) {
        boolean hasApprovedTools;
        boolean bl = hasApprovedTools = serverSetting.getApprovedTools() != null && !serverSetting.getApprovedTools().isEmpty();
        if (!hasApprovedTools) {
            return;
        }
        String displayServerName = serverDefinition == null || StringUtils.isBlank((CharSequence)serverDefinition.getTitle()) ? serverSetting.getServer() : serverDefinition.getTitle();
        Composite serverHeaderContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)3).fillHorizontal().marginTop(8).build();
        ComponentBuilder.label((Composite)serverHeaderContainer).text(displayServerName).bold().build();
        if (serverDefinition != null && serverDefinition.isBuiltin()) {
            Image builtinServerIcon = new Image((Device)parent.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream(BUILTIN_TOOL_ICON_PATH));
            ComponentBuilder.label((Composite)serverHeaderContainer).image(builtinServerIcon).build();
            serverHeaderContainer.addDisposeListener(e -> {
                if (builtinServerIcon != null && !builtinServerIcon.isDisposed()) {
                    builtinServerIcon.dispose();
                }
            });
        }
        Link toggleSelection = new Link(serverHeaderContainer, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)toggleSelection);
        Table toolTable = this.createApprovedToolsTable(parent, serverSetting.getServer(), serverSetting);
        toolTable.setLayoutData((Object)new GridData(4, 4, true, true));
        toolTable.setData(KEY_TOGGLE_ALL_TOOL_SELECTION, (Object)toggleSelection);
        this.updateToggleSelectionText(toolTable);
        this.attachToggleSelectionListener(toggleSelection, toolTable);
    }

    private Table createApprovedToolsTable(Composite parent, String serverIdentifier, McpServerSetting serverSetting) {
        List approvedTools = serverSetting.getApprovedTools();
        Table table = new Table(parent, 65536);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns(table);
        approvedTools.forEach(tool -> this.createToolRow(table, (String)tool));
        this.attachDrawTableHeaderListener(table);
        this.serverToolTables.put(serverIdentifier, table);
        return table;
    }

    private void createColumns(Table table) {
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn toolColumn = new TableColumn(table, 0);
        toolColumn.setText(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_APPROVED_TOOL_COLUMN);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(80, TOOL_COLUMN_WIDTH, true));
        TableColumn resetColumn = new TableColumn(table, 0x1000000);
        resetColumn.setText(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_RESET_COLUMN);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, RESET_COLUMN_WIDTH, true));
    }

    private void createToolRow(Table table, String approvedToolName) {
        TableItem item = new TableItem(table, 0);
        item.setText(0, approvedToolName);
        Button checkbox = (Button)ComponentBuilder.button((Composite)table, (int)32).build();
        checkbox.setSelection(true);
        item.setData(KEY_MARKED_FOR_RESET, (Object)true);
        item.setData(KEY_CHECKBOX_WIDGET, (Object)checkbox);
        this.placeCheckboxInTable(table, item, checkbox);
        this.attachCheckboxListener(table, item, checkbox);
    }

    private void placeCheckboxInTable(Table table, TableItem item, Button checkbox) {
        Point size = checkbox.computeSize(-1, -1);
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = false;
        editor.grabVertical = false;
        editor.horizontalAlignment = 0x1000000;
        editor.verticalAlignment = 0x1000000;
        editor.minimumWidth = size.x;
        editor.minimumHeight = size.y;
        editor.setEditor((Control)checkbox, item, 1);
        TableColumn column = table.getColumn(1);
        int columnWidth = column.getWidth();
        int offsetX = (columnWidth - size.x) / 2;
        checkbox.setBounds(offsetX, 0, size.x, size.y);
    }

    private void attachDrawTableHeaderListener(Table table) {
        if (this.drawTableHeaderListener == null) {
            this.drawTableHeaderListener = event -> {
                int headerHeight = table.getHeaderHeight();
                if (headerHeight <= 0) {
                    return;
                }
                Rectangle clientArea = table.getClientArea();
                event.gc.setForeground(event.display.getSystemColor(18));
                event.gc.drawLine(clientArea.x, headerHeight, clientArea.x + clientArea.width, headerHeight);
            };
        }
        table.addListener(42, this.drawTableHeaderListener);
    }

    private void attachCheckboxListener(Table table, TableItem item, Button checkbox) {
        checkbox.addListener(13, e -> {
            boolean markedForReset = checkbox.getSelection();
            item.setData(KEY_MARKED_FOR_RESET, (Object)markedForReset);
            this.updateToggleSelectionText(table);
            this.updateResetApprovalButtonState();
        });
    }

    private void attachToggleSelectionListener(Link toggleSelection, Table toolTable) {
        toggleSelection.addListener(13, event -> {
            boolean isSelectAll = event.text != null && event.text.equalsIgnoreCase(ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_SELECT_ALL_TEXT);
            this.toggleAll(toolTable, isSelectAll, toggleSelection);
        });
    }

    private void toggleAll(Table table, boolean selectAll, Link link) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Button checkbox = (Button)item.getData(KEY_CHECKBOX_WIDGET);
            if (checkbox != null && !checkbox.isDisposed() && checkbox.getSelection() != selectAll) {
                checkbox.setSelection(selectAll);
                checkbox.notifyListeners(13, null);
            }
            ++n2;
        }
        link.setText(this.getToggleSelectionText(selectAll));
    }

    private void updateToggleSelectionText(Table table) {
        Link link = (Link)table.getData(KEY_TOGGLE_ALL_TOOL_SELECTION);
        if (link != null) {
            link.setText(this.getToggleSelectionText(this.areAllMarkedForReset(table)));
        }
    }

    private String getToggleSelectionText(boolean allSelected) {
        return "<a>" + (allSelected ? ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_DESELECT_ALL_TEXT : ComposerStudioAssistConstants.DIALOG_MCP_RESET_APPROVED_TOOL_SELECT_ALL_TEXT) + "</a>";
    }

    private void updateResetApprovalButtonState() {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!this.areAllStillApproved());
        }
    }

    private boolean areAllMarkedForReset(Table table) {
        return Arrays.stream(table.getItems()).map(item -> (Button)item.getData(KEY_CHECKBOX_WIDGET)).filter(checkbox -> checkbox != null && !checkbox.isDisposed()).allMatch(Button::getSelection);
    }

    private boolean areAllStillApproved() {
        return this.serverToolTables.values().stream().flatMap(table -> Arrays.stream(table.getItems())).map(item -> (Button)item.getData(KEY_CHECKBOX_WIDGET)).filter(checkbox -> checkbox != null && !checkbox.isDisposed()).noneMatch(Button::getSelection);
    }

    private void loadSettingsForSelection() {
        if (StringUtils.isBlank((CharSequence)this.selectedProfileName)) {
            this.mcpSetting = this.agentPreferences.loadMcpSetting();
            this.agentSetting = this.agentPreferences.loadAgentSetting();
            return;
        }
        if (this.projectAgentProfilePreferences == null || StringUtils.isBlank((CharSequence)this.projectLocation)) {
            this.mcpSetting = this.agentPreferences.loadMcpSetting();
            this.agentSetting = this.agentPreferences.loadAgentSetting();
            return;
        }
        this.mcpSetting = this.projectAgentProfilePreferences.loadProfileMcpSetting(this.projectLocation, this.selectedProfileName);
        this.agentSetting = this.projectAgentProfilePreferences.loadProfileAgentSetting(this.projectLocation, this.selectedProfileName);
    }

    protected void okPressed() {
        this.updateAgentSetting();
        super.okPressed();
    }

    private void updateAgentSetting() {
        this.noOfResetTools = 0;
        this.ensureAgentSetting();
        this.serverToolTables.forEach((server, table) -> {
            List<String> approvedTools = this.collectStillApprovedTools((Table)table);
            this.updateServerSettings((String)server, approvedTools);
            this.collectResetTools((Table)table);
        });
    }

    private void ensureAgentSetting() {
        if (this.agentSetting == null) {
            this.agentSetting = new AgentSetting();
        }
        if (this.agentSetting.getMcpServerSettings() == null) {
            this.agentSetting.setMcpServerSettings(new ArrayList());
        }
    }

    private List<String> collectStillApprovedTools(Table table) {
        return Arrays.stream(table.getItems()).filter(item -> Boolean.FALSE.equals(item.getData(KEY_MARKED_FOR_RESET))).map(item -> item.getText(0)).toList();
    }

    private void collectResetTools(Table table) {
        int resetCount = (int)Arrays.stream(table.getItems()).filter(item -> Boolean.TRUE.equals(item.getData(KEY_MARKED_FOR_RESET))).count();
        this.noOfResetTools += resetCount;
    }

    private void updateServerSettings(String serverName, List<String> approvedTools) {
        McpServerSetting serverSetting = this.findServerSetting(serverName);
        if (serverSetting != null) {
            serverSetting.setApprovedTools(approvedTools);
        } else {
            McpServerSetting newSetting = new McpServerSetting(serverName);
            newSetting.setApprovedTools(approvedTools);
            this.agentSetting.getMcpServerSettings().add(newSetting);
        }
    }

    private McpServerSetting findServerSetting(String serverName) {
        return this.agentSetting.getMcpServerSettings().stream().filter(s -> serverName.equals(s.getServer())).findFirst().orElse(null);
    }

    protected void registerControlModifyListeners() {
    }

    protected void setInput() {
    }

    public boolean close() {
        if (this.drawTableHeaderListener != null) {
            this.serverToolTables.values().forEach(table -> table.removeListener(42, this.drawTableHeaderListener));
            this.drawTableHeaderListener = null;
        }
        return super.close();
    }

    public AgentSetting getAgentSetting() {
        return this.agentSetting;
    }

    public int getNoOfResetTools() {
        return this.noOfResetTools;
    }

    public String getSelectedProfileName() {
        return this.selectedProfileName;
    }
}

