/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.diff;

import com.kms.katalon.ai.core.model.agent.Entity;
import com.kms.katalon.ai.core.model.agent.EntityModification;
import com.kms.katalon.composer.components.util.ColorUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistDiffEditorInput
extends CompareEditorInput {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistDiffEditorInput.class);
    private static final String MARK_AS_REVIEW_ICON_PATH = "/icons/agent/check_mark.png";
    private static final String UNDO_ICON_PATH = "/icons/agent/undo.png";
    private final EntityModification modification;
    private final DiffNode diffNode;
    private final Consumer<Entity> undoHandler;
    private final Consumer<Entity> markReviewedHandler;
    private final IEventBroker eventBroker;
    private final String entityId;
    private EventHandler closeDiffEventHandler;
    private Image undoIcon;
    private Image markReviewIcon;

    public StudioAssistDiffEditorInput(EntityModification modification, String originalContent, String currentContent, Consumer<Entity> undoHandler, Consumer<Entity> markReviewedHandler, IEventBroker eventBroker) {
        super(StudioAssistDiffEditorInput.createConfiguration());
        this.modification = Objects.requireNonNull(modification, "Entity modification is required");
        this.undoHandler = Objects.requireNonNull(undoHandler, "Undo handler is required");
        this.markReviewedHandler = Objects.requireNonNull(markReviewedHandler, "Mark reviewed handler is required");
        this.eventBroker = eventBroker;
        this.entityId = modification.getEntity() != null ? modification.getEntity().getId() : null;
        this.diffNode = new DiffNode((ITypedElement)new StringElement("Original", StringUtils.defaultString((String)currentContent)), (ITypedElement)new StringElement("Proposed Changes", StringUtils.defaultString((String)originalContent)));
        this.subscribeCloseEvent();
    }

    private static CompareConfiguration createConfiguration() {
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftLabel("Proposed Changes");
        config.setRightLabel("Original");
        config.setLeftEditable(false);
        config.setRightEditable(false);
        config.setProperty("MIRRORED", (Object)Boolean.TRUE);
        return config;
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        return this.diffNode;
    }

    public String getTitle() {
        Entity entity = this.modification.getEntity();
        return entity != null ? "Compare: " + entity.getId() : "Compare";
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        TextMergeViewer viewer = new TextMergeViewer(container, 2048, this.getCompareConfiguration());
        Control mergeControl = viewer.getControl();
        mergeControl.setLayoutData((Object)new GridData(4, 4, true, true));
        mergeControl.setFont(JFaceResources.getTextFont());
        viewer.setInput((Object)this.diffNode);
        this.resetPaneBackgrounds(mergeControl);
        Composite buttonBar = new Composite(container, 0);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        buttonBar.setLayout((Layout)new GridLayout(2, false));
        this.undoIcon = new Image((Device)parent.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream(UNDO_ICON_PATH));
        this.createActionButton(buttonBar, "Undo", this.undoIcon, ColorUtil.REMOVE_BUTTON_COLOR, () -> this.invokeAndClose(this.undoHandler));
        this.markReviewIcon = new Image((Device)parent.getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream(MARK_AS_REVIEW_ICON_PATH));
        this.createActionButton(buttonBar, "Mark as Reviewed", this.markReviewIcon, ColorUtil.PRIMARY_COLOR, () -> this.invokeAndClose(this.markReviewedHandler));
        return container;
    }

    public String getEntityId() {
        return this.entityId;
    }

    private void createActionButton(Composite parent, String text, Image icon, Color color, Runnable action) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setBackground(color);
        button.setForeground(Display.getCurrent().getSystemColor(1));
        if (icon != null) {
            button.setImage(icon);
        }
        button.setAlignment(16384);
        button.addListener(13, event -> {
            try {
                action.run();
            }
            catch (Exception ex) {
                logger.error("Error executing action '{}' for entityId={}", new Object[]{text, this.modification.getEntity() != null ? this.modification.getEntity().getId() : "unknown", ex});
            }
        });
    }

    private void invokeAndClose(Consumer<Entity> handler) {
        Entity entity = this.modification.getEntity();
        try {
            handler.accept(entity);
        }
        finally {
            this.closeCompareEditor();
        }
    }

    private void closeCompareEditor() {
        Display.getDefault().asyncExec(() -> {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                try {
                    IEditorInput input = reference.getEditorInput();
                    if (input == this) {
                        IEditorPart editor = reference.getEditor(false);
                        if (editor != null) {
                            page.closeEditor(editor, false);
                        } else {
                            page.closeEditors(new IEditorReference[]{reference}, false);
                        }
                        return;
                    }
                }
                catch (PartInitException e) {
                    logger.warn("Failed to access editor input while closing diff viewer", (Throwable)e);
                }
                ++n2;
            }
        });
    }

    private void resetPaneBackgrounds(Control root) {
        Display display = root.getDisplay();
        Color defaultBackground = display.getSystemColor(1);
        ArrayList<StyledText> panes = new ArrayList<StyledText>();
        this.collectStyledTexts(root, panes);
        for (StyledText pane : panes) {
            pane.setBackground(defaultBackground);
        }
    }

    private void collectStyledTexts(Control control, List<StyledText> collector) {
        if (control instanceof StyledText) {
            StyledText styledText = (StyledText)control;
            collector.add(styledText);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.collectStyledTexts(child, collector);
                ++n2;
            }
        }
    }

    public void open() {
        CompareUI.openCompareEditor((CompareEditorInput)this);
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.subscribeCloseEvent();
    }

    protected void handleDispose() {
        this.unsubscribeCloseEvent();
        if (this.undoIcon != null && !this.undoIcon.isDisposed()) {
            this.undoIcon.dispose();
        }
        if (this.markReviewIcon != null && !this.markReviewIcon.isDisposed()) {
            this.markReviewIcon.dispose();
        }
        super.handleDispose();
    }

    private void subscribeCloseEvent() {
        if (this.eventBroker == null || StringUtils.isBlank((CharSequence)this.entityId) || this.closeDiffEventHandler != null) {
            return;
        }
        this.closeDiffEventHandler = event -> {
            Object data = event.getProperty("org.eclipse.e4.data");
            if (this.entityId.equals(data)) {
                this.closeCompareEditor();
            }
        };
        this.eventBroker.subscribe("ON_STUDIO_ASSIST_CLOSE_ENTITY_DIFF", this.closeDiffEventHandler);
    }

    private void unsubscribeCloseEvent() {
        if (this.eventBroker != null && this.closeDiffEventHandler != null) {
            this.eventBroker.unsubscribe(this.closeDiffEventHandler);
            this.closeDiffEventHandler = null;
        }
    }

    private record StringElement(String name, String content) implements ITypedElement,
    IStreamContentAccessor
    {
        public String getName() {
            return this.name;
        }

        public String getType() {
            return "txt";
        }

        public Image getImage() {
            return null;
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
        }
    }
}

