/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.part;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.kms.katalon.ai.core.presentation.IStudioAssistChatNavigator;
import com.kms.katalon.composer.ai.studioassist.part.StudioAssistPartListener;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.webserver.WebViewController;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatPart
extends StudioAssistPartListener
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatPart.class);
    @Inject
    EPartService partService;
    @Inject
    IEventBroker eventBroker;
    @Inject
    private IStudioAssistChatNavigator studioAssistChatNavigator;
    private Composite mainComposite;

    @PostConstruct
    public void render(Composite parent) {
        this.mainComposite = (Composite)ComponentBuilder.fillContainer((Composite)parent).build();
        try {
            URIBuilder uriBuilder = WebViewController.getInstance().buildURIBuilder("StudioAssist.html");
            String url = uriBuilder.toString();
            this.logger.info("studio assist url -> {}", (Object)url);
            this.browser = (Browser)ComponentBuilder.browser((Composite)this.mainComposite).url(url).defaultBrowserConfig().fill().build();
            this.browser.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x400000) != 0 && e.keyCode == 97) {
                        StudioAssistChatPart.this.browser.execute("document.execCommand('selectAll');");
                        e.doit = false;
                    }
                }
            });
            ComponentUtil.onBrowserLoaded((Browser)this.browser, br -> {
                BrowserFunctionUtil.bind((Browser)br);
                this.studioAssistChatNavigator.init(br);
            });
        }
        catch (URISyntaxException e) {
            this.logger.error("Fail while getting URL to render StudioAssist Chat Part.", (Throwable)e);
        }
        this.registerListener();
    }

    private void registerListener() {
        this.partService.addPartListener((IPartListener)this);
    }

    @PreDestroy
    public void onDestroy() {
        try {
            this.eventBroker.send("ON_STUDIO_ASSIST_CLOSE_CHAT", null);
            this.close();
        }
        catch (Exception e) {
            this.logger.error("Exception while onDestroy processing", (Throwable)e);
        }
    }

    @Focus
    public void onFocus() {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite)) {
            this.mainComposite.forceFocus();
        }
    }

    @Override
    public void close() throws Exception {
        try {
            MUIElement toolControl = this.modelService.find("com.kms.katalon.partstack.rightsidebar(com.kms.katalon.composer.window.main).(com.kms.katalon.composer.perspective.keyword)", (MUIElement)this.application);
            if (toolControl != null) {
                toolControl.setVisible(false);
            }
            this.studioAssistChatNavigator.close();
            this.partService.removePartListener((IPartListener)this);
            this.mainComposite.dispose();
            this.browser.dispose();
            this.referenceContextController.clear();
        }
        catch (Exception e) {
            this.logger.error("Exception while close processing", (Throwable)e);
        }
    }
}

