/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedAzureOpenAiPage;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedGeminiPage;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedOpenAiCompatiblePage;
import com.kms.katalon.composer.ai.studioassist.preference.ManagedOpenAiPage;
import com.kms.katalon.composer.ai.studioassist.preference.UserSettingPage;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.session.core.services.ISessionController;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIConfigurationPage
extends PreferencePage {
    private Logger logger = LoggerFactory.getLogger(AIConfigurationPage.class);
    @Inject
    private IEclipseContext context;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    @Inject
    private ISessionController sessionController;
    private Composite parentComponent;
    private AIConfigurationComponent configComponent;
    private Listener compositeResizeListener;

    protected Control createContents(Composite parent) {
        this.parentComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        if (!this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            this.setValid(true);
            return parent;
        }
        ComponentBuilder.label((Composite)this.parentComponent).text("AI service configuration").marginBottom(0).build();
        AiConfigPolicy aiConfigPolicy = this.sessionController.getAiConfigPolicy();
        AiConfigPolicyType aiConfigPolicyType = aiConfigPolicy.getAiConfigPolicyType();
        switch (aiConfigPolicyType) {
            case ADMINISTRATION_MANAGED_AZURE_OPENAI: {
                this.configComponent = new ManagedAzureOpenAiPage(this.parentComponent, aiConfigPolicy);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI: {
                this.configComponent = new ManagedOpenAiPage(this.parentComponent, aiConfigPolicy);
                break;
            }
            case ADMINISTRATION_MANAGED_GEMINI: {
                this.configComponent = new ManagedGeminiPage(this.parentComponent, aiConfigPolicy);
                break;
            }
            case ADMINISTRATION_MANAGED_OPENAI_COMPATIBLE: {
                this.configComponent = new ManagedOpenAiCompatiblePage(this.parentComponent, aiConfigPolicy);
                break;
            }
            default: {
                this.configComponent = new UserSettingPage(this.parentComponent, aiConfigPolicy);
            }
        }
        try {
            ContextInjectionFactory.inject((Object)this.configComponent, (IEclipseContext)this.context);
            this.configComponent.setMainPreferencePage(this);
            this.configComponent.loadConfig();
        }
        catch (StudioAssistLoadingConfigException e) {
            this.logger.error("Failed to load AI Configuration", (Throwable)e);
            this.showErrorDialog(ComposerStudioAssistConstants.ERROR_CANNOT_LOAD_CONFIG);
        }
        ComponentBuilder.label((Composite)this.parentComponent).text("*Apply to all AI features").italic().color(ColorUtil.themeColor((Color)ColorUtil.NOTE_WHITE_THEME, (Color)ColorUtil.NOTE_DARK_THEME)).marginBottom(0).build();
        this.setValid(true);
        ScrolledComposite scrolledComposite = DialogUtil.findScrolledComposite((Control)this.parentComponent);
        this.compositeResizeListener = DialogUtil.autoUpdateScrolledCompositeListener((ScrolledComposite)scrolledComposite);
        this.parentComponent.addListener(11, this.compositeResizeListener);
        return parent;
    }

    protected void performDefaults() {
        if (!this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT);
            return;
        }
        super.performDefaults();
        this.configComponent.resetConfig();
        this.setErrorMessage(null);
    }

    protected void performApply() {
        if (this.parentComponent == null || this.parentComponent.isDisposed() || this.configComponent == null) {
            return;
        }
        try {
            this.configComponent.saveConfig();
        }
        catch (StudioAssistSavingConfigException e) {
            LoggerSingleton.logError((Throwable)e);
            this.showErrorDialog(ComposerStudioAssistConstants.ERROR_CANNOT_SAVE_CONFIG);
        }
        this.eventBroker.post("ON_SA_SETTING_CHANGE", null);
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void dispose() {
        if (this.compositeResizeListener != null) {
            this.parentComponent.removeListener(11, this.compositeResizeListener);
            this.compositeResizeListener = null;
        }
        super.dispose();
    }

    private void showErrorDialog(String errorMessage) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MessageDialog.openError((Shell)window.getShell(), (String)ComposerStudioAssistConstants.ERROR, (String)errorMessage);
    }
}

