/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.AwsBedrockConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class AwsBedrockConfigComponent
extends AIConfigurationComponent {
    private Text awsAccessKey;
    private Text awsSecretKey;
    private Text awsSessionToken;
    private Text awsRegion;
    private Text model;
    private Text maxToken;
    private final String AWS_ACCESS_KEY = "AWS access key";
    private final String AWS_SECRET_KEY = "AWS secret key";
    private final String AWS_SESSION_TOKEN = "AWS session token";
    private final String AWS_REGION = "AWS region";
    private final String MODEL = "Model";
    private final String MAX_TOKEN = "Max completion token";

    public AwsBedrockConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite outerComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).fillHorizontal().build();
        Composite component = (Composite)ComponentBuilder.group((Composite)outerComponent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("AWS access key*").build();
        this.awsAccessKey = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().onChange(event -> {
            boolean bl = this.validateNotBlank("AWS access key", this.awsAccessKey.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("AWS secret key*").build();
        this.awsSecretKey = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().onChange(event -> {
            boolean bl = this.validateNotBlank("AWS secret key", this.awsSecretKey.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("AWS session token*").build();
        this.awsSessionToken = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().onChange(event -> {
            boolean bl = this.validateNotBlank("AWS session token", this.awsSessionToken.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("AWS region*").build();
        this.awsRegion = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("AWS region", this.awsRegion.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Model*").build();
        this.model = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Model", this.model.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.maxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.maxToken.getText(), true)).build();
        this.content = outerComponent;
        return outerComponent;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
        boolean hasChosenAwsBedrock = type == LlmConfigType.AWS_BEDROCK;
        this.displayContent(hasChosenAwsBedrock);
        if (hasChosenAwsBedrock) {
            this.resetMessage(hasChosenAwsBedrock);
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean usingAwsBedrockConfig = config instanceof AwsBedrockConfig;
        if (usingAwsBedrockConfig) {
            AwsBedrockConfig awsBedrockConfig = (AwsBedrockConfig)config;
            this.awsAccessKey.setText(awsBedrockConfig.getAwsAccessKey());
            this.awsSecretKey.setText(awsBedrockConfig.getAwsSecretKey());
            this.awsSessionToken.setText(awsBedrockConfig.getAwsSessionToken());
            this.awsRegion.setText(awsBedrockConfig.getAwsRegion());
            this.model.setText(awsBedrockConfig.getModel());
            this.maxToken.setText(Integer.toString(awsBedrockConfig.getMaxToken()));
        } else {
            this.awsRegion.setText("us-east-1");
            this.model.setText("anthropic.claude-3-sonnet-20240229-v1:0");
            this.maxToken.setText(Integer.toString(16000));
        }
        this.displayContent(usingAwsBedrockConfig);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        AwsBedrockConfig awsBedrockConfig = new AwsBedrockConfig();
        awsBedrockConfig.setAwsAccessKey(this.awsAccessKey.getText());
        awsBedrockConfig.setAwsSecretKey(this.awsSecretKey.getText());
        awsBedrockConfig.setAwsSessionToken(this.awsSessionToken.getText());
        awsBedrockConfig.setAwsRegion(this.awsRegion.getText());
        String modelName = this.model.getText().trim();
        if (StringUtils.isBlank((CharSequence)modelName)) {
            modelName = "anthropic.claude-3-sonnet-20240229-v1:0";
        }
        awsBedrockConfig.setModel(modelName);
        String rawMaxToken = this.maxToken.getText();
        if (StringUtils.isNotBlank((CharSequence)rawMaxToken)) {
            awsBedrockConfig.setMaxToken(Integer.valueOf(rawMaxToken).intValue());
        } else {
            awsBedrockConfig.setMaxToken(16000);
        }
        this.controller.saveConfig((StudioAssistConfig)awsBedrockConfig);
    }

    @Override
    public void resetConfig() {
        this.awsAccessKey.setText("");
        this.awsSecretKey.setText("");
        this.awsSessionToken.setText("");
        this.awsRegion.setText("us-east-1");
        this.model.setText("anthropic.claude-3-sonnet-20240229-v1:0");
        this.maxToken.setText(String.valueOf(16000));
        this.displayContent(false);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("AWS access key", false);
        this.validationList.put("AWS secret key", false);
        this.validationList.put("AWS session token", false);
        this.validationList.put("AWS region", false);
        this.validationList.put("Model", false);
        this.validationList.put("Max completion token", false);
    }
}

