/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.GeminiConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class GeminiConfigComponent
extends AIConfigurationComponent {
    private Text geminiBaseUrl;
    private Text geminiAPIKey;
    private Text geminiModel;
    private Text geminiMaxToken;
    private final String BASE_URL = "Base URL";
    private final String API_KEY = "API key";
    private final String MODEL = "Model";
    private final String MAX_TOKEN = "Max completion token";

    public GeminiConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite outerComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).fillHorizontal().build();
        Composite component = (Composite)ComponentBuilder.group((Composite)outerComponent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Base URL*").build();
        this.geminiBaseUrl = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Base URL", this.geminiBaseUrl.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("API key*").build();
        this.geminiAPIKey = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().onChange(event -> {
            boolean bl = this.validateNotBlank("API key", this.geminiAPIKey.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Model*").build();
        this.geminiModel = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Model", this.geminiModel.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.geminiMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.geminiMaxToken.getText(), true)).build();
        this.content = outerComponent;
        return outerComponent;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
        boolean hasChosenGemini = type == LlmConfigType.GEMINI;
        this.displayContent(hasChosenGemini);
        if (hasChosenGemini) {
            this.resetMessage(hasChosenGemini);
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean usingGemini = config instanceof GeminiConfig;
        if (usingGemini) {
            GeminiConfig geminiConfig = (GeminiConfig)config;
            this.geminiBaseUrl.setText(geminiConfig.getBaseUrl());
            this.geminiAPIKey.setText(geminiConfig.getApiKey());
            this.geminiModel.setText(geminiConfig.getModel());
            this.geminiMaxToken.setText(Long.toString(geminiConfig.getMaxToken()));
        } else {
            this.geminiBaseUrl.setText("https://generativelanguage.googleapis.com/v1beta");
            this.geminiModel.setText("gemini-2.5-flash");
            this.geminiMaxToken.setText(Integer.toString(16000));
        }
        this.displayContent(usingGemini);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        GeminiConfig geminiConfig = new GeminiConfig();
        geminiConfig.setBaseUrl(this.geminiBaseUrl.getText().trim());
        geminiConfig.setApiKey(this.geminiAPIKey.getText().trim());
        geminiConfig.setModel(this.geminiModel.getText().trim());
        geminiConfig.setMaxToken(Integer.valueOf(this.geminiMaxToken.getText().trim()).intValue());
        this.controller.saveConfig((StudioAssistConfig)geminiConfig);
    }

    @Override
    public void resetConfig() {
        this.geminiBaseUrl.setText("https://generativelanguage.googleapis.com/v1beta");
        this.geminiAPIKey.setText("");
        this.geminiModel.setText("gemini-2.5-flash");
        this.geminiMaxToken.setText(Integer.toString(16000));
        this.displayContent(false);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Base URL", false);
        this.validationList.put("API key", false);
        this.validationList.put("Max completion token", false);
        this.validationList.put("Model", false);
    }
}

