/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.GenAIConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.AiConfigPolicyType;
import com.kms.katalon.session.services.SessionController;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class GenAIConfigComponent
extends AIConfigurationComponent {
    private Link link;
    private Label label;

    public GenAIConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
        boolean useGenAi;
        boolean bl = useGenAi = type == LlmConfigType.GEN_AI;
        if (useGenAi) {
            this.validateGenAIService();
        }
        this.displayContent(useGenAi);
    }

    @Override
    protected Composite createContent(Composite parent) {
        boolean isAIDisabled;
        Composite outerComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).margin(0).fillHorizontal().build();
        Composite component = (Composite)ComponentBuilder.gridContainer((Composite)outerComponent, (int)1).gridLayout(1).fillHorizontal().margin(0).gridSpacing(0).build();
        boolean isOnPrem = !ApplicationInfo.getLoginMethod().equals((Object)LoginMethod.SSO);
        boolean bl = isAIDisabled = this.aiConfigPolicy.getAiConfigPolicyType() == AiConfigPolicyType.AI_DISABLED;
        if (isOnPrem) {
            this.label = (Label)ComponentBuilder.label((Composite)component).italic().build();
            this.label.setText("Not available for on-premise and offline users.");
        } else if (isAIDisabled && !isOnPrem) {
            this.link = (Link)ComponentBuilder.link((Composite)component).italic().build();
            String messageOnDisableKatalonAI = MessageFormat.format("<a href=\"{0}/enable-ai-settings?accountId={1}\">Contact account owner</a> to activate free access", ApplicationInfo.getMyServerUrl(), SessionController.getInstance().getSession().getOrganization().getAccountId().toString());
            this.link.setText(messageOnDisableKatalonAI);
        }
        this.content = outerComponent;
        return outerComponent;
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean useGenAiConfig = config instanceof GenAIConfig;
        this.displayContent(useGenAiConfig);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        GenAIConfig genAIConfig = new GenAIConfig();
        try {
            this.controller.saveConfig((StudioAssistConfig)genAIConfig);
        }
        catch (StudioAssistSavingConfigException e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to save GenAI config");
        }
    }

    @Override
    public void resetConfig() {
        this.validateGenAIService();
        this.displayContent(true);
    }

    @Override
    protected void initValidationList() {
    }

    private void validateGenAIService() {
        if (!this.isKatalonAIAvailable()) {
            this.mainPreferencePage.setValid(false);
        } else {
            this.mainPreferencePage.setValid(true);
        }
    }
}

