/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.AzureOpenAIConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.ManagedAzureOpenAiConfig;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ManagedAzureOpenAiPage
extends AIConfigurationComponent {
    private Text azureOpenAIMaxToken;
    private final String BASE_URL = "Base URL";
    private final String DEPLOYMENT_NAME = "Deployment name";
    private final String API_KEY = "API key";
    private final String MAX_TOKEN = "Max completion token";
    private final String API_VERSION = "API version";

    public ManagedAzureOpenAiPage(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0).build();
        ComponentBuilder.label((Composite)container).text("Azure OpenAI").bold().build();
        ComponentBuilder.label((Composite)container).text("- managed by your organization").build();
        Composite component = (Composite)ComponentBuilder.group((Composite)parent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Base URL*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedAzureOpenAiConfig)this.aiConfigPolicy.getManagedAzureOpenAi().get()).getApiBase()).disable().build();
        ComponentBuilder.label((Composite)component).text("Deployment name*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedAzureOpenAiConfig)this.aiConfigPolicy.getManagedAzureOpenAi().get()).getDeploymentName()).disable().build();
        ComponentBuilder.label((Composite)component).text("API key*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedAzureOpenAiConfig)this.aiConfigPolicy.getManagedAzureOpenAi().get()).getApiKey()).maskPassword().disable().build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.azureOpenAIMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.azureOpenAIMaxToken.getText(), true)).build();
        ComponentBuilder.label((Composite)component).text("API version").build();
        ComponentBuilder.text((Composite)component).text(((ManagedAzureOpenAiConfig)this.aiConfigPolicy.getManagedAzureOpenAi().get()).getApiVersion()).disable().build();
        return component;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        try {
            StudioAssistConfig config = this.controller.getConfig();
            boolean usingAzureOpenAI = config instanceof AzureOpenAIConfig;
            if (usingAzureOpenAI) {
                AzureOpenAIConfig azureOpenAIConfig = (AzureOpenAIConfig)config;
                this.azureOpenAIMaxToken.setText(Integer.toString(azureOpenAIConfig.getMaxToken()));
            } else {
                this.azureOpenAIMaxToken.setText(Integer.toString(16000));
            }
            this.displayContent(usingAzureOpenAI);
        }
        catch (StudioAssistLoadingConfigException e) {
            LoggerSingleton.logError((String)"Failed to load config in ManagedAzureOpenAIPage");
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        try {
            AzureOpenAIConfig azureOpenAIConfig = new AzureOpenAIConfig();
            azureOpenAIConfig.setMaxToken(Integer.valueOf(this.azureOpenAIMaxToken.getText().trim()).intValue());
            this.controller.saveConfig((StudioAssistConfig)azureOpenAIConfig);
        }
        catch (StudioAssistSavingConfigException e) {
            LoggerSingleton.logError((String)"Failed to save config in ManagedAzureOpenAIPage");
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void resetConfig() {
        this.azureOpenAIMaxToken.setText(Integer.toString(16000));
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Max completion token", false);
    }
}

