/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.ManagedOpenAiConfig;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ManagedOpenAiPage
extends AIConfigurationComponent {
    private Text openAIMaxToken;
    private Text openAIModel;
    private final String SECRET_KEY = "Secret key";
    private final String ORGANIZATION_ID = "Organization ID";
    private final String MAX_TOKEN = "Max completion token";
    private final String MODEL = "Model";

    public ManagedOpenAiPage(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0).build();
        ComponentBuilder.label((Composite)container).text("OpenAI").bold().build();
        ComponentBuilder.label((Composite)container).text("- managed by your organization").build();
        Composite component = (Composite)ComponentBuilder.group((Composite)parent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Secret key*").build();
        ComponentBuilder.text((Composite)component).text(((ManagedOpenAiConfig)this.aiConfigPolicy.getManagedOpenAi().get()).getApiKey()).maskPassword().disable().build();
        ComponentBuilder.label((Composite)component).text("Organization ID").build();
        ComponentBuilder.text((Composite)component).text(((ManagedOpenAiConfig)this.aiConfigPolicy.getManagedOpenAi().get()).getOrganizationId()).disable().build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.openAIMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().build();
        ComponentBuilder.label((Composite)component).text("Model").build();
        this.openAIModel = (Text)ComponentBuilder.text((Composite)component).fill().build();
        return component;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        try {
            StudioAssistConfig config = this.controller.getConfig();
            boolean usingOpenAIConfig = config instanceof OpenAIConfig;
            if (usingOpenAIConfig) {
                OpenAIConfig openAIConfig = (OpenAIConfig)config;
                this.openAIMaxToken.setText(Integer.toString(openAIConfig.getMaxToken()));
                String modelName = openAIConfig.getModelName();
                if (StringUtils.isBlank((CharSequence)modelName)) {
                    modelName = OpenAIConfig.DEFAULT_MODEL;
                }
                this.openAIModel.setText(modelName);
            } else {
                this.openAIMaxToken.setText(Integer.toString(16000));
                this.openAIModel.setText(OpenAIConfig.DEFAULT_MODEL);
            }
            this.displayContent(usingOpenAIConfig);
        }
        catch (StudioAssistLoadingConfigException e) {
            LoggerSingleton.logError((String)"Failed to load config in ManagedOpenAIPage");
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        try {
            OpenAIConfig openAIConfig = new OpenAIConfig();
            openAIConfig.setMaxToken(Integer.valueOf(this.openAIMaxToken.getText().trim()).intValue());
            openAIConfig.setModelName(this.openAIModel.getText().trim());
            this.controller.saveConfig((StudioAssistConfig)openAIConfig);
        }
        catch (StudioAssistSavingConfigException e) {
            LoggerSingleton.logError((String)"Failed to save config in ManagedOpenAIPage");
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void resetConfig() {
        this.openAIMaxToken.setText(Integer.toString(16000));
        this.openAIModel.setText(OpenAIConfig.DEFAULT_MODEL);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Max completion token", false);
    }
}

