/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.OpenAIConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class OpenAIConfigComponent
extends AIConfigurationComponent {
    private Text openAISecretKey;
    private Text openAIMaxToken;
    private Text openAIOrganizationId;
    private Text openAIModel;
    private final String SECRET_KEY = "Secret key";
    private final String MAX_TOKEN = "Max completion token";

    public OpenAIConfigComponent(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite outerComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1, (int)0).fillHorizontal().build();
        Composite component = (Composite)ComponentBuilder.group((Composite)outerComponent).gridLayout(2).fillHorizontal().build();
        ComponentBuilder.label((Composite)component).text("Secret key*").build();
        this.openAISecretKey = (Text)ComponentBuilder.text((Composite)component).maskPassword().fill().onChange(event -> {
            boolean bl = this.validateNotBlank("Secret key", this.openAISecretKey.getText(), true);
        }).build();
        ComponentBuilder.label((Composite)component).text("Max completion token*").build();
        this.openAIMaxToken = (Text)ComponentBuilder.text((Composite)component).fill().onChange(event -> this.validateMaxToken("Max completion token", this.openAIMaxToken.getText(), true)).build();
        ComponentBuilder.label((Composite)component).text("Organization ID").build();
        this.openAIOrganizationId = (Text)ComponentBuilder.text((Composite)component).fill().build();
        ComponentBuilder.label((Composite)component).text("Model").build();
        this.openAIModel = (Text)ComponentBuilder.text((Composite)component).fill().build();
        this.content = outerComponent;
        return outerComponent;
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
        boolean hasChosenOpenAI = type == LlmConfigType.OPENAI;
        this.displayContent(hasChosenOpenAI);
        if (hasChosenOpenAI) {
            this.resetMessage(hasChosenOpenAI);
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        StudioAssistConfig config = this.controller.getConfig();
        boolean usingOpenAIConfig = config instanceof OpenAIConfig;
        if (usingOpenAIConfig) {
            OpenAIConfig openAIConfig = (OpenAIConfig)config;
            this.openAISecretKey.setText(openAIConfig.getSecretKey());
            this.openAIMaxToken.setText(Long.toString(openAIConfig.getMaxToken()));
            this.openAIOrganizationId.setText(openAIConfig.getOrganizationId());
            String modelName = openAIConfig.getModelName();
            if (StringUtils.isBlank((CharSequence)modelName)) {
                modelName = OpenAIConfig.DEFAULT_MODEL;
            }
            this.openAIModel.setText(modelName);
        } else {
            this.openAIMaxToken.setText(Integer.toString(16000));
            this.openAIModel.setText(OpenAIConfig.DEFAULT_MODEL);
        }
        this.displayContent(usingOpenAIConfig);
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        String model;
        OpenAIConfig openAIConfig = new OpenAIConfig();
        String rawMaxToken = this.openAIMaxToken.getText();
        if (StringUtils.isNotBlank((CharSequence)rawMaxToken)) {
            openAIConfig.setMaxToken(Integer.valueOf(rawMaxToken).intValue());
        }
        if (StringUtils.isBlank((CharSequence)(model = this.openAIModel.getText().trim()))) {
            model = OpenAIConfig.DEFAULT_MODEL;
        }
        openAIConfig.setModelName(model);
        openAIConfig.setOrganizationId(this.openAIOrganizationId.getText());
        openAIConfig.setSecretKey(this.openAISecretKey.getText());
        this.controller.saveConfig((StudioAssistConfig)openAIConfig);
    }

    @Override
    public void resetConfig() {
        this.openAISecretKey.setText("");
        this.openAIMaxToken.setText(String.valueOf(16000));
        this.openAIOrganizationId.setText("");
        this.openAIModel.setText(OpenAIConfig.DEFAULT_MODEL);
        this.displayContent(false);
    }

    @Override
    protected void initValidationList() {
        this.validationList.put("Secret key", false);
        this.validationList.put("Max completion token", false);
    }
}

