/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IStudioAssistController;
import com.kms.katalon.ai.core.services.IStudioAssistTrackingService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.MessageComponentBuilder;
import com.kms.katalon.constants.GlobalStringConstants;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromptLibraryPreferencePage
extends PreferencePage {
    private final Logger logger = LoggerFactory.getLogger(PromptLibraryPreferencePage.class);
    private final Color VARIABLE_COLOR_FOR_TEXT_AND_DARK_THEME = new Color(114, 114, 218);
    private final Color VARIABLE_COLOR_FOR_LIGHT_THEME = new Color(220, 220, 246);
    private ListViewer featureListViewer;
    private StyledText currentContentTextArea;
    private Map<PromptType, String> promptContentMap = new LinkedHashMap<PromptType, String>();
    private Label oneVarButton;
    private Label addVariableLabel;
    private Label revertOriginalButton;
    private Label errorMessage;
    private List<String> supportedVariables;
    private List<PromptType> trackingPendingRestoredPrompts = new ArrayList<PromptType>();
    private List<PromptType> trackingModifiedPrompts = new ArrayList<PromptType>();
    private Map<PromptType, String> trackingSavedPromptContentMap = new LinkedHashMap<PromptType, String>();
    @Inject
    private IStudioAssistController controller;
    @Inject
    private IStudioAssistTrackingService trackingService;

    protected Control createContents(Composite parent) {
        MessageComponentBuilder.create().parent(parent).message("Customized prompts are not applied in the Katalon AI service.").fillHorizontal(true).warningStyle().build();
        Composite parentComponent = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2048).fill().gridSpacing(0).numCols(10).build();
        Composite featureListComponent = (Composite)ComponentBuilder.gridContainer((Composite)parentComponent, (int)2048).colSpan(3).numCols(1).top().fillVertical().background(ColorUtil.WHITE_COLOR).build();
        this.featureListViewer = new ListViewer(featureListComponent);
        org.eclipse.swt.widgets.List featureUIList = this.featureListViewer.getList();
        featureUIList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.featureListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.featureListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof PromptType) {
                    PromptType promptType = (PromptType)element;
                    return " " + promptType.getName();
                }
                return "";
            }
        });
        Composite promptContentComposite = (Composite)ComponentBuilder.gridContainer((Composite)parentComponent, (int)2048).fill().numCols(1).colSpan(7).gridSpacing(0).build();
        Composite textAreaComposite = new Composite(promptContentComposite, 2048);
        GridLayout textAreaLayout = new GridLayout(1, false);
        textAreaLayout.marginWidth = 5;
        textAreaLayout.marginHeight = 0;
        textAreaComposite.setLayout((Layout)textAreaLayout);
        textAreaComposite.setBackground(ColorUtil.WHITE_COLOR);
        GridData textAreaLayoutData = new GridData(4, 4, true, true);
        textAreaComposite.setLayoutData((Object)textAreaLayoutData);
        GridData contentTextAreaLayoutData = new GridData(4, 4, true, true);
        contentTextAreaLayoutData.heightHint = 450;
        contentTextAreaLayoutData.widthHint = 380;
        textAreaComposite.setLayoutData((Object)contentTextAreaLayoutData);
        this.currentContentTextArea = (StyledText)ComponentBuilder.styledText((Composite)textAreaComposite, (int)578).background(ColorUtil.WHITE_COLOR).fill().build();
        Composite variablesAndResetComposite = new Composite(promptContentComposite, 2048);
        variablesAndResetComposite.setBackground(ColorUtil.WHITE_COLOR);
        GridData variableResetContainerLayoutData = new GridData(4, 1024, true, false);
        variablesAndResetComposite.setLayoutData((Object)variableResetContainerLayoutData);
        GridLayout variableResetContainerLayout = new GridLayout(3, false);
        variableResetContainerLayout.horizontalSpacing = 0;
        variableResetContainerLayout.verticalSpacing = 0;
        variablesAndResetComposite.setLayout((Layout)variableResetContainerLayout);
        this.addVariableLabel = (Label)ComponentBuilder.label((Composite)variablesAndResetComposite).text("Add variable").color(ColorUtil.GRAY_BADGE_ACTIVE_COLOR).background(ColorUtil.WHITE_COLOR).build();
        Composite oneVarComposite = MessageComponentBuilder.create().parent(variablesAndResetComposite).build();
        oneVarComposite.addPaintListener(e -> {
            GC gc = e.gc;
            Rectangle bounds = oneVarComposite.getBounds();
            gc.setAntialias(1);
            int BORDER_WIDTH = 4;
            int BORDER_RADIUS = 8;
            if (ColorUtil.isDarkTheme()) {
                gc.setBackground(this.VARIABLE_COLOR_FOR_TEXT_AND_DARK_THEME);
                oneVarComposite.setBackground(this.VARIABLE_COLOR_FOR_TEXT_AND_DARK_THEME);
            } else {
                gc.setBackground(this.VARIABLE_COLOR_FOR_LIGHT_THEME);
                oneVarComposite.setBackground(this.VARIABLE_COLOR_FOR_LIGHT_THEME);
            }
            gc.fillRoundRectangle(BORDER_WIDTH / 2, BORDER_WIDTH / 2, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH, BORDER_RADIUS * 2, BORDER_RADIUS * 2);
            if (ColorUtil.isDarkTheme()) {
                gc.setForeground(ColorUtil.getColor((String)"#505458"));
            } else {
                gc.setForeground(ColorUtil.WHITE_COLOR);
            }
            gc.setLineWidth(BORDER_WIDTH);
            gc.drawRoundRectangle(BORDER_WIDTH / 2, BORDER_WIDTH / 2, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH, BORDER_RADIUS * 2, BORDER_RADIUS * 2);
            gc.drawRectangle(new Rectangle(BORDER_WIDTH / 2, BORDER_WIDTH / 2, bounds.width - BORDER_WIDTH, bounds.height - BORDER_WIDTH));
        });
        this.oneVarButton = (Label)oneVarComposite.getChildren()[0];
        this.oneVarButton.setLayoutData((Object)new GridData(64, 64, true, true));
        this.oneVarButton.setCursor(parent.getDisplay().getSystemCursor(21));
        this.revertOriginalButton = (Label)ComponentBuilder.label((Composite)variablesAndResetComposite).text("Revert Orginal").border(0).background(ColorUtil.WHITE_COLOR).build();
        this.revertOriginalButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.revertOriginalButton.setCursor(parent.getDisplay().getSystemCursor(21));
        this.revertOriginalButton.addPaintListener(e -> {
            if (ColorUtil.isDarkTheme()) {
                this.revertOriginalButton.setForeground(ColorUtil.getColor((String)"#66AEF2"));
            } else {
                this.revertOriginalButton.setForeground(ColorUtil.getColor((String)"#0164E1"));
            }
        });
        ComponentBuilder.label((Composite)parentComponent).colSpan(3).build();
        this.errorMessage = (Label)ComponentBuilder.label((Composite)parentComponent).colSpan(7).build();
        this.loadData();
        this.registerControlModifyListeners();
        this.setDefaultOption();
        return parent;
    }

    private void loadData() {
        PromptType[] featureList = PromptType.values();
        this.featureListViewer.setInput((Object)featureList);
        PromptType[] promptTypeArray = PromptType.values();
        int n = promptTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PromptType feature = promptTypeArray[n2];
            String featureContent = this.controller.getPromptContentTemplate(feature);
            this.promptContentMap.put(feature, featureContent);
            this.trackingSavedPromptContentMap.put(feature, featureContent);
            ++n2;
        }
    }

    private void registerControlModifyListeners() {
        this.featureListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PromptType choosingFeature = (PromptType)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (choosingFeature == null) {
                    PromptLibraryPreferencePage.this.featureListViewer.setSelection((ISelection)new StructuredSelection((Object)PromptType.CODE_GENERATE));
                    return;
                }
                List currentSupportedVariables = PromptLibraryPreferencePage.this.controller.getSupportedContextTemplateList(choosingFeature);
                if (currentSupportedVariables == null || !currentSupportedVariables.equals(PromptLibraryPreferencePage.this.supportedVariables)) {
                    PromptLibraryPreferencePage.this.supportedVariables = currentSupportedVariables;
                }
                PromptLibraryPreferencePage.this.updatePromptContentWith(choosingFeature);
                PromptLibraryPreferencePage.this.updateVariablesComponent(choosingFeature);
            }
        });
        this.currentContentTextArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                PromptType currentFeature = (PromptType)((IStructuredSelection)PromptLibraryPreferencePage.this.featureListViewer.getSelection()).getFirstElement();
                if (!PromptLibraryPreferencePage.this.trackingModifiedPrompts.contains(currentFeature)) {
                    PromptLibraryPreferencePage.this.trackingModifiedPrompts.add(currentFeature);
                }
            }
        });
        this.currentContentTextArea.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyledText updatedContent = (StyledText)e.getSource();
                PromptType currentFeature = (PromptType)((IStructuredSelection)PromptLibraryPreferencePage.this.featureListViewer.getSelection()).getFirstElement();
                PromptLibraryPreferencePage.this.promptContentMap.put(currentFeature, updatedContent.getText());
                PromptLibraryPreferencePage.this.validatePromptContent(currentFeature, updatedContent.getText());
            }
        });
        this.oneVarButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String variableName = PromptLibraryPreferencePage.this.supportedVariables.get(0);
                Point cursorPoint = PromptLibraryPreferencePage.this.currentContentTextArea.getSelection();
                String appendString = PromptLibraryPreferencePage.this.controller.buildVariableNameWithStringTemplate(variableName);
                int cursorIndex = cursorPoint.x;
                Object currentContent = PromptLibraryPreferencePage.this.currentContentTextArea.getText();
                currentContent = cursorIndex <= 0 ? appendString + (String)currentContent : (cursorIndex >= ((String)currentContent).length() ? (String)currentContent + appendString : new StringBuilder((String)currentContent).insert(cursorIndex, appendString).toString());
                PromptLibraryPreferencePage.this.setCurrentPromptContent((String)currentContent);
                PromptLibraryPreferencePage.this.currentContentTextArea.setSelection(cursorIndex + appendString.length() + 3);
            }
        });
        this.revertOriginalButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StructuredSelection selection = (StructuredSelection)PromptLibraryPreferencePage.this.featureListViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                PromptType selectedPrompt = (PromptType)selection.getFirstElement();
                String defaultContent = PromptLibraryPreferencePage.this.controller.getDefaultPromptContentTemplate(selectedPrompt);
                PromptLibraryPreferencePage.this.setCurrentPromptContent(defaultContent);
                String savedContent = PromptLibraryPreferencePage.this.trackingSavedPromptContentMap.get(selectedPrompt);
                if (savedContent != null && !StringUtils.equals((CharSequence)savedContent, (CharSequence)defaultContent) && !PromptLibraryPreferencePage.this.trackingPendingRestoredPrompts.contains(selectedPrompt)) {
                    PromptLibraryPreferencePage.this.trackingPendingRestoredPrompts.add(selectedPrompt);
                }
                PromptLibraryPreferencePage.this.trackingModifiedPrompts.remove(selectedPrompt);
            }
        });
    }

    private void setDefaultOption() {
        PromptType defaultPromptType = PromptType.CODE_GENERATE;
        this.featureListViewer.setSelection((ISelection)new StructuredSelection((Object)defaultPromptType));
    }

    private void updatePromptContentWith(PromptType feature) {
        String promptContent = this.promptContentMap.get(feature);
        this.setCurrentPromptContent(promptContent);
    }

    private void setCurrentPromptContent(String content) {
        this.currentContentTextArea.setText(content);
        this.currentContentTextArea.setStyleRanges(this.listStyleRange(content));
    }

    private void validatePromptContent(PromptType promptType, String content) {
        this.currentContentTextArea.setStyleRanges(this.listStyleRange(content));
        this.checkError(promptType, content);
    }

    private void checkError(PromptType promptType, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            this.updateErrorMessage("StudioAssist uses the default prompt when a custom prompt hasn't been set.");
            return;
        }
        List requiredVariables = this.controller.getRequiredVariablesForContextTemplate(promptType);
        ArrayList<String> missingVariables = new ArrayList<String>();
        for (String requiredVar : requiredVariables) {
            String variableWithTemplate = this.controller.buildVariableNameWithStringTemplate(requiredVar);
            if (content.contains(variableWithTemplate)) continue;
            missingVariables.add(variableWithTemplate);
        }
        if (CollectionUtils.isNotEmpty(missingVariables)) {
            this.updateErrorMessage("Missing " + missingVariables.stream().collect(Collectors.joining(" ")));
            return;
        }
        this.updateErrorMessage("");
    }

    private void updateErrorMessage(String content) {
        this.errorMessage.setText(content);
        this.errorMessage.requestLayout();
    }

    private StyleRange[] listStyleRange(String content) {
        Pattern pattern = Pattern.compile(this.controller.getRegexStringTemplateEngine());
        Matcher matcher = pattern.matcher(content);
        ArrayList<StyleRange> result = new ArrayList<StyleRange>();
        while (matcher.find()) {
            StyleRange styleRange = new StyleRange();
            styleRange.start = matcher.start();
            styleRange.length = matcher.end() - matcher.start();
            styleRange.foreground = this.supportedVariables != null && this.supportedVariables.contains(matcher.group(1)) ? this.VARIABLE_COLOR_FOR_TEXT_AND_DARK_THEME : new Color(255, 0, 0);
            result.add(styleRange);
        }
        return result.toArray(new StyleRange[0]);
    }

    private void updateVariablesComponent(PromptType currentPromptType) {
        if (this.supportedVariables == null || this.supportedVariables.size() < 1) {
            this.addVariableLabel.setVisible(false);
            this.oneVarButton.getParent().setVisible(false);
        } else if (this.supportedVariables.size() == 1) {
            this.addVariableLabel.setVisible(true);
            this.oneVarButton.getParent().setVisible(true);
            this.oneVarButton.setText(this.controller.buildVariableNameWithStringTemplate(this.supportedVariables.get(0).toString()));
            this.oneVarButton.getParent().redraw();
        } else {
            this.addVariableLabel.setVisible(false);
            this.oneVarButton.getParent().setVisible(false);
        }
    }

    public boolean performOk() {
        String errorMsg = null;
        for (Map.Entry<PromptType, String> featureContentEntry : this.promptContentMap.entrySet()) {
            try {
                this.controller.savePromptContentTemplate(featureContentEntry.getKey(), featureContentEntry.getValue());
                this.trackingSavedPromptContentMap.put(featureContentEntry.getKey(), featureContentEntry.getValue());
            }
            catch (StudioAssistBaseException e) {
                String message = "Something went wrong while saving %s custom prompt.".formatted(featureContentEntry.getKey());
                this.logger.error(message, (Throwable)e);
                errorMsg = message;
            }
        }
        this.trackCustomizedPromptEvents();
        if (!StringUtils.isBlank(errorMsg)) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalStringConstants.ERROR, errorMsg);
            return false;
        }
        return true;
    }

    private void trackCustomizedPromptEvents() {
        List<PromptType> actuallyModifiedPrompts = this.getModifiedPrompts();
        if (actuallyModifiedPrompts.isEmpty() && this.trackingPendingRestoredPrompts.isEmpty()) {
            return;
        }
        this.trackingService.trackCustomizedPromptEvents(actuallyModifiedPrompts, this.trackingPendingRestoredPrompts);
        this.trackingModifiedPrompts.clear();
        this.trackingPendingRestoredPrompts.clear();
    }

    private List<PromptType> getModifiedPrompts() {
        return this.trackingModifiedPrompts.stream().filter(promptType -> {
            String defaultContent;
            String currentContent = this.promptContentMap.get(promptType);
            return !StringUtils.equals((CharSequence)currentContent, (CharSequence)(defaultContent = this.controller.getDefaultPromptContentTemplate(promptType)));
        }).collect(Collectors.toList());
    }

    protected void performApply() {
        this.performOk();
    }

    public void performDefaults() {
        List savedCustomizedPrompts = Arrays.stream(PromptType.values()).filter(promptType -> {
            String savedContent = this.trackingSavedPromptContentMap.get(promptType);
            String defaultContent = this.controller.getDefaultPromptContentTemplate(promptType);
            return savedContent != null && !StringUtils.equals((CharSequence)savedContent, (CharSequence)defaultContent);
        }).collect(Collectors.toList());
        PromptType[] promptTypeArray = PromptType.values();
        int n = promptTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PromptType feature = promptTypeArray[n2];
            String featureContent = this.controller.getDefaultPromptContentTemplate(feature);
            this.promptContentMap.put(feature, featureContent);
            ++n2;
        }
        this.setDefaultOption();
        if (!savedCustomizedPrompts.isEmpty()) {
            this.trackingPendingRestoredPrompts.addAll(savedCustomizedPrompts);
        }
        this.trackingModifiedPrompts.clear();
    }
}

