/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.ai.studioassist.preference;

import com.kms.katalon.ai.core.model.config.GenAIConfig;
import com.kms.katalon.ai.core.model.config.LlmConfigType;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.composer.ai.studioassist.preference.AIConfigurationComponent;
import com.kms.katalon.composer.ai.studioassist.preference.AwsBedrockConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.AzureOpenAIConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.GeminiConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.GenAIConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.NoneConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.OpenAIConfigComponent;
import com.kms.katalon.composer.ai.studioassist.preference.OpenAiCompatibleConfigComponent;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.session.core.model.AiConfigPolicy;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class UserSettingPage
extends AIConfigurationComponent {
    @Inject
    private IEclipseContext context;
    @Inject
    private IFeatureController featureController;
    private AIConfigurationComponent[] configComponents;
    private Combo providerDropdown;
    private AIConfigurationComponent selectedConfigComponent;
    private ProviderInfo[] providers;
    private Map<LlmConfigType, Integer> providerTypeIndex;

    public UserSettingPage(Composite parent, AiConfigPolicy aiConfigPolicy) {
        super(parent, aiConfigPolicy);
    }

    @Override
    protected Composite createContent(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1).build();
        if (this.featureController.canUse(ProductFeature.STUDIOASSIST_EXECUTE_PROMPT)) {
            this.initConfigDropDownProviders();
            this.createProviderSelector(container);
            this.initializeConfigComponents(parent);
        }
        return container;
    }

    private void initConfigDropDownProviders() {
        this.providers = this.featureController.canUse(ProductFeature.STUDIOASSIST_KATALON_AI) ? new ProviderInfo[]{new ProviderInfo(LlmConfigType.GEN_AI, "Katalon AI Service", GenAIConfigComponent.class), new ProviderInfo(LlmConfigType.OPENAI, "Use personal OpenAI key", OpenAIConfigComponent.class), new ProviderInfo(LlmConfigType.AZURE_OPENAI, "Use personal Azure OpenAI API key", AzureOpenAIConfigComponent.class), new ProviderInfo(LlmConfigType.GEMINI, "Use personal Gemini API key", GeminiConfigComponent.class), new ProviderInfo(LlmConfigType.OPENAI_COMPATIBLE, "Open-AI compatible provider", OpenAiCompatibleConfigComponent.class), new ProviderInfo(LlmConfigType.AWS_BEDROCK, "Use personal AWS Bedrock Credentials", AwsBedrockConfigComponent.class), new ProviderInfo(LlmConfigType.NONE, "None", NoneConfigComponent.class)} : new ProviderInfo[]{new ProviderInfo(LlmConfigType.OPENAI, "Use personal OpenAI key", OpenAIConfigComponent.class), new ProviderInfo(LlmConfigType.AZURE_OPENAI, "Use personal Azure OpenAI API key", AzureOpenAIConfigComponent.class), new ProviderInfo(LlmConfigType.GEMINI, "Use personal Gemini API key", GeminiConfigComponent.class), new ProviderInfo(LlmConfigType.OPENAI_COMPATIBLE, "Open-AI compatible provider", OpenAiCompatibleConfigComponent.class), new ProviderInfo(LlmConfigType.AWS_BEDROCK, "Use personal AWS Bedrock Credentials", AwsBedrockConfigComponent.class), new ProviderInfo(LlmConfigType.NONE, "None", NoneConfigComponent.class)};
        this.providerTypeIndex = IntStream.range(0, this.providers.length).boxed().collect(Collectors.toMap(i -> this.providers[i.intValue()].type, i -> i));
    }

    private void createProviderSelector(Composite container) {
        Composite dropdownContainer = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).fillHorizontal().build();
        this.providerDropdown = new Combo(dropdownContainer, 12);
        String[] providerLabels = (String[])Arrays.stream(this.providers).map(p -> p.label).toArray(String[]::new);
        this.providerDropdown.setItems(providerLabels);
        LlmConfigType currentConfig = this.getInitialConfigType();
        this.providerDropdown.select(this.providerTypeIndex.get(currentConfig).intValue());
        this.providerDropdown.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.providerDropdown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = UserSettingPage.this.providerDropdown.getSelectionIndex();
                LlmConfigType configType = UserSettingPage.this.providers[index].type;
                UserSettingPage.this.onSwitchOption(configType);
            }
        });
    }

    private LlmConfigType getInitialConfigType() {
        try {
            boolean canNotUseKatalonAI;
            StudioAssistConfig config = this.controller.getConfig();
            boolean bl = canNotUseKatalonAI = !this.featureController.canUse(ProductFeature.STUDIOASSIST_KATALON_AI) && config != null && config.getClass() == GenAIConfig.class;
            if (canNotUseKatalonAI) {
                return this.providers[0].type;
            }
            return Optional.ofNullable(config).map(StudioAssistConfig::getType).orElse(this.providers[0].type);
        }
        catch (StudioAssistLoadingConfigException e) {
            LoggerSingleton.logError((Throwable)e, (String)String.format("Failed to get StudioAssistConfig, fallback to use %s", this.providers[0].label));
            return this.providers[0].type;
        }
    }

    private void initializeConfigComponents(Composite parent) {
        this.configComponents = new AIConfigurationComponent[this.providers.length];
        int i = 0;
        while (i < this.providers.length) {
            ProviderInfo info = this.providers[i];
            try {
                Constructor<?> ctor = info.clazz.getDeclaredConstructor(Composite.class, AiConfigPolicy.class);
                AIConfigurationComponent instance = (AIConfigurationComponent)ctor.newInstance(parent, this.aiConfigPolicy);
                ContextInjectionFactory.inject((Object)instance, (IEclipseContext)this.context);
                this.configComponents[i] = instance;
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)String.format("Error while creating AI dropdown config for %s", info.type.toString()));
            }
            ++i;
        }
    }

    @Override
    protected void onSwitchOption(LlmConfigType type) {
        int selectedIndex = this.providerTypeIndex.get(type);
        this.selectedConfigComponent = this.configComponents[selectedIndex];
        AIConfigurationComponent[] aIConfigurationComponentArray = this.configComponents;
        int n = this.configComponents.length;
        int n2 = 0;
        while (n2 < n) {
            AIConfigurationComponent component = aIConfigurationComponentArray[n2];
            component.onSwitchOption(type);
            ++n2;
        }
    }

    @Override
    protected void loadConfig() throws StudioAssistLoadingConfigException {
        if (this.configComponents == null || this.configComponents.length <= 0) {
            return;
        }
        try {
            AIConfigurationComponent[] aIConfigurationComponentArray = this.configComponents;
            int n = this.configComponents.length;
            int n2 = 0;
            while (n2 < n) {
                AIConfigurationComponent each = aIConfigurationComponentArray[n2];
                each.setMainPreferencePage(this.mainPreferencePage);
                each.setSiblings(this.configComponents);
                each.loadConfig();
                ++n2;
            }
            LlmConfigType currentConfigType = this.getCurrentConfigType();
            this.selectedConfigComponent = this.configComponents[this.providerTypeIndex.get(currentConfigType)];
            this.onSwitchOption(currentConfigType);
        }
        catch (StudioAssistLoadingConfigException e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to load config in User Setting Page");
        }
    }

    @Override
    public void saveConfig() throws StudioAssistSavingConfigException {
        try {
            if (this.selectedConfigComponent != null) {
                this.selectedConfigComponent.saveConfig();
            }
        }
        catch (StudioAssistSavingConfigException e) {
            LoggerSingleton.logError((Throwable)e, (String)"Failed to save config in User Setting Page");
        }
    }

    @Override
    public void resetConfig() {
        if (this.configComponents == null || this.configComponents.length <= 0) {
            return;
        }
        AIConfigurationComponent[] aIConfigurationComponentArray = this.configComponents;
        int n = this.configComponents.length;
        int n2 = 0;
        while (n2 < n) {
            AIConfigurationComponent each = aIConfigurationComponentArray[n2];
            each.resetConfig();
            ++n2;
        }
        LlmConfigType defaultConfigType = this.featureController.canUse(ProductFeature.STUDIOASSIST_KATALON_AI) ? LlmConfigType.GEN_AI : LlmConfigType.NONE;
        Integer defaultConfigTypeIndex = this.providerTypeIndex.get(defaultConfigType);
        this.providerDropdown.select(defaultConfigTypeIndex.intValue());
        this.selectedConfigComponent = this.configComponents[defaultConfigTypeIndex];
        this.onSwitchOption(defaultConfigType);
    }

    @Override
    protected void initValidationList() {
        if (this.configComponents == null || this.configComponents.length <= 0) {
            return;
        }
        AIConfigurationComponent[] aIConfigurationComponentArray = this.configComponents;
        int n = this.configComponents.length;
        int n2 = 0;
        while (n2 < n) {
            AIConfigurationComponent each = aIConfigurationComponentArray[n2];
            each.initValidationList();
            ++n2;
        }
    }

    protected LlmConfigType getCurrentConfigType() {
        int index = this.providerDropdown.getSelectionIndex();
        if (index >= 0 && index < this.providers.length) {
            return this.providers[index].type;
        }
        return this.providers[0].type;
    }

    private static class ProviderInfo {
        final LlmConfigType type;
        final String label;
        final Class<?> clazz;

        ProviderInfo(LlmConfigType type, String label, Class<?> clazz) {
            this.type = type;
            this.label = label;
            this.clazz = clazz;
        }
    }
}

