/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.execution.configuration.impl.RemoteExecutionSetting;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileBrowserName;
import com.kms.katalon.testcloud.core.model.TestCloudPlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.driver.TestCloudDriverConnector;
import com.kms.katalon.tracking.model.TestCloudRunConfigurationType;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class TestCloudRunConfiguration
extends RemoteWebRunConfiguration {
    private TestCloudDriverConnector testCloudDriverConnector;

    public TestCloudDriverConnector getTestCloudDriverConnector() {
        return this.testCloudDriverConnector;
    }

    public TestCloudRunConfiguration(String projectDir) throws IOException {
        super(projectDir, (RemoteWebDriverConnector)new TestCloudDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
        this.testCloudDriverConnector = (TestCloudDriverConnector)this.remoteDriverConnector;
        this.initExecutionSetting();
    }

    public String getName() {
        TestCloudSessionType testCloudSessionType = this.testCloudDriverConnector.getTestCloudSessionType();
        if (TestCloudSessionType.MOBILE_BROWSER.equals((Object)testCloudSessionType)) {
            TestCloudDevice entity = (TestCloudDevice)this.testCloudDriverConnector.getTestCloudEntity();
            TestCloudMobileBrowserName browserName = TestCloudMobileBrowserName.UNKNOWN;
            TestCloudPlatformName platformName = entity.getPlatformName();
            if (platformName.equals((Object)TestCloudPlatformName.ANDROID)) {
                browserName = TestCloudMobileBrowserName.CHROME;
            } else if (platformName.equals((Object)TestCloudPlatformName.IOS)) {
                browserName = TestCloudMobileBrowserName.SAFARI;
            }
            return GlobalStringConstants.TESTCLOUD_NAME + " - " + this.getMobileDisplayName(entity, testCloudSessionType) + ", " + browserName.toString();
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)testCloudSessionType)) {
            return GlobalStringConstants.TESTCLOUD_NAME + " - " + this.getMobileDisplayName((TestCloudDevice)this.testCloudDriverConnector.getTestCloudEntity(), testCloudSessionType);
        }
        return GlobalStringConstants.TESTCLOUD_NAME + " - " + this.getDesktopDisplayName((TestCloudDesktopBrowser)this.testCloudDriverConnector.getTestCloudEntity());
    }

    protected void initExecutionSetting() {
        this.executionSetting = new RemoteExecutionSetting((IDriverConnector)this.testCloudDriverConnector);
        ContextInjectionFactory.inject((Object)this.executionSetting, (IEclipseContext)this.context);
    }

    private String getMobileDisplayName(TestCloudDevice testCloudEntity, TestCloudSessionType sessionType) {
        if (testCloudEntity.getDisplayName() == null) {
            testCloudEntity.setDisplayName(testCloudEntity.getName());
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)sessionType)) {
            return testCloudEntity.getDisplayName() + ", version=" + testCloudEntity.getOsVersion();
        }
        return testCloudEntity.getDisplayName() + ", version=" + testCloudEntity.getOsVersion() + ", Tunnel=" + testCloudEntity.isUsingTunnel();
    }

    private String getDesktopDisplayName(TestCloudDesktopBrowser testCloudEntity) {
        if (Objects.isNull(testCloudEntity)) {
            return "";
        }
        String browserFullVersion = TestCloudPropertyUtil.getInstance().buildBrowserFullVersion(testCloudEntity.getBrowserVersion(), testCloudEntity.getBrowserVersionType());
        return testCloudEntity.getOsDisplayName() + ", " + testCloudEntity.getBrowserName().substring(0, 1).toUpperCase() + testCloudEntity.getBrowserName().substring(1) + ", version=" + browserFullVersion + ", Tunnel=" + testCloudEntity.isUsingTunnel();
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        LinkedHashMap<String, IDriverConnector> driverCollector = new LinkedHashMap<String, IDriverConnector>();
        driverCollector.put("Remote", (IDriverConnector)this.testCloudDriverConnector);
        return driverCollector;
    }

    public IRunConfiguration cloneConfig() throws IOException {
        TestCloudRunConfiguration clone = new TestCloudRunConfiguration(this.projectDir);
        clone.testCloudDriverConnector = this.testCloudDriverConnector;
        return clone;
    }

    public String getReportDriverName() {
        return GlobalStringConstants.TESTCLOUD_NAME;
    }

    public Map<String, String> getAdditionalInfo() {
        Map info = super.getAdditionalInfo();
        info.put("isUsingTestCloudTunnel", Boolean.toString(this.testCloudDriverConnector.getTestCloudEntity().isUsingTunnel()));
        info.put(ExecutionMessageConstants.TEST_CLOUD_RUN_CONFIGURATION_KEY, this.getTestCloudRunConfiguration());
        return info;
    }

    public String getTestCloudRunConfiguration() {
        TestCloudSessionType testCloudSessionType = this.testCloudDriverConnector.getTestCloudSessionType();
        if (TestCloudSessionType.DESKTOP_BROWSER.equals((Object)testCloudSessionType)) {
            return TestCloudRunConfigurationType.DESKTOP.toString();
        }
        if (TestCloudSessionType.MOBILE_BROWSER.equals((Object)testCloudSessionType)) {
            return TestCloudRunConfigurationType.MOBILE_BROWSER.toString();
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)testCloudSessionType)) {
            return TestCloudRunConfigurationType.MOBILE_NATIVE.toString();
        }
        return "";
    }
}

