/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.service;

import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.mobile.core.interfaces.IMobileApplication;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import com.katalon.mobile.core.interfaces.MobileProvider;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudDevice;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionMode;
import com.kms.katalon.testcloud.core.model.TestCloudMobileApplication;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.service.TestCloudController;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Strings;

public class TestCloudProvider
extends MobileProvider {
    @Inject
    private TestCloudController controller;

    public List<IMobileDevice> getDevices(MobileDevicePlatform devicePlatform) {
        ArrayList<IMobileDevice> devices = new ArrayList<IMobileDevice>();
        MobilePlatform mobilePlatform = MobilePlatform.valueOf((String)devicePlatform.toString());
        List<TestCloudDevice> testCloudDevices = this.controller.requestTestCloudDevice(mobilePlatform);
        for (TestCloudDevice testCloudDevice : testCloudDevices) {
            TestCloudMobileDevice device = TestCloudMobileDevice.fromTestCloudMobileDevice((TestCloudDevice)testCloudDevice);
            devices.add((IMobileDevice)device);
        }
        if (devices != null && !devices.isEmpty()) {
            if (MobileDevicePlatform.ANDROID.equals((Object)devicePlatform)) {
                devices.sort(Comparator.comparing(d -> TestCloudProvider.androidPriority(d.getDeviceName())));
            } else if (MobileDevicePlatform.IOS.equals((Object)devicePlatform)) {
                devices.sort(Comparator.comparing(d -> TestCloudProvider.iosPriority(d.getDeviceName())));
            }
        }
        return devices;
    }

    public boolean isEnabled() {
        return this.controller.isIntegrationEnabled();
    }

    public List<IMobileApplication> getApplications(MobileDevicePlatform devicePlatform) {
        ArrayList<IMobileApplication> applications = new ArrayList<IMobileApplication>();
        MobilePlatform mobilePlatform = MobilePlatform.valueOf((String)devicePlatform.toString());
        List<TestCloudApplication> testCloudApplications = this.controller.requestTestCloudApplication(mobilePlatform);
        for (TestCloudApplication testCloudApplication : testCloudApplications) {
            TestCloudMobileApplication application = TestCloudMobileApplication.fromTestCloudApplication((TestCloudApplication)testCloudApplication);
            applications.add((IMobileApplication)application);
        }
        return applications;
    }

    public Map<String, Object> buildExecutionSettings(MobileDevicePlatform devicePlatform, String deviceId) throws TestCloudException {
        MobilePlatform mobilePlatform = MobilePlatform.valueOf((String)devicePlatform.toString());
        List<TestCloudDevice> testCloudDevices = this.controller.requestTestCloudDevice(mobilePlatform);
        TestCloudDevice device = testCloudDevices.stream().filter(d -> d.getCapability() != null).filter(d -> deviceId.equals(d.getCapability().getDeviceId())).findFirst().orElse(null);
        if (device == null) {
            throw new TestCloudException(String.format("The device with id %s not found", deviceId));
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map> executionProperties = new LinkedHashMap<String, Map>();
        executionProperties.put("general", DefaultExecutionSetting.buildExecutionSettingsForMobileRecorder());
        TestCloudRunConfiguration testCloudRunConfiguration = (TestCloudRunConfiguration)this.controller.buildRunConfiguration((TestCloudEntity)device, TestCloudSessionType.MOBILE_NATIVE, TestCloudExecutionMode.INSTANT);
        Map<String, IDriverConnector> driverConnectors = testCloudRunConfiguration.getDriverConnectors();
        executionProperties.put("drivers", this.getDriverExecutionProperties(driverConnectors));
        properties.put("execution", executionProperties);
        return properties;
    }

    private static int androidPriority(String name) {
        if (name == null) {
            return 2;
        }
        if (Strings.CI.contains((CharSequence)name, (CharSequence)"Any Phone")) {
            return 0;
        }
        return 1;
    }

    private static int iosPriority(String name) {
        if (name == null) {
            return 5;
        }
        if (Strings.CI.contains((CharSequence)name, (CharSequence)"Any iPhone")) {
            return 0;
        }
        if (Strings.CI.contains((CharSequence)name, (CharSequence)"Any iPad")) {
            return 1;
        }
        if (Strings.CI.contains((CharSequence)name, (CharSequence)"iPhone")) {
            return 2;
        }
        if (Strings.CI.contains((CharSequence)name, (CharSequence)"iPad")) {
            return 3;
        }
        return 4;
    }
}

