/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionGroup;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.groovy.eclipse.dsl.pointcuts.IPointcut;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.internal.core.NonJavaResource;

public class DSLDStore {
    private final Map<IPointcut, List<IContributionGroup>> pointcutContributionMap = new LinkedHashMap<IPointcut, List<IContributionGroup>>();
    private final Map<IStorage, Set<IPointcut>> keyContextMap = new HashMap<IStorage, Set<IPointcut>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContributionGroup(IPointcut pointcut, IContributionGroup contribution) {
        Map<IPointcut, List<IContributionGroup>> map = this.pointcutContributionMap;
        synchronized (map) {
            List<IContributionGroup> contributions = this.pointcutContributionMap.get(pointcut);
            if (contributions == null) {
                contributions = new ArrayList<IContributionGroup>();
                this.pointcutContributionMap.put(pointcut, contributions);
            }
            contributions.add(contribution);
        }
        IStorage identifier = pointcut.getContainerIdentifier();
        Map<IStorage, Set<IPointcut>> map2 = this.keyContextMap;
        synchronized (map2) {
            Set<IPointcut> pointcuts = this.keyContextMap.get(identifier);
            if (pointcuts == null) {
                pointcuts = new HashSet<IPointcut>();
                this.keyContextMap.put(identifier, pointcuts);
            }
            pointcuts.add(pointcut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeIdentifier(IStorage identifier) {
        Set<IPointcut> pointcuts;
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Purging pointcut for DSL file " + String.valueOf(identifier));
        }
        Map<Object, Collection<Object>> map = this.keyContextMap;
        synchronized (map) {
            pointcuts = this.keyContextMap.remove(identifier);
        }
        if (pointcuts != null) {
            map = this.pointcutContributionMap;
            synchronized (map) {
                for (IPointcut pointcut : pointcuts) {
                    this.pointcutContributionMap.remove(pointcut);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAll() {
        Map<Object, Collection<Object>> map = this.keyContextMap;
        synchronized (map) {
            this.keyContextMap.clear();
        }
        map = this.pointcutContributionMap;
        synchronized (map) {
            this.pointcutContributionMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSLDStore createSubStore(GroovyDSLDContext pattern) {
        DSLDStore subStore = new DSLDStore();
        Map<IPointcut, List<IContributionGroup>> map = this.pointcutContributionMap;
        synchronized (map) {
            for (Map.Entry<IPointcut, List<IContributionGroup>> entry : this.pointcutContributionMap.entrySet()) {
                if (!entry.getKey().fastMatch(pattern)) continue;
                subStore.addAllContributions(entry.getKey(), entry.getValue());
            }
        }
        return subStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllContributions(IPointcut pointcut, List<IContributionGroup> contributions) {
        Map<IPointcut, List<IContributionGroup>> map = this.pointcutContributionMap;
        synchronized (map) {
            List<IContributionGroup> existing = this.pointcutContributionMap.get(pointcut);
            if (existing == null) {
                this.pointcutContributionMap.put(pointcut, contributions);
            } else {
                existing.addAll(contributions);
            }
        }
    }

    public void addAllContexts(List<IPointcut> pointcuts, IContributionGroup contribution) {
        for (IPointcut pointcut : pointcuts) {
            this.addContributionGroup(pointcut, contribution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IContributionElement> findContributions(GroovyDSLDContext pattern, Set<String> disabledScripts) {
        ArrayList<IContributionElement> elts = new ArrayList<IContributionElement>();
        Map<IPointcut, List<IContributionGroup>> map = this.pointcutContributionMap;
        synchronized (map) {
            for (Map.Entry<IPointcut, List<IContributionGroup>> entry : this.pointcutContributionMap.entrySet()) {
                IPointcut pointcut = entry.getKey();
                if (disabledScripts.contains(DSLDStore.toUniqueString(pointcut.getContainerIdentifier()))) continue;
                pattern.resetBinding();
                Collection<?> results = pointcut.matches(pattern, pattern.getCurrentType());
                if (results == null) continue;
                for (IContributionGroup group : entry.getValue()) {
                    elts.addAll(group.getContributions(pattern, pattern.getCurrentBinding()));
                }
            }
        }
        return elts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStorage[] getAllContextKeys() {
        Map<IStorage, Set<IPointcut>> map = this.keyContextMap;
        synchronized (map) {
            return this.keyContextMap.keySet().toArray(new IStorage[0]);
        }
    }

    public static String toUniqueString(IStorage storage) {
        if (storage instanceof IFile) {
            return storage.getFullPath().toPortableString();
        }
        if (storage instanceof NonJavaResource) {
            return ((NonJavaResource)storage).getPackageFragmentRoot().getJavaProject().getElementName() + " (binary) " + storage.getName();
        }
        return storage.getName();
    }
}

