/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.proposals;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalProvider;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.groovy.eclipse.dsl.DSLDStore;
import org.codehaus.groovy.eclipse.dsl.DSLPreferences;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.IContributionElement;
import org.codehaus.groovy.eclipse.dsl.pointcuts.GroovyDSLDContext;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;

public class DSLDProposalProvider
implements IProposalProvider {
    public List<String> getNewFieldProposals(ContentAssistContext context) {
        return null;
    }

    public List<MethodNode> getNewMethodProposals(ContentAssistContext context) {
        return null;
    }

    public List<IGroovyProposal> getStatementAndExpressionProposals(ContentAssistContext context, ClassNode completionType, boolean isStatic, Set<ClassNode> categoryTypes) {
        String event = null;
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.DSL, "Getting DSL proposals for " + context.fullCompletionExpression);
            event = "DSL proposals";
            GroovyLogManager.manager.logStart(event);
        }
        ArrayList<IGroovyProposal> proposals = new ArrayList<IGroovyProposal>();
        try {
            DSLDStore store = GroovyDSLCoreActivator.getDefault().getContextStoreManager().getDSLDStore(context.unit.getJavaProject().getProject());
            ModuleNodeMapper.ModuleNodeInfo info = context.unit.getModuleInfo(true);
            if (info == null) {
                if (GroovyLogManager.manager.hasLoggers()) {
                    GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, "Null module node for " + context.unit.getElementName());
                }
            } else {
                GroovyDSLDContext dsldContext = new GroovyDSLDContext(context.unit, info.module, info.resolver);
                dsldContext.setCurrentScope(context.currentScope);
                dsldContext.setPrimaryNode(context.location == ContentAssistLocation.SCRIPT || context.location == ContentAssistLocation.STATEMENT || context.location == ContentAssistLocation.METHOD_CONTEXT && context.currentScope.isPrimaryNode());
                dsldContext.setStatic(isStatic);
                dsldContext.setTargetType(completionType);
                List<IContributionElement> contributions = store.findContributions(dsldContext, DSLPreferences.getDisabledScriptsAsSet());
                String completionString = context.getPerceivedCompletionExpression();
                boolean isMethodContext = context instanceof MethodInfoContentAssistContext;
                AssistOptions options = new AssistOptions(context.unit.getJavaProject().getOptions(true));
                for (IContributionElement element : contributions) {
                    if (!ProposalUtils.matches((String)completionString, (String)element.getContributionName(), (boolean)options.camelCaseMatch, (boolean)options.subwordMatch)) continue;
                    IGroovyProposal proposal = element.toProposal(completionType, dsldContext.getResolverCache());
                    if (proposal != null) {
                        proposals.add(proposal);
                    }
                    if (!isMethodContext) continue;
                    proposals.addAll(element.extraProposals(completionType, dsldContext.getResolverCache(), (Expression)context.completionNode));
                }
            }
        }
        catch (CoreException e) {
            GroovyDSLCoreActivator.logException(e);
        }
        if (event != null) {
            GroovyLogManager.manager.logEnd(event, TraceCategory.DSL);
        }
        return proposals;
    }
}

