/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.defect;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.services.defect.DefectServiceAsync;
import org.qas.qtest.api.services.defect.DefectServiceClient;
import org.qas.qtest.api.services.defect.model.CreateDefectRequest;
import org.qas.qtest.api.services.defect.model.Defect;

public class DefectServiceAsyncClient
extends DefectServiceClient
implements DefectServiceAsync {
    public DefectServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public DefectServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public DefectServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public DefectServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public DefectServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public DefectServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public DefectServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public DefectServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public DefectServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public DefectServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<Defect> createDefectAsync(final CreateDefectRequest createDefectRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Defect>(){

            @Override
            public Defect call() throws Exception {
                return DefectServiceAsyncClient.this.createDefect(createDefectRequest);
            }
        });
    }

    @Override
    public Future<Defect> createDefectAsync(final CreateDefectRequest createDefectRequest, final AsyncHandler<CreateDefectRequest, Defect> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Defect>(){

            @Override
            public Defect call() throws Exception {
                Defect result;
                try {
                    result = DefectServiceAsyncClient.this.createDefect(createDefectRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDefectRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Defect> addCommentAsync(final CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Defect>(){

            @Override
            public Defect call() throws Exception {
                return DefectServiceAsyncClient.this.addComment(createObjectCommentRequest);
            }
        });
    }

    @Override
    public Future<Defect> addCommentAsync(final CreateObjectCommentRequest createObjectCommentRequest, final AsyncHandler<CreateObjectCommentRequest, Defect> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Defect>(){

            @Override
            public Defect call() throws Exception {
                Defect result;
                try {
                    result = DefectServiceAsyncClient.this.addComment(createObjectCommentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createObjectCommentRequest, result);
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdown();
    }
}

