/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.plan;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.services.plan.TestPlanServiceAsync;
import org.qas.qtest.api.services.plan.TestPlanServiceClient;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.CreateBuildRequest;
import org.qas.qtest.api.services.plan.model.CreateReleaseRequest;
import org.qas.qtest.api.services.plan.model.Release;

public class TestPlanServiceAsyncClient
extends TestPlanServiceClient
implements TestPlanServiceAsync {
    public TestPlanServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public TestPlanServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public TestPlanServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public TestPlanServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public TestPlanServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public TestPlanServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public TestPlanServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public TestPlanServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public TestPlanServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public TestPlanServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<Build> createBuildAsync(final CreateBuildRequest createBuildRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Build>(){

            @Override
            public Build call() throws Exception {
                return TestPlanServiceAsyncClient.this.createBuild(createBuildRequest);
            }
        });
    }

    @Override
    public Future<Build> createBuildAsync(final CreateBuildRequest createBuildRequest, final AsyncHandler<CreateBuildRequest, Build> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Build>(){

            @Override
            public Build call() throws Exception {
                Build result;
                try {
                    result = TestPlanServiceAsyncClient.this.createBuild(createBuildRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createBuildRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Release> createReleaseAsync(final CreateReleaseRequest createReleaseRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Release>(){

            @Override
            public Release call() throws Exception {
                return TestPlanServiceAsyncClient.this.createRelease(createReleaseRequest);
            }
        });
    }

    @Override
    public Future<Release> createReleaseAsync(final CreateReleaseRequest createReleaseRequest, final AsyncHandler<CreateReleaseRequest, Release> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Release>(){

            @Override
            public Release call() throws Exception {
                Release result;
                try {
                    result = TestPlanServiceAsyncClient.this.createRelease(createReleaseRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createReleaseRequest, result);
                return result;
            }
        });
    }
}

