/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor;

import io.cucumber.eclipse.editor.CucumberServiceRegistry;
import io.cucumber.eclipse.editor.Tracing;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String ICON_CUKES = "icons/cukes.gif";
    public static final String PLUGIN_ID = "io.cucumber.eclipse.editor";
    public static final String DEBUG_MODEL_ID = "gherking.debugModel";
    private static Activator plugin;
    private static final Tracing TRACING;
    private ServiceRegistration<DebugOptionsListener> tracingRegistration;
    private ServiceTracker<CucumberServiceRegistry, CucumberServiceRegistry> serviceTracker;
    private BundleContext context;

    static {
        TRACING = new Tracing();
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        super.start(context);
        plugin = this;
        this.tracingRegistration = context.registerService(DebugOptionsListener.class, (Object)TRACING, new Hashtable<String, String>(Collections.singletonMap("listener.symbolic.name", PLUGIN_ID)));
        DocumentValidator.initialize();
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        this.closeTracker();
        DocumentValidator.shutdown();
        this.tracingRegistration.unregister();
        TRACING.optionsChanged(null);
        plugin = null;
        super.stop(context);
    }

    private synchronized void closeTracker() {
        if (this.serviceTracker == null) {
            return;
        }
        this.serviceTracker.close();
        this.serviceTracker = null;
    }

    private synchronized ServiceTracker<CucumberServiceRegistry, CucumberServiceRegistry> getServiceTracker() {
        if (this.serviceTracker == null && this.context != null) {
            this.serviceTracker = new ServiceTracker(this.context, CucumberServiceRegistry.class, null);
            this.serviceTracker.open();
        }
        return this.serviceTracker;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(ICON_CUKES, Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)ICON_CUKES));
    }

    public static Activator getDefault() {
        return plugin;
    }

    static synchronized CucumberServiceRegistry getService() {
        Activator activator = plugin;
        if (activator == null) {
            return null;
        }
        ServiceTracker<CucumberServiceRegistry, CucumberServiceRegistry> tracker = activator.getServiceTracker();
        if (tracker == null) {
            return null;
        }
        return (CucumberServiceRegistry)tracker.getService();
    }

    static ImageDescriptor getImageDescriptor(String icon) {
        Activator activator = plugin;
        if (activator == null) {
            return null;
        }
        return activator.getImageRegistry().getDescriptor(icon);
    }

    static Image getImage(String icon) {
        Activator activator = plugin;
        if (activator == null) {
            return null;
        }
        return activator.getImageRegistry().get(icon);
    }
}

