/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor;

import java.util.HashSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class CucumberActivitySupport {
    private static final String CONSOLE = "io.cucumber.eclipse.editor.console";
    private static final String LAUNCH = "io.cucumber.eclipse.editor.launch";
    private static final String PROPERTIES = "io.cucumber.eclipse.editor.properties";
    private static final String PREFERENCES = "io.cucumber.eclipse.editor.preferences";

    private static void setActivityEnabled(String activityId, boolean enabled) {
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        HashSet<String> enabledActivities = new HashSet<String>(activitySupport.getActivityManager().getEnabledActivityIds());
        if (enabled) {
            enabledActivities.add(activityId);
        } else {
            enabledActivities.remove(activityId);
        }
        activitySupport.setEnabledActivityIds(enabledActivities);
    }

    public static void disableAllCucumberActivities() {
        CucumberActivitySupport.enablePreferences(false);
        CucumberActivitySupport.enableProperties(false);
        CucumberActivitySupport.enableLaunch(false);
        CucumberActivitySupport.enableConsole(false);
    }

    public static void enableConsole(boolean enabled) {
        CucumberActivitySupport.setActivityEnabled(CONSOLE, enabled);
    }

    public static void enableLaunch(boolean enabled) {
        CucumberActivitySupport.setActivityEnabled(LAUNCH, enabled);
    }

    public static void enableProperties(boolean enabled) {
        CucumberActivitySupport.setActivityEnabled(PROPERTIES, enabled);
    }

    public static void enablePreferences(boolean enabled) {
        CucumberActivitySupport.setActivityEnabled(PREFERENCES, enabled);
    }
}

