/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension5;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorReconciler {
    private static final String FEATURE_CONTENT_TYPE = "io.cucumber.eclipse.editor.content-type.feature";

    public static void reconcileAllFeatureEditors() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ITextEditor textEditor;
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    IEditorPart editor = editorRef.getEditor(false);
                    if (editor instanceof ITextEditor && EditorReconciler.isFeatureEditor(textEditor = (ITextEditor)editor)) {
                        EditorReconciler.reconcileEditor(textEditor);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void reconcileFeatureEditor(IDocument document) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ITextEditor textEditor;
                    IDocumentProvider documentProvider;
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    IEditorPart editor = editorRef.getEditor(false);
                    if (editor instanceof ITextEditor && (documentProvider = (textEditor = (ITextEditor)editor).getDocumentProvider()) != null && documentProvider.getDocument((Object)editor.getEditorInput()) == document) {
                        EditorReconciler.reconcileEditor(textEditor);
                        return;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static boolean isFeatureEditor(ITextEditor editor) {
        try {
            IContentType contentType;
            ITextFileBuffer buffer;
            IDocument document;
            IDocumentProvider provider = editor.getDocumentProvider();
            if (provider != null && (document = provider.getDocument((Object)editor.getEditorInput())) != null && (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document)) != null && (contentType = buffer.getContentType()) != null && FEATURE_CONTENT_TYPE.equals(contentType.getId())) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private static void reconcileEditor(ITextEditor editor) {
        try {
            Object operationTarget;
            Object adapter = editor.getAdapter(ITextViewer.class);
            if (adapter instanceof ISourceViewerExtension5) {
                ISourceViewerExtension5 viewer = (ISourceViewerExtension5)adapter;
                viewer.updateCodeMinings();
            } else if (adapter == null && (operationTarget = editor.getAdapter(ITextOperationTarget.class)) instanceof ISourceViewerExtension5) {
                ISourceViewerExtension5 viewer = (ISourceViewerExtension5)operationTarget;
                viewer.updateCodeMinings();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

