/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class ResourceHelper {
    public static IResource find(String path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.findMember(path);
    }

    public static Set<IFile> getFeatureFilesInProject(IProject project) throws CoreException {
        final LinkedHashSet<IFile> featureFiles = new LinkedHashSet<IFile>();
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IFile file;
                if (resource instanceof IFile && "feature".equals((file = (IFile)resource).getFileExtension()) && !ResourceHelper.isDerived(file.getParent())) {
                    featureFiles.add(file);
                }
                return true;
            }
        });
        return featureFiles;
    }

    private static boolean isDerived(IContainer container) {
        if (container == null) {
            return false;
        }
        if (container.isDerived()) {
            return true;
        }
        return ResourceHelper.isDerived(container.getParent());
    }
}

