/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor;

import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;

public class Tracing
implements DebugOptionsListener {
    private static final DebugTrace NULL_DEBUG_TRACE = new NullDebugTrace();
    public static final String PERFORMANCE = "/perf";
    public static final String PERFORMANCE_STEPS = "/perf/steps";
    public static final String DEBUG = "/debug";
    public static final String DEBUG_LAUNCHING = "/debug/launching";
    public static final String DEBUG_VALIDATION = "/debug/validation";
    public static final String DEBUG_VALIDATION_GLUE = "/debug/validation/glue";
    public static final String DEBUG_SEARCH = "/debug/search";
    public static final String DEBUG_STEPS = "/debug/steps";
    public static volatile boolean PERF = false;
    public static volatile boolean PERF_STEPS = false;
    public static volatile boolean DEBUG_ENABLED = false;
    public static volatile boolean DEBUG_LAUNCHING_ENABLED = false;
    public static volatile boolean DEBUG_VALIDATION_ENABLED = false;
    public static volatile boolean DEBUG_VALIDATION_GLUE_ENABLED = false;
    public static volatile boolean DEBUG_SEARCH_ENABLED = false;
    public static volatile boolean DEBUG_STEPS_ENABLED = false;
    private static volatile DebugOptions options;

    Tracing() {
    }

    public void optionsChanged(DebugOptions options) {
        Tracing.options = options;
        if (options != null) {
            String pluginId = "io.cucumber.eclipse.editor";
            PERF = options.getBooleanOption(pluginId + PERFORMANCE, false);
            PERF_STEPS = options.getBooleanOption(pluginId + PERFORMANCE_STEPS, false);
            DEBUG_ENABLED = options.getBooleanOption(pluginId + DEBUG, false);
            DEBUG_LAUNCHING_ENABLED = options.getBooleanOption(pluginId + DEBUG_LAUNCHING, false);
            DEBUG_VALIDATION_ENABLED = options.getBooleanOption(pluginId + DEBUG_VALIDATION, false);
            DEBUG_VALIDATION_GLUE_ENABLED = options.getBooleanOption(pluginId + DEBUG_VALIDATION_GLUE, false);
            DEBUG_SEARCH_ENABLED = options.getBooleanOption(pluginId + DEBUG_SEARCH, false);
            DEBUG_STEPS_ENABLED = options.getBooleanOption(pluginId + DEBUG_STEPS, false);
        } else {
            PERF = false;
            PERF_STEPS = false;
            DEBUG_ENABLED = false;
            DEBUG_LAUNCHING_ENABLED = false;
            DEBUG_VALIDATION_ENABLED = false;
            DEBUG_VALIDATION_GLUE_ENABLED = false;
            DEBUG_SEARCH_ENABLED = false;
            DEBUG_STEPS_ENABLED = false;
        }
    }

    public static DebugTrace get() {
        DebugOptions debugOptions = options;
        if (debugOptions != null && debugOptions.isDebugEnabled()) {
            return debugOptions.newDebugTrace("io.cucumber.eclipse.editor");
        }
        return NULL_DEBUG_TRACE;
    }

    private static final class NullDebugTrace
    implements DebugTrace {
        private NullDebugTrace() {
        }

        public void trace(String option, String message) {
        }

        public void trace(String option, String message, Throwable error) {
        }

        public void traceDumpStack(String option) {
        }

        public void traceEntry(String option) {
        }

        public void traceEntry(String option, Object methodArgument) {
        }

        public void traceEntry(String option, Object[] methodArguments) {
        }

        public void traceExit(String option) {
        }

        public void traceExit(String option, Object result) {
        }
    }
}

