/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.builder;

import io.cucumber.eclipse.editor.ResourceHelper;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.validation.BatchUpdater;
import io.cucumber.eclipse.editor.validation.DocumentValidator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;

public class CucumberFeatureBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "io.cucumber.eclipse.editor.cucumberFeatureBuilder";

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BatchUpdater batch = DocumentValidator.batch();){
                LinkedHashSet<GherkinEditorDocument> documents = new LinkedHashSet<GherkinEditorDocument>();
                Set<IFile> featureFiles = ResourceHelper.getFeatureFilesInProject(project);
                for (IFile file : featureFiles) {
                    if (monitor.isCanceled()) break;
                    GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get((IResource)file, true);
                    if (editorDocument == null) continue;
                    documents.add(editorDocument);
                }
                if (!documents.isEmpty()) {
                    DocumentValidator.revalidateDocuments(project);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ILog.get().error("Failed to validate project: " + project.getName(), (Throwable)e);
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
    }

    public static void addBuilder(IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName(BUILDER_ID);
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    public static void removeBuilder(IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBuilder(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            int i = 0;
            while (true) {
                if (i >= commands.length) {
                    return false;
                }
                if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

