/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.codemining;

import io.cucumber.eclipse.editor.CucumberServiceRegistry;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.launching.ILauncher;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.editor.preferences.CucumberEditorPreferences;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;

public class CucumberRunCodeMiningProvider
implements ICodeMiningProvider {
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            IDocument document = viewer.getDocument();
            GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
            if (editorDocument == null) {
                return Collections.emptyList();
            }
            ArrayList list = new ArrayList();
            CucumberEditorPreferences preferences = CucumberEditorPreferences.of(editorDocument.getResource());
            Mode[] modeArray = Mode.values();
            int n = modeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mode mode = modeArray[n2];
                if (preferences.isShowShortcutFor(mode)) {
                    for (ILauncher launcher : CucumberServiceRegistry.getLauncher()) {
                        if (!launcher.supports(editorDocument.getResource()) || !launcher.supports(mode)) continue;
                        this.runnable(editorDocument.getScenarios(), Scenario::getLocation, editorDocument, launcher, mode).forEach(list::add);
                        this.runnable(editorDocument.getFeature().stream(), Feature::getLocation, editorDocument, launcher, mode).forEach(list::add);
                        this.runnable(editorDocument.getTags(), Tag::getLocation, editorDocument, launcher, mode).forEach(list::add);
                    }
                }
                ++n2;
            }
            return list;
        });
    }

    private <T> Stream<RunnableElementCodeMining> runnable(Stream<T> stream, Function<T, Location> locationProvider, GherkinEditorDocument document, ILauncher launcher, Mode mode) {
        return stream.map(runnable -> {
            Location location = (Location)locationProvider.apply(runnable);
            try {
                Position position = document.getEolPosition(location);
                return new RunnableElementCodeMining(position, runnable, launcher, mode, this);
            }
            catch (BadLocationException e) {
                return null;
            }
        }).filter(Objects::nonNull);
    }

    public void dispose() {
    }

    private static final class RunnableElementCodeMining
    extends LineContentCodeMining {
        AtomicReference<Consumer<MouseEvent>> action = new AtomicReference();
        private Object element;
        private Mode mode;
        private ILauncher launcher;

        public RunnableElementCodeMining(Position position, Object element, ILauncher launcher, Mode mode, ICodeMiningProvider provider) throws BadLocationException {
            super(position, provider);
            this.element = element;
            this.launcher = launcher;
            this.mode = mode;
        }

        protected CompletableFuture<Void> doResolve(final ITextViewer viewer, IProgressMonitor monitor) {
            return CompletableFuture.runAsync(() -> {
                this.setLabel((this.mode.ordinal() == 0 ? " " : "") + this.mode.getSymbol() + " " + this.mode.toString());
                this.action.set(event -> Job.create((String)"Launching Cucumber", (ICoreRunnable)new ICoreRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        launcher.launch(GherkinEditorDocumentManager.get(viewer.getDocument()), (IStructuredSelection)new StructuredSelection(this.getElement()), mode, !(element instanceof Feature), monitor);
                    }
                }).schedule());
            });
        }

        private Object getElement() {
            if (this.element instanceof Tag) {
                String name = ((Tag)this.element).getName();
                return TagExpressionParser.parse((String)name);
            }
            return this.element;
        }

        public Consumer<MouseEvent> getAction() {
            return this.action.get();
        }
    }
}

