/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.contentassist;

import io.cucumber.eclipse.editor.contentassist.CucumberTemplates;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.steps.ExpressionDefinition;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.LongestCommonSubsequenceDistance;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class CucumberStepContentAssistProcessor
implements IContentAssistProcessor {
    private static final int PREFIX_MATCH = 0x3FFFFFFF;
    private EditDistance<Integer> distance = new LongestCommonSubsequenceDistance();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return CucumberTemplates.computeTemplateProposals(viewer, offset, proposal -> {
            String prefix = proposal.getLinePrefix();
            ExpressionDefinition definition = proposal.getStepDefinition().getExpression();
            if (definition.getText().startsWith(prefix)) {
                proposal.setRelevance(0x3FFFFFFF);
            } else if (definition.matchIgnoreTypes(proposal.getLineText(), GherkinEditorDocumentManager.get(viewer.getDocument()).getLocale())) {
                proposal.setRelevance(Integer.MAX_VALUE);
            } else {
                String lineText = proposal.getLineText();
                String expressionText = proposal.getStepDefinition().getExpression().getTextWithoutVariables();
                int d = (Integer)this.distance.apply((CharSequence)lineText, (CharSequence)expressionText);
                proposal.setRelevance(0x3FFFFFFF - d);
            }
            return true;
        });
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

