/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.contentassist;

import io.cucumber.eclipse.editor.contentassist.CucumberTemplates;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.eclipse.editor.steps.ExpressionDefinition;
import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class CucumberStepQuickAssistProcessor
implements IQuickAssistProcessor {
    private EditDistance<Double> distance = new JaroWinklerDistance();

    public String getErrorMessage() {
        return null;
    }

    public boolean canFix(Annotation annotation) {
        return annotation instanceof MarkerAnnotation;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return GherkinEditorDocumentManager.isCompatibleTextBuffer(invocationContext.getSourceViewer().getDocument());
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ISourceViewer viewer = invocationContext.getSourceViewer();
        IDocument document = viewer.getDocument();
        try {
            int line = document.getLineOfOffset(invocationContext.getOffset());
            GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
            if (MarkerFactory.hasMarker(editorDocument.getResource(), "cucumber.eclipse.marker.gherkin.unmatched_step", line + 1)) {
                return CucumberTemplates.computeTemplateProposals((ITextViewer)viewer, invocationContext.getOffset(), proposal -> {
                    String lineText = proposal.getLineText();
                    ExpressionDefinition expression = proposal.getStepDefinition().getExpression();
                    if (expression.matchIgnoreTypes(lineText, editorDocument.getLocale())) {
                        proposal.setRelevance(Integer.MAX_VALUE);
                        return true;
                    }
                    String expressionText = expression.getTextWithoutVariables();
                    double sim = (Double)this.distance.apply((CharSequence)lineText, (CharSequence)expressionText);
                    proposal.setRelevance((int)(100.0 * sim));
                    return sim > 0.6;
                });
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }
}

