/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.contentassist;

import io.cucumber.cucumberexpressions.CucumberExpressionParserSupport;
import io.cucumber.eclipse.editor.CucumberServiceRegistry;
import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.Images;
import io.cucumber.eclipse.editor.contentassist.CucumberStepContentAssistProcessor;
import io.cucumber.eclipse.editor.contentassist.HtmlInformationControl;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.document.GherkinKeyword;
import io.cucumber.eclipse.editor.steps.IStepDefinitionsProvider;
import io.cucumber.eclipse.editor.steps.StepDefinition;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class CucumberTemplates {
    private static final TemplateContextType CONTEXT_TYPE = new TemplateContextType(CucumberStepContentAssistProcessor.class.getName(), "Cucumber");
    private static final ConcurrentMap<IProject, StepDefSearchJob> jobMap = new ConcurrentHashMap<IProject, StepDefSearchJob>();
    private static final Comparator<CucumberTemplateProposal> DISPLAYSTRING_ORDER = (t1, t2) -> t1.getDisplayString().compareToIgnoreCase(t2.getDisplayString());
    private static final Comparator<CucumberTemplateProposal> RELEVANCE_ORDER = (t1, t2) -> {
        int cmp = t2.getRelevance() - t1.getRelevance();
        if (cmp == 0) {
            return DISPLAYSTRING_ORDER.compare((CucumberTemplateProposal)((Object)t1), (CucumberTemplateProposal)((Object)t2));
        }
        return cmp;
    };

    public static ICompletionProposal[] computeTemplateProposals(ITextViewer viewer, int offset, Predicate<CucumberStepProposal> stepFilter) {
        block7: {
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)offset);
            if (model != null && model.anyPositionContains(offset)) {
                return null;
            }
            GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
            if (editorDocument == null) {
                return null;
            }
            try {
                IResource resource;
                IRegion line = document.getLineInformationOfOffset(offset);
                String currentLine = viewer.getDocument().get(line.getOffset(), offset - line.getOffset());
                String typed = currentLine.stripLeading();
                int stripped = currentLine.length() - typed.length();
                Optional<GherkinKeyword> keywordPrefix = editorDocument.getKeyWordOfLine(typed);
                if (!keywordPrefix.isPresent() || (resource = editorDocument.getResource()) == null) break block7;
                IProject project = resource.getProject();
                StepDefSearchJob job = jobMap.compute(project, (p, j) -> {
                    if (j == null) {
                        j = new StepDefSearchJob((IProject)p, viewer, offset);
                        j.schedule();
                    } else if (j.definitions != null) {
                        j.definitions = null;
                        j.viewer = viewer;
                        j.offset = offset;
                        j.schedule();
                    }
                    return j;
                });
                try {
                    job.join();
                    Collection<StepDefinition> steps = job.definitions;
                    if (steps != null) {
                        GherkinKeyword gherkinKeyword = keywordPrefix.get();
                        String keyWord = gherkinKeyword.getKey();
                        int keyWordLength = keyWord.length() + 1 + stripped;
                        int keyWordOffset = line.getOffset() + keyWordLength;
                        String fullLine = document.get(line.getOffset(), line.getLength()).stripLeading();
                        String text = fullLine.substring(keyWord.length() + 1);
                        String prefix = typed.substring(keyWord.length() + 1);
                        Region region = new Region(keyWordOffset, line.getLength() - keyWordLength);
                        CucumberDocumentTemplateContext ctx = new CucumberDocumentTemplateContext(viewer.getDocument(), (IRegion)region);
                        Image icon = Images.getCukesIcon();
                        ICompletionProposal[] proposals = (ICompletionProposal[])steps.parallelStream().map(stepDefinition -> new CucumberStepProposal((StepDefinition)stepDefinition, gherkinKeyword, text, prefix)).filter(stepProposal -> stepFilter.test((CucumberStepProposal)stepProposal)).map(arg_0 -> CucumberTemplates.lambda$5(ctx, (IRegion)region, icon, arg_0)).sorted(RELEVANCE_ORDER).toArray(ICompletionProposal[]::new);
                        return proposals;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (BadLocationException e) {
                EditorLogging.error("Invalid location encountered while computing context information", e);
            }
        }
        return null;
    }

    private static /* synthetic */ CucumberTemplateProposal lambda$5(CucumberDocumentTemplateContext cucumberDocumentTemplateContext, IRegion iRegion, Image image, CucumberStepProposal stepProposal) {
        return new CucumberTemplateProposal(stepProposal.getTemplate(), (TemplateContext)cucumberDocumentTemplateContext, iRegion, image, stepProposal.relevance, stepProposal.getStepDefinition().getDescription());
    }

    private static final class CucumberDocumentTemplateContext
    extends DocumentTemplateContext {
        public CucumberDocumentTemplateContext(IDocument document, IRegion region) {
            super(CONTEXT_TYPE, document, region.getOffset(), region.getLength());
        }

        public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
            TemplateBuffer buffer = CucumberExpressionParserSupport.evaluate(template);
            this.getContextType().resolve(buffer, (TemplateContext)this);
            return buffer;
        }
    }

    public static class CucumberStepProposal {
        private StepDefinition stepDefinition;
        private GherkinKeyword gherkinKeyword;
        private String text;
        private String typed;
        private Template template;
        private int relevance;

        private CucumberStepProposal(StepDefinition stepDefinition, GherkinKeyword gherkinKeyword, String text, String typed) {
            this.stepDefinition = stepDefinition;
            this.gherkinKeyword = gherkinKeyword;
            this.text = text;
            this.typed = typed;
        }

        public Template getTemplate() {
            if (this.template == null) {
                this.template = CucumberExpressionParserSupport.createTemplate(this.stepDefinition, CONTEXT_TYPE.getId());
            }
            return this.template;
        }

        public void setRelevance(int relevance) {
            this.relevance = relevance;
        }

        public String getLineText() {
            return this.text;
        }

        public GherkinKeyword getGherkinKeyword() {
            return this.gherkinKeyword;
        }

        public String getLinePrefix() {
            return this.typed;
        }

        public StepDefinition getStepDefinition() {
            return this.stepDefinition;
        }
    }

    private static final class CucumberTemplateProposal
    extends TemplateProposal {
        private String description;

        public CucumberTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance, final String description) {
            super(template, context, region, image, relevance);
            this.description = description;
            if (description != null && description.startsWith("<html")) {
                this.setInformationControlCreator(new IInformationControlCreator(){

                    public IInformationControl createInformationControl(Shell parent) {
                        return new HtmlInformationControl(parent, description);
                    }
                });
            }
        }

        public String getAdditionalProposalInfo() {
            if (this.description != null) {
                return this.description;
            }
            return this.getTemplate().getDescription();
        }

        public String getDisplayString() {
            return this.getTemplate().getPattern();
        }
    }

    private static final class StepDefSearchJob
    extends Job {
        private final IProject project;
        private volatile Collection<StepDefinition> definitions;
        private ITextViewer viewer;
        private int offset;

        public StepDefSearchJob(IProject project, ITextViewer viewer, int offset) {
            super("Compute Step definitions");
            this.project = project;
            this.viewer = viewer;
            this.offset = offset;
            this.setUser(false);
            this.setPriority(40);
        }

        public IStatus run(IProgressMonitor monitor) {
            List<IStepDefinitionsProvider> providers = CucumberServiceRegistry.getStepDefinitionsProvider((IResource)this.project);
            this.definitions = providers.stream().flatMap(provider -> {
                try {
                    return provider.findStepDefinitions(this.viewer, this.offset, (IResource)this.project, monitor).stream();
                }
                catch (CoreException e) {
                    EditorLogging.error(e.getStatus().getMessage(), e);
                }
                catch (RuntimeException e) {
                    EditorLogging.error("Internal error while computing step definitions", e);
                }
                return Stream.empty();
            }).collect(Collectors.toList());
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

