/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.contentassist;

import io.cucumber.eclipse.editor.EditorLogging;
import io.cucumber.eclipse.editor.Images;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.document.GherkinEditorDocumentManager;
import io.cucumber.eclipse.editor.document.GherkinKeyword;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class GherkinContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
        try {
            IRegion line = viewer.getDocument().getLineInformationOfOffset(offset);
            String typed = viewer.getDocument().get(line.getOffset(), offset - line.getOffset()).stripLeading();
            String nl = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            if (typed.isBlank()) {
                Optional<Feature> feature = editorDocument.getFeature();
                if (feature.isEmpty()) {
                    return (ICompletionProposal[])editorDocument.getFeatureKeywords().filter(keyWord -> keyWord.prefix(typed)).map(featureKeyWord -> GherkinContentAssistProcessor.createFeatureKeyWordProposal(featureKeyWord.getKey(), offset, typed)).toArray(ICompletionProposal[]::new);
                }
                Predicate<FeatureChild> hasTopLevelElement = f -> f.getBackground().isPresent();
                hasTopLevelElement = hasTopLevelElement.or(f -> f.getRule().isPresent());
                hasTopLevelElement = hasTopLevelElement.or(f -> f.getScenario().isPresent());
                if (editorDocument.getFeatureChilds().filter(hasTopLevelElement).count() == 0L) {
                    return (ICompletionProposal[])editorDocument.getTopLevelKeywords().filter(keyWord -> keyWord.prefix(typed)).sorted(GherkinKeyword.KEY_ORDER).map(keyWord -> this.createCompletionProposal(offset, typed, keyWord.getKey(), keyWord.getKey() + ":" + nl)).toArray(ICompletionProposal[]::new);
                }
            }
            ArrayList result = new ArrayList();
            editorDocument.getTopLevelKeywords().filter(keyWord -> keyWord.prefix(typed)).sorted(GherkinKeyword.KEY_ORDER).map(keyWord -> this.createCompletionProposal(offset, typed, keyWord.getKey(), keyWord.getKey() + ":" + nl)).forEach(result::add);
            editorDocument.getStepElementKeywords().filter(keyWord -> keyWord.prefix(typed)).sorted(GherkinKeyword.KEY_ORDER).map(keyWord -> this.createCompletionProposal(offset, typed, keyWord.getKey(), keyWord.getKey() + " ")).forEach(result::add);
            return (ICompletionProposal[])result.toArray(ICompletionProposal[]::new);
        }
        catch (BadLocationException e) {
            EditorLogging.error("Invalid location encountered while computing proposals", e);
            return null;
        }
    }

    private CompletionProposal createCompletionProposal(int offset, String typed, String displayString, String fullString) {
        return new CompletionProposal(fullString, offset - typed.length(), typed.length(), fullString.length(), Images.getCukesIcon(), displayString, null, null);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        GherkinEditorDocument editorDocument = GherkinEditorDocumentManager.get(document);
        editorDocument.keyWords(GherkinDialect::getFeatureKeywords);
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        return str.toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        System.out.println("getContextInformationValidator()");
        return new IContextInformationValidator(){

            public boolean isContextInformationValid(int offset) {
                System.out.println("isContextInformationValid()");
                return true;
            }

            public void install(IContextInformation info, ITextViewer viewer, int offset) {
                System.out.println("install()");
            }
        };
    }

    private static CompletionProposal createFeatureKeyWordProposal(String keyWord, int offset, String typed) {
        String fullString = keyWord + ": ";
        return new CompletionProposal(fullString, offset - typed.length(), typed.length(), fullString.length(), Images.getCukesIcon(), keyWord, (IContextInformation)new ContextInformation("Name of Feature", "Enter the Name of the Feature under test"), "Start a new feature");
    }
}

