/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.debug;

import io.cucumber.eclipse.editor.debug.GherkingBreakpoint;
import io.cucumber.eclipse.editor.debug.GherkingDebugElement;
import io.cucumber.eclipse.editor.debug.GherkingThread;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;

public class GherkingDebugTarget<Process extends IProcess & ISuspendResume>
extends GherkingDebugElement
implements IDebugTarget {
    private Process endpointProcess;
    private ILaunch launch;
    private GherkingThread thread;
    private String name;

    public GherkingDebugTarget(ILaunch launch, Process endpointProcess, String name) {
        super(null);
        this.launch = launch;
        this.endpointProcess = endpointProcess;
        this.name = name;
        this.thread = new GherkingThread(this);
    }

    public GherkingThread getThread() {
        return this.thread;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public String getModelIdentifier() {
        return GherkingBreakpoint.MODEL_ID;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public boolean canTerminate() {
        return this.endpointProcess.isTerminated();
    }

    public boolean isTerminated() {
        return this.endpointProcess.isTerminated();
    }

    public void terminate() throws DebugException {
        this.endpointProcess.terminate();
    }

    public boolean canResume() {
        return ((ISuspendResume)this.endpointProcess).canResume();
    }

    public boolean canSuspend() {
        return ((ISuspendResume)this.endpointProcess).canSuspend();
    }

    public boolean isSuspended() {
        return ((ISuspendResume)this.endpointProcess).isSuspended();
    }

    public void resume() throws DebugException {
        ((ISuspendResume)this.endpointProcess).resume();
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        ((ISuspendResume)this.endpointProcess).suspend();
        this.fireSuspendEvent(32);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return ((IDisconnect)this.endpointProcess).canDisconnect();
    }

    public void disconnect() throws DebugException {
        ((IDisconnect)this.endpointProcess).disconnect();
    }

    public boolean isDisconnected() {
        return ((IDisconnect)this.endpointProcess).isDisconnected();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "not supported"));
    }

    public Process getProcess() {
        return this.endpointProcess;
    }

    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated()) {
            return new IThread[0];
        }
        return new IThread[]{this.thread};
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof GherkingBreakpoint;
    }
}

