/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.debug;

import io.cucumber.eclipse.editor.debug.GherkingDebugElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class GherkingStackFrame
extends GherkingDebugElement
implements IStackFrame {
    private IThread thread;
    private int lineNumber;
    private String name;
    private List<IVariable> variables = new ArrayList<IVariable>();

    public GherkingStackFrame(IThread thread, int lineNumber, String name) {
        super(thread.getDebugTarget());
        this.thread = thread;
        this.lineNumber = lineNumber;
        this.name = name;
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return (IVariable[])this.variables.toArray(IVariable[]::new);
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.size() > 0;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public void addVariable(IVariable variable) {
        this.variables.add(variable);
    }
}

